/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.internal.core.peers.TaggedWeakPeerBinding;
import com.couchbase.lite.internal.sockets.SocketFromCore;
import com.couchbase.lite.internal.sockets.SocketToCore;

public interface BaseSocketFactory {
    @NonNull
    @VisibleForTesting
    public static final TaggedWeakPeerBinding<BaseSocketFactory> BOUND_SOCKET_FACTORIES = new TaggedWeakPeerBinding();

    public static long bindSocketFactory(@NonNull BaseSocketFactory socketFactory) {
        long token = BOUND_SOCKET_FACTORIES.reserveKey();
        BOUND_SOCKET_FACTORIES.bind(token, socketFactory);
        return token;
    }

    @Nullable
    public static BaseSocketFactory getBoundSocketFactory(long token) {
        return (BaseSocketFactory)BOUND_SOCKET_FACTORIES.getBinding(token);
    }

    public static void unbindSocketFactory(long token) {
        BOUND_SOCKET_FACTORIES.unbind(token);
    }

    @NonNull
    public SocketFromCore createSocket(@NonNull SocketToCore var1, @NonNull String var2, @NonNull String var3, int var4, @NonNull String var5, @NonNull byte[] var6);
}

