/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.impl.NativeC4Blob;

public final class C4BlobKey
extends C4NativePeer {
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeC4Blob();
    private final NativeImpl impl;

    @NonNull
    public static C4BlobKey create(@Nullable String str) throws LiteCoreException {
        return new C4BlobKey(NATIVE_IMPL, str);
    }

    @NonNull
    public static C4BlobKey create(long peer) {
        return new C4BlobKey(NATIVE_IMPL, peer);
    }

    @VisibleForTesting
    public C4BlobKey(@NonNull NativeImpl impl, @Nullable String str) throws LiteCoreException {
        this(impl, impl.nFromString(str));
    }

    private C4BlobKey(@NonNull NativeImpl impl, long peer) {
        super(peer);
        this.impl = impl;
    }

    @Override
    public void close() {
        this.closePeer(null);
    }

    @Override
    @NonNull
    public String toString() {
        return this.withPeerOrDefault("unknown", this.impl::nToString);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.DATABASE);
        }
        finally {
            super.finalize();
        }
    }

    long getHandle() {
        return this.getPeer();
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, peer -> {
            NativeImpl nativeImpl = this.impl;
            if (nativeImpl != null) {
                nativeImpl.nFree((long)peer);
            }
        });
    }

    public static interface NativeImpl {
        public long nFromString(@Nullable String var1) throws LiteCoreException;

        @Nullable
        public String nToString(long var1);

        public void nFree(long var1);
    }
}

