/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.internal.core.C4BlobKey;
import com.couchbase.lite.internal.core.C4BlobReadStream;
import com.couchbase.lite.internal.core.C4BlobWriteStream;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.impl.NativeC4Blob;
import com.couchbase.lite.internal.fleece.FLSliceResult;

public abstract class C4BlobStore
extends C4NativePeer {
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeC4Blob();
    private final NativeImpl impl;

    @NonNull
    public static C4BlobStore create(long peer) throws LiteCoreException {
        return new UnmanagedC4BlobStore(NATIVE_IMPL, NATIVE_IMPL.nGetBlobStore(peer));
    }

    private C4BlobStore(@NonNull NativeImpl impl, long peer) {
        super(peer);
        this.impl = impl;
    }

    @VisibleForTesting
    C4BlobStore(long peer) {
        this(NATIVE_IMPL, peer);
    }

    public long getSize(@NonNull C4BlobKey blobKey) {
        return this.withPeerOrDefault(-1L, peer -> this.impl.nGetSize((long)peer, blobKey.getHandle()));
    }

    @NonNull
    public FLSliceResult getContents(@NonNull C4BlobKey blobKey) throws LiteCoreException {
        return this.withPeerOrThrow(peer -> this.impl.nGetContents((long)peer, blobKey.getHandle()));
    }

    @Nullable
    public String getFilePath(@NonNull C4BlobKey blobKey) throws LiteCoreException {
        return this.withPeerOrNull(peer -> this.impl.nGetFilePath((long)peer, blobKey.getHandle()));
    }

    @NonNull
    public C4BlobKey create(@NonNull byte[] contents) throws LiteCoreException {
        return this.withPeerOrThrow(peer -> C4BlobKey.create(this.impl.nCreate((long)peer, contents)));
    }

    public void delete(@NonNull C4BlobKey blobKey) throws LiteCoreException {
        this.withPeer(peer -> this.impl.nDelete((long)peer, blobKey.getHandle()));
    }

    @NonNull
    public C4BlobReadStream openReadStream(@NonNull C4BlobKey blobKey) throws LiteCoreException {
        return this.withPeerOrThrow(peer -> new C4BlobReadStream(this.impl, this.impl.nOpenReadStream((long)peer, blobKey.getHandle())));
    }

    @NonNull
    public C4BlobWriteStream openWriteStream() throws LiteCoreException {
        return new C4BlobWriteStream(this.impl, this.withPeerOrThrow(this.impl::nOpenWriteStream));
    }

    @Override
    public void close() {
        this.releasePeer(null, null);
    }

    public static interface NativeImpl {
        public long nGetBlobStore(long var1) throws LiteCoreException;

        public long nGetSize(long var1, long var3);

        @NonNull
        public FLSliceResult nGetContents(long var1, long var3) throws LiteCoreException;

        @Nullable
        public String nGetFilePath(long var1, long var3) throws LiteCoreException;

        public long nCreate(long var1, byte[] var3) throws LiteCoreException;

        public void nDelete(long var1, long var3) throws LiteCoreException;

        public long nOpenReadStream(long var1, long var3) throws LiteCoreException;

        public long nOpenWriteStream(long var1) throws LiteCoreException;

        public int nRead(long var1, byte[] var3, int var4, long var5) throws LiteCoreException;

        public long nGetLength(long var1) throws LiteCoreException;

        public void nSeek(long var1, long var3) throws LiteCoreException;

        public void nCloseWriteStream(long var1);

        public void nWrite(long var1, byte[] var3, int var4) throws LiteCoreException;

        public long nComputeBlobKey(long var1) throws LiteCoreException;

        public void nInstall(long var1) throws LiteCoreException;

        public void nCloseReadStream(long var1);
    }

    private static final class UnmanagedC4BlobStore
    extends C4BlobStore {
        UnmanagedC4BlobStore(@NonNull NativeImpl impl, long peer) {
            super(impl, peer);
        }
    }
}

