/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.AbstractReplicator;
import com.couchbase.lite.Collection;
import com.couchbase.lite.CollectionConfiguration;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.MaintenanceType;
import com.couchbase.lite.ReplicatorType;
import com.couchbase.lite.internal.QueryLanguage;
import com.couchbase.lite.internal.SocketFactory;
import com.couchbase.lite.internal.core.C4BlobStore;
import com.couchbase.lite.internal.core.C4Collection;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.C4Query;
import com.couchbase.lite.internal.core.C4Replicator;
import com.couchbase.lite.internal.core.C4Socket;
import com.couchbase.lite.internal.core.impl.NativeC4Database;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLSharedKeys;
import com.couchbase.lite.internal.sockets.MessageFraming;
import com.couchbase.lite.internal.utils.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public abstract class C4Database
extends C4NativePeer {
    public static final boolean VERSION_VECTORS_ENABLED = false;
    @VisibleForTesting
    static final int DB_FLAGS = 1;
    @VisibleForTesting
    public static final String DB_EXTENSION = ".cblite2";
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeC4Database();
    @NonNull
    private static final Map<MaintenanceType, Integer> MAINTENANCE_TYPE_MAP;
    @NonNull
    private final NativeImpl impl;
    @NonNull
    private final String name;
    @NonNull
    final AtomicReference<File> dbFile = new AtomicReference();

    @NonNull
    public static C4Database getUnmanagedDatabase(long peer) {
        return new UnmanagedC4Database(NATIVE_IMPL, peer);
    }

    @NonNull
    public static C4Database getDatabase(@NonNull String parentDirPath, @NonNull String name, boolean isFullSync, int algorithm, @Nullable byte[] encryptionKey) throws LiteCoreException {
        int dbFlags = 1;
        if (isFullSync) {
            dbFlags |= 0x80;
        }
        return C4Database.getDatabase(NATIVE_IMPL, parentDirPath, name, dbFlags, algorithm, encryptionKey);
    }

    @VisibleForTesting
    @NonNull
    static C4Database getDatabase(@NonNull String parentDirPath, @NonNull String name, int flags) throws LiteCoreException {
        return C4Database.getDatabase(NATIVE_IMPL, parentDirPath, name, flags, 0, null);
    }

    @VisibleForTesting
    @NonNull
    static C4Database getDatabase(@NonNull NativeImpl impl, @NonNull String parentDirPath, @NonNull String name, int flags, int algorithm, @Nullable byte[] encryptionKey) throws LiteCoreException {
        boolean pathOk = false;
        try {
            File parentDir = new File(parentDirPath);
            parentDirPath = parentDir.getCanonicalPath();
            pathOk = parentDir.exists() && parentDir.isDirectory();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!pathOk) {
            throw new LiteCoreException(1, 21, "Parent directory does not exist or is not a directory: " + parentDirPath);
        }
        return new ManagedC4Database(impl, name, impl.nOpen(parentDirPath, name, flags, algorithm, encryptionKey));
    }

    public static void copyDb(@NonNull String sourcePath, @NonNull String parentDir, @NonNull String name, int algorithm, @Nullable byte[] encryptionKey) throws LiteCoreException {
        C4Database.copyDb(NATIVE_IMPL, sourcePath, parentDir, name, 1, algorithm, encryptionKey);
    }

    @VisibleForTesting
    static void copyDb(@NonNull String sourcePath, @NonNull String parentDir, @NonNull String name, int flags) throws LiteCoreException {
        C4Database.copyDb(NATIVE_IMPL, sourcePath, parentDir, name, flags, 0, null);
    }

    @VisibleForTesting
    static void copyDb(@NonNull NativeImpl impl, @NonNull String sourcePath, @NonNull String parentDir, @NonNull String name, int flags, int algorithm, @Nullable byte[] encryptionKey) throws LiteCoreException {
        if (sourcePath.charAt(sourcePath.length() - 1) != File.separatorChar) {
            sourcePath = sourcePath + File.separator;
        }
        if (parentDir.charAt(parentDir.length() - 1) != File.separatorChar) {
            parentDir = parentDir + File.separator;
        }
        impl.nCopy(sourcePath, parentDir, name, flags, algorithm, encryptionKey);
    }

    public static void deleteNamedDb(@NonNull String directory, @NonNull String name) throws LiteCoreException {
        NATIVE_IMPL.nDeleteNamed(name, directory);
    }

    @NonNull
    public static File getDatabaseFile(@NonNull File directory, @NonNull String name) {
        return new File(directory, name + DB_EXTENSION);
    }

    protected C4Database(@NonNull NativeImpl impl, @NonNull String name, long peer) {
        super(peer);
        this.name = name;
        this.impl = impl;
    }

    @Override
    @NonNull
    public String toString() {
        return this.name + "@" + super.toString();
    }

    @Override
    public abstract void close();

    public void closeDb() throws LiteCoreException {
        this.impl.nClose(this.getPeer());
        this.close();
    }

    @Nullable
    public String getDbPath() {
        File file = this.getDbFile();
        return file == null ? null : file.getPath() + File.separator;
    }

    @Nullable
    public String getDbDirectory() {
        File file = this.getDbFile();
        return file == null ? null : file.getParent();
    }

    @Nullable
    public String getDbFileName() {
        File file = this.getDbFile();
        return file == null ? null : file.getName();
    }

    @Nullable
    public String getDbName() {
        String dbFileName = this.getDbFileName();
        if (dbFileName == null) {
            return null;
        }
        if (dbFileName.endsWith(DB_EXTENSION)) {
            dbFileName = dbFileName.substring(0, dbFileName.length() - DB_EXTENSION.length());
        }
        return dbFileName;
    }

    public void deleteDb() throws LiteCoreException {
        this.impl.nDelete(this.getPeer());
        this.close();
    }

    @NonNull
    public byte[] getPublicUUID() throws LiteCoreException {
        return this.impl.nGetPublicUUID(this.getPeer());
    }

    @NonNull
    public C4BlobStore getBlobStore() throws LiteCoreException {
        return C4BlobStore.create(this.getPeer());
    }

    public void beginTransaction() throws LiteCoreException {
        this.impl.nBeginTransaction(this.getPeer());
    }

    public void endTransaction(boolean commit) throws LiteCoreException {
        this.impl.nEndTransaction(this.getPeer(), commit);
    }

    public void rekey(int keyType, byte[] newKey) throws LiteCoreException {
        this.impl.nRekey(this.getPeer(), keyType, newKey);
    }

    public boolean performMaintenance(MaintenanceType type) throws LiteCoreException {
        return this.impl.nMaintenance(this.getPeer(), Preconditions.assertNotNull(MAINTENANCE_TYPE_MAP.get((Object)type), "Unrecognized maintenance type: " + (Object)((Object)type)));
    }

    public void setCookie(@NonNull URI uri, @NonNull String setCookieHeader, boolean acceptParentDomain) throws LiteCoreException {
        this.impl.nSetCookie(this.getPeer(), uri.toString(), setCookieHeader, acceptParentDomain);
    }

    @Nullable
    public String getCookies(@NonNull URI uri) throws LiteCoreException {
        return this.impl.nGetCookies(this.getPeer(), uri.toString());
    }

    @NonNull
    public FLEncoder getSharedFleeceEncoder() {
        return FLEncoder.getUnmanagedEncoder(this.impl.nGetSharedFleeceEncoder(this.getPeer()));
    }

    @NonNull
    public FLSharedKeys getFLSharedKeys() {
        return new FLSharedKeys(this.impl.nGetFLSharedKeys(this.getPeer()));
    }

    @NonNull
    public Set<String> getScopeNames() throws LiteCoreException {
        return this.impl.nGetScopeNames(this.getPeer());
    }

    public boolean hasScope(@NonNull String scope) {
        return this.impl.nHasScope(this.getPeer(), scope);
    }

    @NonNull
    public Set<String> getCollectionNames(@NonNull String scope) throws LiteCoreException {
        return this.impl.nGetCollectionNames(this.getPeer(), scope);
    }

    @NonNull
    public C4Collection addCollection(@NonNull String scopeName, @NonNull String collectionName) throws LiteCoreException {
        return C4Collection.create(this, scopeName, collectionName);
    }

    @Nullable
    public C4Collection getCollection(@NonNull String scopeName, @NonNull String collectionName) throws LiteCoreException {
        return C4Collection.get(this, scopeName, collectionName);
    }

    @NonNull
    public final C4Collection getDefaultCollection() throws LiteCoreException {
        return C4Collection.getDefault(this);
    }

    public void deleteCollection(@NonNull String scopeName, @NonNull String collectionName) throws LiteCoreException {
        this.impl.nDeleteCollection(this.getPeer(), scopeName, collectionName);
    }

    @NonNull
    public C4Replicator createRemoteReplicator(@NonNull Map<Collection, CollectionConfiguration> collections, @Nullable String scheme, @Nullable String host, int port, @Nullable String path, @Nullable String remoteDbName, @NonNull MessageFraming framing, @NonNull ReplicatorType type, boolean continuous, @Nullable Map<String, Object> options, @NonNull C4Replicator.StatusListener statusListener, @NonNull C4Replicator.DocEndsListener docEndsListener, @NonNull AbstractReplicator replicator, @Nullable SocketFactory socketFactory) throws LiteCoreException {
        return C4Replicator.createRemoteReplicator(collections, this.getPeer(), scheme, host, port, path, remoteDbName, framing, type, continuous, options, statusListener, docEndsListener, replicator, socketFactory);
    }

    @NonNull
    public C4Replicator createLocalReplicator(@NonNull Map<Collection, CollectionConfiguration> collections, @NonNull C4Database targetDb, @NonNull ReplicatorType type, boolean continuous, @Nullable Map<String, Object> options, @NonNull C4Replicator.StatusListener statusListener, @NonNull C4Replicator.DocEndsListener docEndsListener, @NonNull AbstractReplicator replicator) throws LiteCoreException {
        return C4Replicator.createLocalReplicator(collections, this.getPeer(), targetDb, type, continuous, options, statusListener, docEndsListener, replicator);
    }

    @NonNull
    public C4Replicator createMessageEndpointReplicator(@NonNull Set<Collection> collections, @NonNull C4Socket c4Socket, @Nullable Map<String, Object> options, @NonNull C4Replicator.StatusListener statusListener) throws LiteCoreException {
        return C4Replicator.createMessageEndpointReplicator(collections, this.getPeer(), c4Socket, options, statusListener);
    }

    @NonNull
    public C4Query createJsonQuery(@NonNull String expression) throws LiteCoreException {
        return C4Query.create(this, QueryLanguage.JSON, expression);
    }

    @NonNull
    public C4Query createN1qlQuery(@NonNull String expression) throws LiteCoreException {
        return C4Query.create(this, QueryLanguage.N1QL, expression);
    }

    long getHandle() {
        return this.getPeer();
    }

    @Nullable
    private File getDbFile() {
        File file = this.dbFile.get();
        if (file != null) {
            return file;
        }
        String path = this.impl.nGetPath(this.getPeer());
        if (path == null) {
            return null;
        }
        try {
            this.dbFile.compareAndSet(null, new File(path).getCanonicalFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.dbFile.get();
    }

    static {
        HashMap<MaintenanceType, Integer> m = new HashMap<MaintenanceType, Integer>();
        m.put(MaintenanceType.COMPACT, 0);
        m.put(MaintenanceType.REINDEX, 1);
        m.put(MaintenanceType.INTEGRITY_CHECK, 2);
        m.put(MaintenanceType.OPTIMIZE, 3);
        m.put(MaintenanceType.FULL_OPTIMIZE, 4);
        MAINTENANCE_TYPE_MAP = Collections.unmodifiableMap(m);
    }

    static final class UnmanagedC4Database
    extends C4Database {
        UnmanagedC4Database(@NonNull NativeImpl impl, long peer) {
            super(impl, "shell", peer);
        }

        @Override
        public void close() {
            this.releasePeer(null, null);
        }
    }

    public static interface NativeImpl {
        public long nOpen(@NonNull String var1, @NonNull String var2, int var3, int var4, byte[] var5) throws LiteCoreException;

        public void nClose(long var1) throws LiteCoreException;

        public void nFree(long var1);

        @Nullable
        public String nGetPath(long var1);

        public void nCopy(String var1, String var2, String var3, int var4, int var5, byte[] var6) throws LiteCoreException;

        public void nDelete(long var1) throws LiteCoreException;

        public void nDeleteNamed(@NonNull String var1, @NonNull String var2) throws LiteCoreException;

        @NonNull
        public byte[] nGetPublicUUID(long var1) throws LiteCoreException;

        public void nBeginTransaction(long var1) throws LiteCoreException;

        public void nEndTransaction(long var1, boolean var3) throws LiteCoreException;

        public boolean nMaintenance(long var1, int var3) throws LiteCoreException;

        public void nRekey(long var1, int var3, byte[] var4) throws LiteCoreException;

        public void nSetCookie(long var1, String var3, String var4, boolean var5) throws LiteCoreException;

        @Nullable
        public String nGetCookies(long var1, @NonNull String var3) throws LiteCoreException;

        public long nGetSharedFleeceEncoder(long var1);

        public long nGetFLSharedKeys(long var1);

        @NonNull
        public Set<String> nGetScopeNames(long var1) throws LiteCoreException;

        public boolean nHasScope(long var1, @NonNull String var3);

        @NonNull
        public Set<String> nGetCollectionNames(long var1, @NonNull String var3) throws LiteCoreException;

        public void nDeleteCollection(long var1, @NonNull String var3, @NonNull String var4) throws LiteCoreException;
    }

    static final class ManagedC4Database
    extends C4Database {
        @NonNull
        private final NativeImpl impl;

        ManagedC4Database(@NonNull NativeImpl impl, @NonNull String name, long peer) {
            super(impl, name, peer);
            this.impl = impl;
        }

        @Override
        public void close() {
            this.closePeer(null);
        }

        protected void finalize() throws Throwable {
            try {
                this.closePeer(LogDomain.DATABASE);
            }
            finally {
                super.finalize();
            }
        }

        private void closePeer(@Nullable LogDomain domain) {
            this.releasePeer(domain, peer -> {
                NativeImpl nativeImpl = this.impl;
                if (nativeImpl != null) {
                    nativeImpl.nFree((long)peer);
                }
            });
        }
    }
}

