/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.ConsoleLogger;
import com.couchbase.lite.Database;
import com.couchbase.lite.Log;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.Logger;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.core.impl.NativeC4Log;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class C4Log {
    @NonNull
    private static final Map<LogDomain, String> LOGGING_DOMAINS_TO_C4;
    @NonNull
    private static final Map<Integer, LogLevel> LOG_LEVEL_FROM_C4;
    @NonNull
    private static final Map<String, LogDomain> LOGGING_DOMAINS_FROM_C4;
    @NonNull
    private static final Map<LogLevel, Integer> LOG_LEVEL_TO_C4;
    @VisibleForTesting
    @NonNull
    public static final AtomicReference<C4Log> LOGGER;
    @NonNull
    private static final AtomicReference<LogLevel> CALLBACK_LEVEL;
    @NonNull
    private final NativeImpl impl;

    public static void logCallback(@Nullable String c4Domain, int c4Level, @Nullable String message) {
        C4Log.get().logInternal(c4Domain == null ? "???" : c4Domain, c4Level, message == null ? "" : message);
    }

    @NonNull
    public static C4Log get() {
        return LOGGER.get();
    }

    protected C4Log(@NonNull NativeImpl impl) {
        this.impl = impl;
    }

    public final void logToCore(LogDomain domain, LogLevel level, String message) {
        this.impl.nLog(this.getC4DomainForLoggingDomain(domain), this.getC4LevelForLogLevel(level), message);
    }

    public final void initFileLogger(String path, LogLevel level, int maxRotate, long maxSize, boolean plainText, String header) {
        this.impl.nWriteToBinaryFile(path, this.getC4LevelForLogLevel(level), maxRotate, maxSize, plainText, header);
    }

    public final void setFileLogLevel(LogLevel level) {
        this.impl.nSetBinaryFileLevel(this.getC4LevelForLogLevel(level));
    }

    public final void setLevels(int level, String ... domains) {
        if (domains == null || domains.length <= 0) {
            return;
        }
        for (String domain : domains) {
            this.impl.nSetLevel(domain, level);
        }
    }

    @NonNull
    public final LogLevel getCallbackLevel() {
        return CALLBACK_LEVEL.get();
    }

    public final void setCallbackLevel(@NonNull LogLevel consoleLevel) {
        LogLevel newLogLevel = this.getCallbackLevel(consoleLevel, Database.log.getCustom());
        if (CALLBACK_LEVEL.getAndSet(newLogLevel) == newLogLevel) {
            return;
        }
        this.setCoreCallbackLevel();
    }

    public final void setC4LogLevel(@NonNull EnumSet<LogDomain> domains, @NonNull LogLevel level) {
        int c4Level = this.getC4LevelForLogLevel(level);
        block7: for (LogDomain domain : domains) {
            switch (domain) {
                case DATABASE: {
                    this.setLevels(c4Level, "", "Blob", "Changes", "DB", "SQL");
                    continue block7;
                }
                case LISTENER: {
                    this.setLevels(c4Level, "Listener");
                    continue block7;
                }
                case NETWORK: {
                    this.setLevels(c4Level, "BLIP", "BLIPMessages", "TLS", "WS", "Zip");
                    continue block7;
                }
                case QUERY: {
                    this.setLevels(c4Level, "Enum", "Query");
                    continue block7;
                }
                case REPLICATOR: {
                    this.setLevels(c4Level, "Actor", "Sync", "SyncBusy");
                    continue block7;
                }
            }
            this.logInternal(this.getC4DomainForLoggingDomain(LogDomain.DATABASE), c4Level, "Unexpected log domain: " + (Object)((Object)domain));
        }
    }

    @VisibleForTesting
    public final void forceCallbackLevel(@NonNull LogLevel logLevel) {
        CALLBACK_LEVEL.set(logLevel);
        this.setCoreCallbackLevel();
    }

    @VisibleForTesting
    protected void logInternal(@NonNull String c4Domain, int c4Level, @NonNull String message) {
        LogLevel newCallbackLevel;
        LogLevel level = this.getLogLevelForC4Level(c4Level);
        LogDomain domain = this.getLoggingDomainForC4Domain(c4Domain);
        Log logger = Database.log;
        ConsoleLogger console = logger.getConsole();
        console.log(level, domain, message);
        Logger custom = logger.getCustom();
        if (custom != null) {
            custom.log(level, domain, message);
        }
        if (CALLBACK_LEVEL.getAndSet(newCallbackLevel = this.getCallbackLevel(console.getLevel(), custom)) == newCallbackLevel) {
            return;
        }
        CouchbaseLiteInternal.getExecutionService().getDefaultExecutor().execute(this::setCoreCallbackLevel);
    }

    @NonNull
    private LogLevel getLogLevelForC4Level(int c4Level) {
        LogLevel level = LOG_LEVEL_FROM_C4.get(c4Level);
        return level != null ? level : LogLevel.INFO;
    }

    @NonNull
    private LogDomain getLoggingDomainForC4Domain(@NonNull String c4Domain) {
        LogDomain domain = LOGGING_DOMAINS_FROM_C4.get(c4Domain);
        return domain != null ? domain : LogDomain.DATABASE;
    }

    @NonNull
    private String getC4DomainForLoggingDomain(@NonNull LogDomain domain) {
        String c4Domain = LOGGING_DOMAINS_TO_C4.get((Object)domain);
        return c4Domain != null ? c4Domain : "DB";
    }

    private int getC4LevelForLogLevel(@NonNull LogLevel logLevel) {
        Integer c4level = LOG_LEVEL_TO_C4.get((Object)logLevel);
        return c4level != null ? c4level : 2;
    }

    private void setCoreCallbackLevel() {
        this.impl.nSetCallbackLevel(this.getC4LevelForLogLevel(CALLBACK_LEVEL.get()));
    }

    @NonNull
    private LogLevel getCallbackLevel(@NonNull LogLevel consoleLevel, @Nullable Logger customLogger) {
        if (customLogger == null) {
            return consoleLevel;
        }
        LogLevel customLogLevel = customLogger.getLevel();
        return customLogLevel.compareTo(consoleLevel) > 0 ? consoleLevel : customLogLevel;
    }

    static {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        m.put((Object)LogDomain.DATABASE, "DB");
        m.put((Object)LogDomain.NETWORK, "WS");
        m.put((Object)LogDomain.REPLICATOR, "Sync");
        m.put((Object)LogDomain.QUERY, "Query");
        m.put((Object)LogDomain.LISTENER, "Listener");
        LOGGING_DOMAINS_TO_C4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put(0, (Object)LogLevel.DEBUG);
        m.put(1, (Object)LogLevel.VERBOSE);
        m.put(2, (Object)LogLevel.INFO);
        m.put(3, (Object)LogLevel.WARNING);
        m.put(4, (Object)LogLevel.ERROR);
        LOG_LEVEL_FROM_C4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put("", (Object)LogDomain.DATABASE);
        m.put("Actor", (Object)LogDomain.REPLICATOR);
        m.put("BLIP", (Object)LogDomain.NETWORK);
        m.put("BLIPMessages", (Object)LogDomain.NETWORK);
        m.put("Blob", (Object)LogDomain.DATABASE);
        m.put("Changes", (Object)LogDomain.DATABASE);
        m.put("DB", (Object)LogDomain.DATABASE);
        m.put("Enum", (Object)LogDomain.QUERY);
        m.put("Listener", (Object)LogDomain.LISTENER);
        m.put("Query", (Object)LogDomain.QUERY);
        m.put("SQL", (Object)LogDomain.DATABASE);
        m.put("Sync", (Object)LogDomain.REPLICATOR);
        m.put("SyncBusy", (Object)LogDomain.REPLICATOR);
        m.put("TLS", (Object)LogDomain.NETWORK);
        m.put("WS", (Object)LogDomain.NETWORK);
        m.put("Zip", (Object)LogDomain.NETWORK);
        LOGGING_DOMAINS_FROM_C4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put((Object)LogLevel.DEBUG, 0);
        m.put((Object)LogLevel.VERBOSE, 1);
        m.put((Object)LogLevel.INFO, 2);
        m.put((Object)LogLevel.WARNING, 3);
        m.put((Object)LogLevel.ERROR, 4);
        LOG_LEVEL_TO_C4 = Collections.unmodifiableMap(m);
        LOGGER = new AtomicReference<C4Log>(new C4Log(new NativeC4Log()));
        CALLBACK_LEVEL = new AtomicReference<LogLevel>(LogLevel.NONE);
    }

    public static interface NativeImpl {
        public void nLog(String var1, int var2, String var3);

        public void nSetLevel(String var1, int var2);

        public void nSetCallbackLevel(int var1);

        public void nSetBinaryFileLevel(int var1);

        public void nWriteToBinaryFile(String var1, int var2, int var3, long var4, boolean var6, String var7);
    }
}

