/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.QueryLanguage;
import com.couchbase.lite.internal.core.C4Database;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.C4QueryEnumerator;
import com.couchbase.lite.internal.core.impl.NativeC4Query;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.utils.Preconditions;

public final class C4Query
extends C4NativePeer {
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeC4Query();
    private final NativeImpl impl;

    @NonNull
    public static C4Query create(@NonNull C4Database db, @NonNull QueryLanguage language, @NonNull String expression) throws LiteCoreException {
        return new C4Query(NATIVE_IMPL, db.getPeer(), language, expression);
    }

    private C4Query(@NonNull NativeImpl impl, long db, @NonNull QueryLanguage language, @NonNull String expression) throws LiteCoreException {
        super(impl.nCreateQuery(Preconditions.assertNotZero(db, "db peer ref"), language.getCode(), expression));
        this.impl = impl;
    }

    @Override
    public void close() {
        this.closePeer(null);
    }

    public void setParameters(@NonNull FLSliceResult params) {
        this.impl.nSetParameters(this.getPeer(), params.getBase(), params.getSize());
    }

    @Nullable
    public String explain() {
        return this.withPeerOrNull(this.impl::nExplain);
    }

    @Nullable
    public C4QueryEnumerator run(@NonNull FLSliceResult params) throws LiteCoreException {
        return this.withPeerOrNull(h -> C4QueryEnumerator.create(this.impl.nRun((long)h, params.getBase(), params.getSize())));
    }

    public int getColumnCount() {
        return this.withPeerOrDefault(0, this.impl::nColumnCount);
    }

    @Nullable
    public String getColumnNameForIndex(int idx) {
        return this.withPeerOrNull(peer -> this.impl.nColumnName((long)peer, idx));
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.QUERY);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, peer -> {
            NativeImpl nativeImpl = this.impl;
            if (nativeImpl != null) {
                nativeImpl.nFree((long)peer);
            }
        });
    }

    public static interface NativeImpl {
        public long nCreateQuery(long var1, int var3, @NonNull String var4) throws LiteCoreException;

        public void nSetParameters(long var1, long var3, long var5);

        @Nullable
        public String nExplain(long var1);

        public long nRun(long var1, long var3, long var5) throws LiteCoreException;

        public int nColumnCount(long var1);

        @Nullable
        public String nColumnName(long var1, int var3);

        public void nFree(long var1);
    }
}

