/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.AbstractReplicator;
import com.couchbase.lite.Collection;
import com.couchbase.lite.CollectionConfiguration;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.ReplicatorType;
import com.couchbase.lite.internal.BaseSocketFactory;
import com.couchbase.lite.internal.ReplicationCollection;
import com.couchbase.lite.internal.SocketFactory;
import com.couchbase.lite.internal.core.C4Database;
import com.couchbase.lite.internal.core.C4DocumentEnded;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.C4ReplicatorStatus;
import com.couchbase.lite.internal.core.C4Socket;
import com.couchbase.lite.internal.core.impl.NativeC4Replicator;
import com.couchbase.lite.internal.core.peers.TaggedWeakPeerBinding;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.sockets.MessageFraming;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class C4Replicator
extends C4NativePeer {
    public static final LogDomain LOG_DOMAIN = LogDomain.REPLICATOR;
    public static final String WEBSOCKET_SCHEME = "ws";
    public static final String WEBSOCKET_SECURE_CONNECTION_SCHEME = "wss";
    public static final String MESSAGE_SCHEME = "x-msg-endpt";
    public static final String C4_REPLICATOR_SCHEME_2 = "blip";
    public static final String C4_REPLICATOR_TLS_SCHEME_2 = "blips";
    public static final int PROGRESS_OVERALL = 0;
    public static final int PROGRESS_PER_DOC = 1;
    public static final int PROGRESS_PER_ATTACHMENT = 2;
    public static final String REPLICATOR_OPTION_DOC_IDS = "docIDs";
    public static final String REPLICATOR_OPTION_CHANNELS = "channels";
    public static final String REPLICATOR_OPTION_FILTER = "filter";
    public static final String REPLICATOR_OPTION_FILTER_PARAMS = "filterParams";
    public static final String REPLICATOR_OPTION_SKIP_DELETED = "skipDeleted";
    public static final String REPLICATOR_OPTION_NO_INCOMING_CONFLICTS = "noIncomingConflicts";
    public static final String REPLICATOR_OPTION_OUTGOING_CONFLICTS = "outgoingConflicts";
    public static final String REPLICATOR_CHECKPOINT_INTERVAL = "checkpointInterval";
    public static final String REPLICATOR_OPTION_REMOTE_DB_UNIQUE_ID = "remoteDBUniqueID";
    public static final String REPLICATOR_OPTION_DISABLE_DELTAS = "noDeltas";
    public static final String REPLICATOR_OPTION_DISABLE_PROPERTY_DECRYPTION = "noDecryption";
    public static final String REPLICATOR_OPTION_MAX_RETRIES = "maxRetries";
    public static final String REPLICATOR_OPTION_MAX_RETRY_INTERVAL = "maxRetryInterval";
    public static final String REPLICATOR_OPTION_ENABLE_AUTO_PURGE = "autoPurge";
    public static final String REPLICATOR_OPTION_ROOT_CERTS = "rootCerts";
    public static final String REPLICATOR_OPTION_PINNED_SERVER_CERT = "pinnedCert";
    public static final String REPLICATOR_OPTION_SELF_SIGNED_SERVER_CERT = "onlySelfSignedServer";
    public static final String REPLICATOR_OPTION_EXTRA_HEADERS = "headers";
    public static final String REPLICATOR_OPTION_COOKIES = "cookies";
    public static final String REPLICATOR_OPTION_ACCEPT_PARENT_COOKIES = "acceptParentDomainCookies";
    public static final String REPLICATOR_OPTION_AUTHENTICATION = "auth";
    public static final String REPLICATOR_HEARTBEAT_INTERVAL = "heartbeat";
    public static final String SOCKET_OPTION_WS_PROTOCOLS = "WS-Protocols";
    public static final String SOCKET_OPTIONS_NETWORK_INTERFACE = "networkInterface";
    public static final String REPLICATOR_COMPRESSION_LEVEL = "BLIPCompressionLevel";
    public static final String REPLICATOR_AUTH_TYPE = "type";
    public static final String REPLICATOR_AUTH_USER_NAME = "username";
    public static final String REPLICATOR_AUTH_PASSWORD = "password";
    public static final String REPLICATOR_AUTH_CLIENT_CERT = "clientCert";
    public static final String REPLICATOR_AUTH_CLIENT_CERT_KEY = "clientCertKey";
    public static final String REPLICATOR_AUTH_TOKEN = "token";
    public static final String REPLICATOR_OPTION_PROXY_USER = "proxyUser";
    public static final String REPLICATOR_OPTION_PROXY_PASS = "proxyPassword";
    public static final String AUTH_TYPE_BASIC = "Basic";
    public static final String AUTH_TYPE_SESSION = "Session";
    public static final String AUTH_TYPE_OPEN_ID_CONNECT = "OpenID Connect";
    public static final String AUTH_TYPE_FACEBOOK = "Facebook";
    public static final String AUTH_TYPE_CLIENT_CERT = "Client Cert";
    private static final String ID = "JRepl@";
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeC4Replicator();
    @VisibleForTesting
    @NonNull
    static final TaggedWeakPeerBinding<C4Replicator> BOUND_REPLICATORS = new TaggedWeakPeerBinding();
    @NonNull
    private final NativeImpl impl;
    @VisibleForTesting
    final long token;
    @VisibleForTesting
    @NonNull
    final List<ReplicationCollection> colls;
    @NonNull
    protected final StatusListener statusListener;

    static void statusChangedCallback(long token, @Nullable C4ReplicatorStatus status) {
        C4Replicator c4Repl = (C4Replicator)BOUND_REPLICATORS.getBinding(token);
        String id = c4Repl == null ? "???@" + token : c4Repl.getReplId();
        Log.d(LOG_DOMAIN, "C4Replicator(%s).statusChangedCallback: %s", id, status);
        if (c4Repl == null || status == null) {
            return;
        }
        c4Repl.statusChanged(c4Repl, status);
    }

    static void documentEndedCallback(long token, boolean pushing, C4DocumentEnded ... docEnds) {
        C4Replicator c4Repl = (C4Replicator)BOUND_REPLICATORS.getBinding(token);
        String id = c4Repl == null ? "???@" + token : c4Repl.getReplId();
        int nDocs = docEnds == null ? 0 : docEnds.length;
        Log.d(LOG_DOMAIN, "C4Replicator(%s).documentEndedCallback: %d (%s)", id, nDocs, pushing);
        if (c4Repl == null || nDocs <= 0) {
            return;
        }
        c4Repl.documentsEnded(Arrays.asList(docEnds), pushing);
    }

    @NonNull
    static C4Replicator createRemoteReplicator(@NonNull Map<Collection, CollectionConfiguration> collections, long db, @Nullable String scheme, @Nullable String host, int port, @Nullable String path, @Nullable String remoteDbName, @NonNull MessageFraming framing, @NonNull ReplicatorType type, boolean continuous, @Nullable Map<String, Object> options, @NonNull StatusListener statusListener, @NonNull DocEndsListener docEndsListener, @NonNull AbstractReplicator replicator, @Nullable SocketFactory socketFactory) throws LiteCoreException {
        return C4Replicator.createRemoteReplicator(NATIVE_IMPL, collections, db, scheme, host, port, path, remoteDbName, framing, type, continuous, options, statusListener, docEndsListener, replicator, socketFactory);
    }

    @VisibleForTesting
    @NonNull
    static C4Replicator createRemoteReplicator(@NonNull NativeImpl impl, @NonNull Map<Collection, CollectionConfiguration> collections, long db, @Nullable String scheme, @Nullable String host, int port, @Nullable String path, @Nullable String remoteDbName, @NonNull MessageFraming framing, @NonNull ReplicatorType type, boolean continuous, @Nullable Map<String, Object> options, @NonNull StatusListener statusListener, @NonNull DocEndsListener docEndsListener, @NonNull AbstractReplicator replicator, @Nullable SocketFactory socketFactory) throws LiteCoreException {
        long replToken = BOUND_REPLICATORS.reserveKey();
        long sfToken = socketFactory == null ? 0L : BaseSocketFactory.bindSocketFactory(socketFactory);
        ReplicationCollection[] colls = ReplicationCollection.createAll(collections);
        long peer = impl.nCreate(ID + replToken, colls, db, scheme, host, port, path, remoteDbName, MessageFraming.getC4Framing(framing), type == ReplicatorType.PUSH_AND_PULL || type == ReplicatorType.PUSH, type == ReplicatorType.PUSH_AND_PULL || type == ReplicatorType.PULL, continuous, options == null || options.isEmpty() ? null : FLEncoder.encodeMap(options), replToken, sfToken);
        C4CommonReplicator c4Replicator = new C4CommonReplicator(impl, peer, replToken, Arrays.asList(colls), statusListener, docEndsListener, replicator, socketFactory, sfToken);
        BOUND_REPLICATORS.bind(replToken, c4Replicator);
        return c4Replicator;
    }

    @NonNull
    static C4Replicator createLocalReplicator(@NonNull Map<Collection, CollectionConfiguration> collections, long db, @NonNull C4Database targetDb, @NonNull ReplicatorType type, boolean continuous, @Nullable Map<String, Object> options, @NonNull StatusListener statusListener, @NonNull DocEndsListener docEndsListener, @NonNull AbstractReplicator replicator) throws LiteCoreException {
        return C4Replicator.createLocalReplicator(NATIVE_IMPL, collections, db, targetDb, type, continuous, options, statusListener, docEndsListener, replicator);
    }

    @VisibleForTesting
    @NonNull
    static C4Replicator createLocalReplicator(@NonNull NativeImpl impl, @NonNull Map<Collection, CollectionConfiguration> collections, long db, @NonNull C4Database targetDb, @NonNull ReplicatorType type, boolean continuous, @Nullable Map<String, Object> options, @NonNull StatusListener statusListener, @NonNull DocEndsListener docEndsListener, @NonNull AbstractReplicator replicator) throws LiteCoreException {
        long token = BOUND_REPLICATORS.reserveKey();
        ReplicationCollection[] colls = ReplicationCollection.createAll(collections);
        long peer = impl.nCreateLocal(ID + token, colls, db, targetDb.getHandle(), type == ReplicatorType.PUSH_AND_PULL || type == ReplicatorType.PUSH, type == ReplicatorType.PUSH_AND_PULL || type == ReplicatorType.PULL, continuous, options == null || options.isEmpty() ? null : FLEncoder.encodeMap(options), token);
        C4CommonReplicator c4Replicator = new C4CommonReplicator(impl, peer, token, Arrays.asList(colls), statusListener, docEndsListener, replicator, null, 0L);
        BOUND_REPLICATORS.bind(token, c4Replicator);
        return c4Replicator;
    }

    @NonNull
    static C4Replicator createMessageEndpointReplicator(@NonNull Set<Collection> collections, long db, @NonNull C4Socket c4Socket, @Nullable Map<String, Object> options, @NonNull StatusListener statusListener) throws LiteCoreException {
        return C4Replicator.createMessageEndpointReplicator(NATIVE_IMPL, collections, db, c4Socket, options, statusListener);
    }

    @VisibleForTesting
    @NonNull
    static C4Replicator createMessageEndpointReplicator(@NonNull NativeImpl impl, @NonNull Set<Collection> collections, long db, @NonNull C4Socket c4Socket, @Nullable Map<String, Object> options, @NonNull StatusListener statusListener) throws LiteCoreException {
        long token = BOUND_REPLICATORS.reserveKey();
        ReplicationCollection[] colls = ReplicationCollection.createAll(collections);
        long peer = impl.nCreateWithSocket(ID + token, colls, db, c4Socket.getPeerHandle(), options == null || options.isEmpty() ? null : FLEncoder.encodeMap(options), token);
        C4MessageEndpointReplicator c4Replicator = new C4MessageEndpointReplicator(impl, peer, token, c4Socket, Arrays.asList(colls), statusListener);
        BOUND_REPLICATORS.bind(token, c4Replicator);
        return c4Replicator;
    }

    C4Replicator(@NonNull NativeImpl impl, long peer, long token, @NonNull List<ReplicationCollection> colls, @NonNull StatusListener statusListener) {
        super(peer);
        this.impl = impl;
        this.token = Preconditions.assertNotZero(token, REPLICATOR_AUTH_TOKEN);
        this.colls = Preconditions.assertNotNull(colls, "collections");
        this.statusListener = Preconditions.assertNotNull(statusListener, "status listener");
    }

    public void start(boolean restart) {
        this.withPeer(peer -> this.impl.nStart((long)peer, restart));
    }

    public void stop() {
        this.withPeer(this.impl::nStop);
    }

    @Override
    public final void close() {
        for (ReplicationCollection coll : this.colls) {
            coll.close();
        }
        this.closePeer(null);
    }

    @NonNull
    public String getReplId() {
        return ID + this.token;
    }

    public void setOptions(@Nullable byte[] options) {
        this.withPeer(peer -> this.impl.nSetOptions((long)peer, options));
    }

    @Nullable
    public C4ReplicatorStatus getStatus() {
        return this.withPeerOrNull(this.impl::nGetStatus);
    }

    public boolean isDocumentPending(@NonNull String docId, @NonNull String scope, @NonNull String collection) throws LiteCoreException {
        return this.withPeerOrDefault(false, peer -> this.impl.nIsDocumentPending((long)peer, docId, scope, collection));
    }

    @NonNull
    public Set<String> getPendingDocIDs(@NonNull String scope, @NonNull String collection) throws LiteCoreException {
        FLSliceResult result = this.withPeerOrNull(peer -> this.impl.nGetPendingDocIds((long)peer, scope, collection));
        FLValue slice = FLValue.fromData(result);
        return slice == null ? Collections.emptySet() : new HashSet(slice.asTypedArray());
    }

    public void setProgressLevel(int level) throws LiteCoreException {
        this.withPeer(peer -> this.impl.nSetProgressLevel((long)peer, level));
    }

    public void setHostReachable(boolean reachable) {
        this.withPeer(peer -> this.impl.nSetHostReachable((long)peer, reachable));
    }

    protected abstract void releaseResources();

    protected abstract void documentsEnded(@NonNull List<C4DocumentEnded> var1, boolean var2);

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LOG_DOMAIN);
        }
        finally {
            super.finalize();
        }
    }

    void statusChanged(@NonNull C4Replicator replicator, @NonNull C4ReplicatorStatus status) {
        this.statusListener.statusChanged(replicator, status);
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, peer -> {
            this.releaseResources();
            BOUND_REPLICATORS.unbind(this.token);
            NativeImpl nativeImpl = this.impl;
            if (nativeImpl != null) {
                nativeImpl.nStop((long)peer);
                nativeImpl.nFree((long)peer);
            }
        });
    }

    public static interface NativeImpl {
        public long nCreate(@NonNull String var1, @NonNull ReplicationCollection[] var2, long var3, @Nullable String var5, @Nullable String var6, int var7, @Nullable String var8, @Nullable String var9, int var10, boolean var11, boolean var12, boolean var13, @Nullable byte[] var14, long var15, long var17) throws LiteCoreException;

        public long nCreateLocal(@NonNull String var1, @NonNull ReplicationCollection[] var2, long var3, long var5, boolean var7, boolean var8, boolean var9, @Nullable byte[] var10, long var11) throws LiteCoreException;

        public long nCreateWithSocket(@NonNull String var1, @NonNull ReplicationCollection[] var2, long var3, long var5, @Nullable byte[] var7, long var8) throws LiteCoreException;

        @NonNull
        public C4ReplicatorStatus nGetStatus(long var1);

        public void nStart(long var1, boolean var3);

        public void nStop(long var1);

        public void nSetOptions(long var1, @Nullable byte[] var3);

        @NonNull
        public FLSliceResult nGetPendingDocIds(long var1, @NonNull String var3, @NonNull String var4) throws LiteCoreException;

        public boolean nIsDocumentPending(long var1, @NonNull String var3, @NonNull String var4, @NonNull String var5) throws LiteCoreException;

        public void nSetProgressLevel(long var1, int var3) throws LiteCoreException;

        public void nSetHostReachable(long var1, boolean var3);

        public void nFree(long var1);
    }

    @FunctionalInterface
    public static interface StatusListener {
        public void statusChanged(@NonNull C4Replicator var1, @NonNull C4ReplicatorStatus var2);
    }

    @FunctionalInterface
    public static interface DocEndsListener {
        public void documentsEnded(@NonNull List<C4DocumentEnded> var1, boolean var2);
    }

    static final class C4CommonReplicator
    extends C4Replicator {
        @NonNull
        private final DocEndsListener docEndsListener;
        @NonNull
        private final AbstractReplicator replicator;
        @Nullable
        private final SocketFactory socketFactory;
        private final long socketFactoryToken;

        C4CommonReplicator(@NonNull NativeImpl impl, long peer, long token, @NonNull List<ReplicationCollection> colls, @NonNull StatusListener statusListener, @NonNull DocEndsListener docEndsListener, @NonNull AbstractReplicator replicator, @Nullable SocketFactory socketFactory, long socketFactoryToken) {
            super(impl, peer, token, colls, statusListener);
            this.docEndsListener = docEndsListener;
            this.replicator = Preconditions.assertNotNull(replicator, "replicator");
            this.socketFactory = socketFactory;
            this.socketFactoryToken = socketFactoryToken;
        }

        @Override
        protected void documentsEnded(@NonNull List<C4DocumentEnded> docEnds, boolean pushing) {
            this.docEndsListener.documentsEnded(docEnds, pushing);
        }

        @Override
        protected void releaseResources() {
            BaseSocketFactory.unbindSocketFactory(this.socketFactoryToken);
        }

        @Override
        @NonNull
        public String toString() {
            return "C4CommonRepl{" + ClassUtils.objId(this) + "/" + super.toString() + ", " + ClassUtils.objId(this.replicator) + ", " + this.socketFactory + "'}";
        }
    }

    static final class C4MessageEndpointReplicator
    extends C4Replicator {
        @NonNull
        private final C4Socket c4Socket;

        C4MessageEndpointReplicator(@NonNull NativeImpl impl, long peer, long token, @NonNull C4Socket c4Socket, @NonNull List<ReplicationCollection> colls, @NonNull StatusListener statusListener) {
            super(impl, peer, token, colls, statusListener);
            this.c4Socket = c4Socket;
        }

        @Override
        protected void releaseResources() {
        }

        @Override
        protected void documentsEnded(@NonNull List<C4DocumentEnded> docEnds, boolean pushing) {
            Log.d(LOG_DOMAIN, "%s: Unsupported call to doc ended for MessageEndpoint", this.getReplId());
        }

        @Override
        @NonNull
        public String toString() {
            return "C4MessageEndpointRepl{" + this.getReplId() + "/" + super.toString() + ", " + this.statusListener + "'}";
        }
    }
}

