/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.BaseSocketFactory;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.impl.NativeC4Socket;
import com.couchbase.lite.internal.core.peers.WeakPeerBinding;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.sockets.CBLSocketException;
import com.couchbase.lite.internal.sockets.CloseStatus;
import com.couchbase.lite.internal.sockets.MessageFraming;
import com.couchbase.lite.internal.sockets.SocketFromCore;
import com.couchbase.lite.internal.sockets.SocketToCore;
import com.couchbase.lite.internal.utils.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class C4Socket
extends C4NativePeer
implements SocketToCore {
    private static final LogDomain LOG_DOMAIN = LogDomain.NETWORK;
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeC4Socket();
    @NonNull
    @VisibleForTesting
    static final NativeRefPeerBinding<C4Socket> BOUND_SOCKETS = new NativeRefPeerBinding();
    @NonNull
    private final Executor queue = CouchbaseLiteInternal.getExecutionService().getSerialExecutor();
    @NonNull
    private final AtomicReference<SocketFromCore> fromCore = new AtomicReference<Object>(null);
    @NonNull
    private final NativeImpl impl;

    @NonNull
    public static C4Socket createPassiveSocket(int id, @NonNull MessageFraming framing) {
        return C4Socket.createSocket(NATIVE_IMPL, NATIVE_IMPL.nFromNative(0L, "x-msg-conn", "", 0, "/" + Integer.toHexString(id), MessageFraming.getC4Framing(framing)));
    }

    static void open(long peer, long token, @Nullable String scheme, @Nullable String host, int port, @Nullable String path, @Nullable byte[] options) {
        C4Socket socket = (C4Socket)BOUND_SOCKETS.getBinding(peer);
        Log.d(LOG_DOMAIN, "^C4Socket.open@%x: %s@%x", peer, socket, token);
        if (socket == null && !C4Socket.openSocket(NATIVE_IMPL, peer, token, scheme, host, port, path, options)) {
            return;
        }
        C4Socket.withSocket(peer, "open", (s, r) -> {
            try {
                r.coreRequestsOpen();
            }
            catch (RuntimeException e) {
                s.openFailed(e);
            }
        });
    }

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    static void write(long peer, @Nullable byte[] data) {
        int nBytes = data == null ? 0 : data.length;
        Log.d(LOG_DOMAIN, "^C4Socket.write@%x(%d)", peer, nBytes);
        if (nBytes <= 0) {
            Log.i(LOG_DOMAIN, "C4Socket.write: empty data");
            return;
        }
        C4Socket.withSocket(peer, "write", (s, r) -> r.coreWrites(data));
    }

    static void completedReceive(long peer, long nBytes) {
        Log.d(LOG_DOMAIN, "^C4Socket.completedReceive@%x(%d)", peer, nBytes);
        C4Socket.withSocket(peer, "completedReceive", (s, r) -> r.coreAcksWrite(nBytes));
    }

    static void requestClose(long peer, int status, @Nullable String message) {
        Log.d(LOG_DOMAIN, "^C4Socket.requestClose@%x(%d): '%s'", peer, status, message);
        C4Socket.withSocket(peer, "requestClose", (s, r) -> r.coreRequestsClose(new CloseStatus(6, status, message)));
    }

    static void close(long peer) {
        Log.d(LOG_DOMAIN, "^C4Socket.close@%x", peer);
        C4Socket.withSocket(peer, "close", (s, r) -> r.coreClosed());
    }

    @VisibleForTesting
    @NonNull
    static C4Socket createSocket(@NonNull NativeImpl impl, long peer) {
        C4Socket socket = new C4Socket(impl, peer);
        BOUND_SOCKETS.bind(peer, socket);
        return socket;
    }

    @VisibleForTesting
    static boolean openSocket(@NonNull NativeImpl impl, long peer, long sfToken, @Nullable String scheme, @Nullable String hostname, int port, @Nullable String path, @Nullable byte[] options) {
        BaseSocketFactory socketFactory = BaseSocketFactory.getBoundSocketFactory(sfToken);
        if (socketFactory == null) {
            Log.w(LOG_DOMAIN, "C4Socket.open: no such socket factory: " + sfToken);
            return false;
        }
        if (scheme == null) {
            Log.w(LOG_DOMAIN, "C4Socket.open: scheme is null");
            return false;
        }
        if (hostname == null) {
            Log.w(LOG_DOMAIN, "C4Socket.open: hostname is null");
            return false;
        }
        if (path == null) {
            Log.w(LOG_DOMAIN, "C4Socket.open: path is null");
            return false;
        }
        if (options == null) {
            Log.w(LOG_DOMAIN, "C4Socket.open: options are null");
            return false;
        }
        C4Socket socket = C4Socket.createSocket(impl, peer);
        try {
            socket.init(socketFactory.createSocket(socket, scheme, hostname, port, path, options));
        }
        catch (RuntimeException e) {
            socket.openFailed(e);
            return false;
        }
        return true;
    }

    private static void withSocket(long peer, @Nullable String op, @NonNull SocketTask task) {
        C4Socket socket = (C4Socket)BOUND_SOCKETS.getBinding(peer);
        if (socket != null) {
            socket.continueWith(task);
            return;
        }
        Log.w(LOG_DOMAIN, "C4Socket.%s@%x: No socket for peer", op, peer);
    }

    private static void releaseSocket(@Nullable NativeImpl impl, long peer, int domain, int code, @Nullable String msg) {
        if (impl != null) {
            impl.nClosed(peer, domain, code, msg);
        }
    }

    @VisibleForTesting
    C4Socket(@NonNull NativeImpl impl, long peer) {
        super(peer);
        this.impl = impl;
        impl.nRetain(peer);
    }

    @Override
    @NonNull
    public String toString() {
        return "vC4Socket" + super.toString();
    }

    @Override
    public void close() {
        this.release(null, 5, 16, "Closed by client");
    }

    @Override
    @NonNull
    public Object getLock() {
        return this.getPeerLock();
    }

    @Override
    public void init(@NonNull SocketFromCore core) {
        Log.d(LOG_DOMAIN, "%s.init: %s", this, core);
        Preconditions.assertNotNull(core, "fromCore");
        if (!this.fromCore.compareAndSet(null, core) && !core.equals(this.fromCore.get())) {
            Log.w(LOG_DOMAIN, "Attempt to re-initialize C4Socket");
        }
    }

    @Override
    public void ackOpenToCore(int httpStatus, @Nullable byte[] fleeceResponseHeaders) {
        Log.d(LOG_DOMAIN, "%s.ackOpenToCore", this);
        this.withPeer(peer -> {
            this.impl.nGotHTTPResponse((long)peer, httpStatus, fleeceResponseHeaders);
            this.impl.nOpened((long)peer);
        });
    }

    @Override
    public void ackWriteToCore(long byteCount) {
        Log.d(LOG_DOMAIN, "%s.ackWriteToCore(%d)", this, byteCount);
        this.withPeer(peer -> this.impl.nCompletedWrite((long)peer, byteCount));
    }

    @Override
    public void writeToCore(@NonNull byte[] data) {
        Log.d(LOG_DOMAIN, "%s.sendToCore(%d)", this, data.length);
        this.withPeer(peer -> this.impl.nReceived((long)peer, data));
    }

    @Override
    public void requestCoreClose(@NonNull CloseStatus status) {
        Log.d(LOG_DOMAIN, "%s.requestCoreClose(%d): '%s'", this, status.code, status.message);
        this.withPeer(peer -> this.impl.nCloseRequested((long)peer, status.code, status.message));
    }

    @Override
    public void closeCore(@NonNull CloseStatus status) {
        Log.d(LOG_DOMAIN, "%s.closeCore(%d, %d): '%s'", this, status.domain, status.code, status.message);
        this.release(null, status.domain, status.code, status.message);
    }

    protected void finalize() throws Throwable {
        try {
            this.release(LOG_DOMAIN, 5, 17, "Finalized");
        }
        finally {
            super.finalize();
        }
    }

    long getPeerHandle() {
        return this.getPeer();
    }

    @VisibleForTesting
    @Nullable
    SocketFromCore getFromCore() {
        return this.fromCore.get();
    }

    private void continueWith(SocketTask task) {
        this.queue.execute(() -> task.accept(this, this.fromCore.get()));
    }

    private void openFailed(@NonNull RuntimeException err) {
        int code;
        int domain;
        Log.w(LOG_DOMAIN, "Failed opening connection", err);
        if (err instanceof CBLSocketException) {
            CBLSocketException cblErr = (CBLSocketException)err;
            domain = cblErr.getDomain();
            code = cblErr.getCode();
        } else {
            domain = 5;
            code = 13;
        }
        this.release(null, domain, code, err.getMessage());
    }

    private void release(LogDomain logDomain, int domain, int code, @Nullable String msg) {
        this.releasePeer(logDomain, peer -> {
            BOUND_SOCKETS.unbind((long)peer);
            C4Socket.releaseSocket(this.impl, peer, domain, code, msg);
        });
    }

    public static interface NativeImpl {
        public void nRetain(long var1);

        public long nFromNative(long var1, String var3, String var4, int var5, String var6, int var7);

        public void nOpened(long var1);

        public void nGotHTTPResponse(long var1, int var3, @Nullable byte[] var4);

        public void nCompletedWrite(long var1, long var3);

        public void nReceived(long var1, byte[] var3);

        public void nCloseRequested(long var1, int var3, @Nullable String var4);

        public void nClosed(long var1, int var3, int var4, String var5);
    }

    public static class NativeRefPeerBinding<T>
    extends WeakPeerBinding<T> {
        @Override
        protected void preBind(long key, @NonNull T obj) {
        }

        @Override
        protected void preGetBinding(long key) {
        }
    }

    @FunctionalInterface
    static interface SocketTask {
        public void accept(C4Socket var1, SocketFromCore var2);
    }
}

