/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.internal.core.C4Database;
import java.util.Set;

public final class NativeC4Database
implements C4Database.NativeImpl {
    @Override
    public long nOpen(@NonNull String parentDir, @NonNull String name, int flags, int algorithm, byte[] encryptionKey) throws LiteCoreException {
        return NativeC4Database.open(parentDir, name, flags, algorithm, encryptionKey);
    }

    @Override
    public void nClose(long db) throws LiteCoreException {
        NativeC4Database.close(db);
    }

    @Override
    public void nFree(long db) {
        NativeC4Database.free(db);
    }

    @Override
    @Nullable
    public String nGetPath(long db) {
        return NativeC4Database.getPath(db);
    }

    @Override
    public void nCopy(String sourcePath, String parentDir, String name, int flags, int algorithm, byte[] encryptionKey) throws LiteCoreException {
        NativeC4Database.copy(sourcePath, parentDir, name, flags, algorithm, encryptionKey);
    }

    @Override
    public void nDelete(long db) throws LiteCoreException {
        NativeC4Database.delete(db);
    }

    @Override
    public void nDeleteNamed(@NonNull String name, @NonNull String dir) throws LiteCoreException {
        NativeC4Database.deleteNamed(name, dir);
    }

    @Override
    @NonNull
    public byte[] nGetPublicUUID(long db) throws LiteCoreException {
        return NativeC4Database.getPublicUUID(db);
    }

    @Override
    public void nBeginTransaction(long db) throws LiteCoreException {
        NativeC4Database.beginTransaction(db);
    }

    @Override
    public void nEndTransaction(long db, boolean commit) throws LiteCoreException {
        NativeC4Database.endTransaction(db, commit);
    }

    @Override
    public boolean nMaintenance(long db, int type) throws LiteCoreException {
        return NativeC4Database.maintenance(db, type);
    }

    @Override
    public void nRekey(long db, int keyType, byte[] newKey) throws LiteCoreException {
        NativeC4Database.rekey(db, keyType, newKey);
    }

    @Override
    public void nSetCookie(long db, String url, String setCookieHeader, boolean acceptParentDomain) throws LiteCoreException {
        NativeC4Database.setCookie(db, url, setCookieHeader, acceptParentDomain);
    }

    @Override
    @Nullable
    public String nGetCookies(long db, @NonNull String url) throws LiteCoreException {
        return NativeC4Database.getCookies(db, url);
    }

    @Override
    public long nGetSharedFleeceEncoder(long db) {
        return NativeC4Database.getSharedFleeceEncoder(db);
    }

    @Override
    public long nGetFLSharedKeys(long db) {
        return NativeC4Database.getFLSharedKeys(db);
    }

    @Override
    @NonNull
    public Set<String> nGetScopeNames(long peer) throws LiteCoreException {
        return NativeC4Database.getScopeNames(peer);
    }

    @Override
    public boolean nHasScope(long peer, @NonNull String scope) {
        return NativeC4Database.hasScope(peer, scope);
    }

    @Override
    @NonNull
    public Set<String> nGetCollectionNames(long peer, @NonNull String scope) throws LiteCoreException {
        return NativeC4Database.getCollectionNames(peer, scope);
    }

    @Override
    public void nDeleteCollection(long peer, @NonNull String scope, @NonNull String collection) throws LiteCoreException {
        NativeC4Database.deleteCollection(peer, scope, collection);
    }

    static native long open(@NonNull String var0, @NonNull String var1, int var2, int var3, byte[] var4) throws LiteCoreException;

    private static native void close(long var0) throws LiteCoreException;

    static native void free(long var0);

    @Nullable
    private static native String getPath(long var0);

    private static native void copy(String var0, String var1, String var2, int var3, int var4, byte[] var5) throws LiteCoreException;

    private static native void delete(long var0) throws LiteCoreException;

    private static native void deleteNamed(@NonNull String var0, @NonNull String var1) throws LiteCoreException;

    @NonNull
    private static native byte[] getPublicUUID(long var0) throws LiteCoreException;

    private static native void beginTransaction(long var0) throws LiteCoreException;

    private static native void endTransaction(long var0, boolean var2) throws LiteCoreException;

    private static native void rekey(long var0, int var2, byte[] var3) throws LiteCoreException;

    private static native boolean maintenance(long var0, int var2) throws LiteCoreException;

    private static native void setCookie(long var0, String var2, String var3, boolean var4) throws LiteCoreException;

    @Nullable
    private static native String getCookies(long var0, @NonNull String var2) throws LiteCoreException;

    private static native long getSharedFleeceEncoder(long var0);

    private static native long getFLSharedKeys(long var0);

    @NonNull
    private static native Set<String> getScopeNames(long var0) throws LiteCoreException;

    private static native boolean hasScope(long var0, @NonNull String var2);

    @NonNull
    private static native Set<String> getCollectionNames(long var0, @NonNull String var2) throws LiteCoreException;

    private static native void deleteCollection(long var0, @NonNull String var2, @NonNull String var3) throws LiteCoreException;
}

