/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core.peers;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.internal.core.peers.PeerBinding;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class WeakPeerBinding<T>
extends PeerBinding<T> {
    @GuardedBy(value="this")
    @NonNull
    private final Map<Long, WeakReference<T>> bindings = new HashMap<Long, WeakReference<T>>();

    @Override
    @GuardedBy(value="this")
    @Nullable
    protected T get(long key) {
        WeakReference<T> ref = this.bindings.get(key);
        if (ref == null) {
            return null;
        }
        Object obj = ref.get();
        if (obj != null) {
            return obj;
        }
        this.bindings.remove(key);
        return null;
    }

    @Override
    @GuardedBy(value="this")
    protected void set(long key, @Nullable T obj) {
        this.bindings.put(key, obj == null ? null : new WeakReference<T>(obj));
    }

    @Override
    @GuardedBy(value="this")
    protected void remove(long key) {
        this.bindings.remove(key);
    }

    @Override
    protected boolean exists(long key) {
        return this.bindings.containsKey(key);
    }

    @Override
    @VisibleForTesting
    public final synchronized int size() {
        return this.bindings.size();
    }

    @Override
    @VisibleForTesting
    public final synchronized void clear() {
        this.bindings.clear();
    }

    @Override
    @NonNull
    @VisibleForTesting
    public final synchronized Set<Long> keySet() {
        return this.bindings.keySet();
    }
}

