/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.exec;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.exec.ConcurrentExecutor;
import com.couchbase.lite.internal.exec.ExecutionService;
import com.couchbase.lite.internal.exec.SerialExecutor;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class AbstractExecutionService
implements ExecutionService {
    private static final int DUMP_INTERVAL_MS = 2000;
    private static final Object DUMP_LOCK = new Object();
    private static long lastDump;
    @NonNull
    private final ThreadPoolExecutor baseExecutor;
    @NonNull
    private final ConcurrentExecutor concurrentExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean throttled() {
        long now = System.currentTimeMillis();
        Object object = DUMP_LOCK;
        synchronized (object) {
            if (now - lastDump < 2000L) {
                return true;
            }
            lastDump = now;
        }
        return false;
    }

    public static void dumpThreads() {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        if (stackTraces.isEmpty()) {
            return;
        }
        Thread curThread = Thread.currentThread();
        Log.w(LogDomain.DATABASE, "==== Threads: " + stackTraces.size());
        for (Map.Entry<Thread, StackTraceElement[]> stack : stackTraces.entrySet()) {
            Thread thread = stack.getKey();
            Log.w(LogDomain.DATABASE, (thread.equals(curThread) ? "**" : "==") + " " + thread + "(" + (Object)((Object)thread.getState()) + ")");
            for (StackTraceElement frame : stack.getValue()) {
                Log.w(LogDomain.DATABASE, "      at " + frame);
            }
        }
    }

    protected AbstractExecutionService(@NonNull ThreadPoolExecutor baseExecutor) {
        this.baseExecutor = baseExecutor;
        this.concurrentExecutor = new ConcurrentExecutor(baseExecutor);
    }

    @Override
    @NonNull
    public ExecutionService.CloseableExecutor getSerialExecutor() {
        return new SerialExecutor(this.baseExecutor);
    }

    @Override
    @NonNull
    public ExecutionService.CloseableExecutor getConcurrentExecutor() {
        return this.concurrentExecutor;
    }

    @Override
    public void cancelDelayedTask(@NonNull ExecutionService.Cancellable cancellableTask) {
        Preconditions.assertNotNull(cancellableTask, "cancellableTask");
        cancellableTask.cancel();
    }

    @VisibleForTesting
    public void dumpState() {
        this.concurrentExecutor.dumpState(null);
    }
}

