/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.exec;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.internal.exec.AbstractExecutionService;
import com.couchbase.lite.internal.exec.CBLExecutor;
import com.couchbase.lite.internal.exec.InstrumentedTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;

public class ClientTask<T> {
    private static final CBLExecutor EXECUTOR = new CBLExecutor("Client worker", 1, CBLExecutor.CPU_COUNT * 2 + 1, new SynchronousQueue<Runnable>());
    @NonNull
    private final Callable<T> task;
    private T result;
    @Nullable
    private Exception err;

    public ClientTask(@NonNull Callable<T> task) {
        this.task = task;
    }

    public void execute() {
        this.execute(30L, TimeUnit.SECONDS);
    }

    public void execute(long timeout, @NonNull TimeUnit timeUnit) {
        FutureTask<T> future = new FutureTask<T>(this.task);
        try {
            EXECUTOR.execute(new InstrumentedTask(future, null));
        }
        catch (Throwable e) {
            this.dumpState();
            this.setFailure(e);
            return;
        }
        try {
            this.result = future.get(timeout, timeUnit);
        }
        catch (ExecutionException e) {
            this.setFailure(e.getCause());
        }
        catch (Throwable e) {
            this.setFailure(e);
        }
    }

    @Nullable
    public T getResult() {
        return this.result;
    }

    @Nullable
    public Exception getFailure() {
        return this.err;
    }

    private void setFailure(@Nullable Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t == null || this.err != null) {
            return;
        }
        this.err = (Exception)t;
    }

    public void dumpState() {
        if (AbstractExecutionService.throttled()) {
            return;
        }
        EXECUTOR.dumpState();
        AbstractExecutionService.dumpThreads();
    }
}

