/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.exec;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteError;
import java.util.concurrent.atomic.AtomicLong;

public class InstrumentedTask
implements Runnable {
    private static final AtomicLong ID = new AtomicLong(0L);
    final Exception origin = null;
    private final long createdAt = System.currentTimeMillis();
    private final long id;
    @NonNull
    private final Runnable task;
    private volatile long startedAt;
    private volatile long finishedAt;
    private volatile long completedAt;
    @Nullable
    private final Runnable onComplete;

    public InstrumentedTask(@NonNull Runnable task, @Nullable Runnable onComplete) {
        this.task = task;
        this.onComplete = onComplete;
        this.id = ID.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InstrumentedTask instrumentedTask = this;
        synchronized (instrumentedTask) {
            if (this.startedAt != 0L) {
                throw new CouchbaseLiteError("Attempt to execute a task multiple times");
            }
            this.startedAt = System.currentTimeMillis();
        }
        try {
            this.task.run();
            this.finishedAt = System.currentTimeMillis();
        }
        finally {
            Runnable completionTask = this.onComplete;
            if (completionTask != null) {
                completionTask.run();
            }
            this.completedAt = System.currentTimeMillis();
        }
    }

    @NonNull
    public String toString() {
        return "task[#" + this.id + " @" + this.createdAt + "(" + this.startedAt + "<" + this.finishedAt + "<" + this.completedAt + "):" + this.task + "]";
    }
}

