/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.exec;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.exec.AbstractExecutionService;
import com.couchbase.lite.internal.exec.CBLExecutor;
import com.couchbase.lite.internal.exec.ExecutionService;
import com.couchbase.lite.internal.exec.InstrumentedTask;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class SerialExecutor
implements ExecutionService.CloseableExecutor {
    private static final LogDomain DOMAIN = LogDomain.DATABASE;
    @NonNull
    private final ThreadPoolExecutor executor;
    @GuardedBy(value="this")
    @NonNull
    private final Deque<InstrumentedTask> pendingTasks = new LinkedList<InstrumentedTask>();
    @GuardedBy(value="this")
    @Nullable
    private CountDownLatch stopLatch;

    SerialExecutor(@NonNull ThreadPoolExecutor executor) {
        Preconditions.assertNotNull(executor, "executor");
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPending() {
        SerialExecutor serialExecutor = this;
        synchronized (serialExecutor) {
            return this.pendingTasks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NonNull Runnable task) {
        Preconditions.assertNotNull(task, "task");
        SerialExecutor serialExecutor = this;
        synchronized (serialExecutor) {
            if (this.stopLatch != null) {
                throw new ExecutionService.CloseableExecutor.ExecutorClosedException("Executor has been stopped");
            }
            this.pendingTasks.add(new InstrumentedTask(task, this::scheduleNext));
            if (this.pendingTasks.size() == 1) {
                this.executeTask(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop(long timeout, @NonNull TimeUnit unit) {
        CountDownLatch latch;
        Preconditions.assertNotNegative(timeout, "timeout");
        Preconditions.assertNotNull(unit, "time unit");
        SerialExecutor serialExecutor = this;
        synchronized (serialExecutor) {
            if (this.stopLatch == null) {
                this.stopLatch = new CountDownLatch(1);
            }
            if (this.pendingTasks.size() <= 0) {
                return true;
            }
            latch = this.stopLatch;
        }
        try {
            return latch.await(timeout, unit);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    @NonNull
    public String toString() {
        return "CBL serial executor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpState(@Nullable InstrumentedTask prev) {
        ArrayList<InstrumentedTask> waiting;
        Log.w(DOMAIN, "==== Serial Executor");
        if (prev != null) {
            Log.w(DOMAIN, "== Previous task: " + prev, prev.origin);
        }
        SerialExecutor serialExecutor = this;
        synchronized (serialExecutor) {
            waiting = new ArrayList<InstrumentedTask>(this.pendingTasks);
        }
        if (waiting.isEmpty()) {
            Log.w(DOMAIN, "== Queue is empty");
        } else {
            Log.w(DOMAIN, "== Queued tasks (" + waiting.size() + ")");
            int n = 0;
            for (InstrumentedTask t : waiting) {
                Log.w(DOMAIN, "@" + n++ + ": " + t, t.origin);
            }
        }
        if (this.executor instanceof CBLExecutor) {
            ((CBLExecutor)this.executor).dumpState();
        }
        AbstractExecutionService.dumpThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNext() {
        CountDownLatch latch;
        SerialExecutor serialExecutor = this;
        synchronized (serialExecutor) {
            this.executeTask(this.pendingTasks.remove());
            latch = this.pendingTasks.size() > 0 ? null : this.stopLatch;
        }
        if (latch != null) {
            latch.countDown();
        }
    }

    @GuardedBy(value="this")
    private void executeTask(@Nullable InstrumentedTask prevTask) {
        InstrumentedTask nextTask = this.pendingTasks.peek();
        if (nextTask == null) {
            return;
        }
        try {
            this.executor.execute(nextTask);
        }
        catch (RuntimeException e) {
            Log.w(LogDomain.DATABASE, "Catastrophic executor failure (Serial Executor)!", e);
            if (!AbstractExecutionService.throttled()) {
                this.dumpState(prevTask);
            }
            throw e;
        }
    }
}

