/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.fleece.FLArray;
import com.couchbase.lite.internal.fleece.FLValue;

public abstract class FLArrayIterator
extends C4NativePeer {
    protected final FLArray.NativeImpl impl;

    FLArrayIterator(@NonNull FLArray.NativeImpl impl, @Nullable Long peer) {
        super(peer);
        this.impl = impl;
    }

    FLArrayIterator(@NonNull FLArray.NativeImpl impl, long peer) {
        super(peer);
        this.impl = impl;
    }

    @Override
    public abstract void close();

    @Nullable
    public FLValue getValueAt(int index) {
        return this.nullableWithPeerOrThrow(peer -> {
            long val = this.impl.nGetValueAt((long)peer, index);
            return val == 0L ? null : FLValue.getFLValue(val);
        });
    }

    public void next() {
        this.withPeerOrThrow(this.impl::nNext);
    }

    @Nullable
    public FLValue getValue() {
        return this.nullableWithPeerOrThrow(peer -> {
            long val = this.impl.nGetValue((long)peer);
            return val == 0L ? null : FLValue.getFLValue(val);
        });
    }

    static final class ManagedFLArrayIterator
    extends FLArrayIterator {
        private final FLArray array;

        ManagedFLArrayIterator(@NonNull FLArray.NativeImpl impl, @NonNull FLArray array) {
            super(impl, array.withContent(impl::nInit));
            this.array = array;
        }

        @Override
        public void close() {
            this.closePeer(null);
        }

        protected void finalize() throws Throwable {
            try {
                this.closePeer(LogDomain.DATABASE);
            }
            finally {
                super.finalize();
            }
        }

        private void closePeer(@Nullable LogDomain domain) {
            this.releasePeer(domain, peer -> {
                FLArray.NativeImpl nativeImpl = this.impl;
                if (nativeImpl != null) {
                    nativeImpl.nFree((long)peer);
                }
            });
        }
    }

    static final class UnmanagedFLArrayIterator
    extends FLArrayIterator {
        UnmanagedFLArrayIterator(@NonNull FLArray.NativeImpl impl, long peer) {
            super(impl, peer);
        }

        @Override
        public void close() {
            this.releasePeer(null, null);
        }
    }
}

