/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLValue;

public final class FLDictIterator
extends C4NativePeer {
    private final FLDict.NativeImpl impl;
    private final FLDict dict;

    FLDictIterator(@NonNull FLDict.NativeImpl impl, @NonNull FLDict dict) {
        super(dict.withContent(impl::nInit));
        this.impl = impl;
        this.dict = dict;
    }

    public long getCount() {
        return this.withPeerOrThrow(this.impl::nGetCount);
    }

    public void next() {
        this.withPeerOrThrow(this.impl::nNext);
    }

    @Nullable
    public String getKey() {
        return this.withPeerOrNull(this.impl::nGetKey);
    }

    @NonNull
    public FLValue getValue() {
        return this.withPeerOrThrow(p -> FLValue.getFLValue(this.impl.nGetValue((long)p)));
    }

    @Override
    public void close() {
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.DATABASE);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, peer -> {
            FLDict.NativeImpl nativeImpl = this.impl;
            if (nativeImpl != null) {
                nativeImpl.nFree((long)peer);
            }
        });
    }
}

