/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.internal.fleece.FLArray;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.fleece.impl.NativeFLValue;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.List;
import java.util.Map;

public class FLValue {
    @NonNull
    private static final NativeImpl NATIVE_IMPL = new NativeFLValue();
    private final NativeImpl impl;
    private final long peer;

    @NonNull
    public static FLValue getFLValue(long peer) {
        return new FLValue(NATIVE_IMPL, peer);
    }

    @Nullable
    public static Object toObject(@NonNull FLValue flValue) {
        return flValue.asObject();
    }

    @Nullable
    public static FLValue fromData(@Nullable FLSliceResult slice) {
        return FLValue.fromData(NATIVE_IMPL, slice);
    }

    @VisibleForTesting
    @Nullable
    public static FLValue fromData(@NonNull NativeImpl impl, @Nullable FLSliceResult slice) {
        if (slice == null) {
            return null;
        }
        long value = impl.nFromData(slice.getBase(), slice.getSize());
        return value == 0L ? null : FLValue.getFLValue(value);
    }

    @NonNull
    public static FLValue fromData(@NonNull byte[] data) {
        return FLValue.fromData(NATIVE_IMPL, data);
    }

    @VisibleForTesting
    @NonNull
    public static FLValue fromData(@NonNull NativeImpl impl, @NonNull byte[] data) {
        return FLValue.getFLValue(impl.nFromTrustedData(data));
    }

    @Nullable
    public static String getJSONForJSON5(@Nullable String json5) throws LiteCoreException {
        return FLValue.getJSONForJSON5(NATIVE_IMPL, json5);
    }

    @VisibleForTesting
    @Nullable
    public static String getJSONForJSON5(@NonNull NativeImpl impl, @Nullable String json5) throws LiteCoreException {
        return impl.nJson5toJson(json5);
    }

    @VisibleForTesting
    public FLValue(@NonNull NativeImpl impl, long peer) {
        this.impl = Preconditions.assertNotNull(impl, "impl");
        this.peer = Preconditions.assertNotZero(peer, "peer");
    }

    public int getType() {
        return this.impl.nGetType(this.peer);
    }

    public boolean isNumber() {
        return this.getType() == 2;
    }

    public boolean isInteger() {
        return this.impl.nIsInteger(this.peer);
    }

    public boolean isUnsigned() {
        return this.impl.nIsUnsigned(this.peer);
    }

    public boolean isDouble() {
        return this.impl.nIsDouble(this.peer);
    }

    @Nullable
    public String toStr() {
        return this.impl.nToString(this.peer);
    }

    @Nullable
    public String toJSON() {
        return this.impl.nToJSON(this.peer);
    }

    @Nullable
    public String toJSON5() {
        return this.impl.nToJSON5(this.peer);
    }

    @NonNull
    public byte[] asData() {
        return this.impl.nAsData(this.peer);
    }

    public boolean asBool() {
        return this.impl.nAsBool(this.peer);
    }

    public long asInt() {
        return this.impl.nAsInt(this.peer);
    }

    public long asUnsigned() {
        return this.impl.nAsUnsigned(this.peer);
    }

    public float asFloat() {
        return this.impl.nAsFloat(this.peer);
    }

    public double asDouble() {
        return this.impl.nAsDouble(this.peer);
    }

    @NonNull
    public String asString() {
        return this.impl.nAsString(this.peer);
    }

    @NonNull
    public List<Object> asArray() {
        return this.asFLArray().asArray();
    }

    @NonNull
    public <T> List<T> asTypedArray() {
        return this.asFLArray().asTypedArray();
    }

    @NonNull
    public FLDict asFLDict() {
        return FLDict.create(this.impl.nAsDict(this.peer));
    }

    @NonNull
    public Map<String, Object> asDict() {
        return this.asFLDict().asDict();
    }

    @Nullable
    public Object asObject() {
        switch (this.impl.nGetType(this.peer)) {
            case 1: {
                return this.asBool();
            }
            case 2: {
                if (this.isInteger()) {
                    return this.isUnsigned() ? Long.valueOf(this.asUnsigned()) : Long.valueOf(this.asInt());
                }
                if (this.isDouble()) {
                    return this.asDouble();
                }
                return Float.valueOf(this.asFloat());
            }
            case 3: {
                return this.asString();
            }
            case 4: {
                return this.asData();
            }
            case 5: {
                return this.asArray();
            }
            case 6: {
                return this.asDict();
            }
        }
        return null;
    }

    @Nullable
    <T> T withContent(@NonNull Fn.Function<Long, T> fn) {
        return fn.apply(this.peer);
    }

    @NonNull
    FLArray asFLArray() {
        return FLArray.create(this.impl.nAsArray(this.peer));
    }

    public static interface NativeImpl {
        public long nFromTrustedData(byte[] var1);

        public long nFromData(long var1, long var3);

        public int nGetType(long var1);

        public boolean nIsInteger(long var1);

        public boolean nIsUnsigned(long var1);

        public boolean nIsDouble(long var1);

        @Nullable
        public String nToString(long var1);

        @Nullable
        public String nToJSON(long var1);

        @Nullable
        public String nToJSON5(long var1);

        @NonNull
        public byte[] nAsData(long var1);

        public boolean nAsBool(long var1);

        public long nAsUnsigned(long var1);

        public long nAsInt(long var1);

        public float nAsFloat(long var1);

        public double nAsDouble(long var1);

        @NonNull
        public String nAsString(long var1);

        public long nAsArray(long var1);

        public long nAsDict(long var1);

        @Nullable
        public String nJson5toJson(@Nullable String var1) throws LiteCoreException;
    }
}

