/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.MValueConverter;
import com.couchbase.lite.internal.fleece.Encodable;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.utils.Preconditions;

public class MValue
extends MValueConverter
implements Encodable {
    static final MValue EMPTY = new MValue(null, null){

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    @Nullable
    private FLValue flValue;
    @Nullable
    private Object value;

    public MValue(@Nullable Object obj) {
        this(obj, null);
    }

    MValue(@Nullable FLValue val) {
        this(null, val);
    }

    private MValue(@Nullable Object obj, @Nullable FLValue val) {
        this.value = obj;
        this.flValue = val;
    }

    @Override
    public void encodeTo(@NonNull FLEncoder enc) {
        if (this.isEmpty()) {
            throw new CouchbaseLiteError("MValue is empty.");
        }
        if (this.flValue != null) {
            enc.writeValue(this.flValue);
        } else if (this.value != null) {
            enc.writeValue(this.value);
        } else {
            enc.writeNull();
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isMutated() {
        return this.flValue == null;
    }

    @Nullable
    public FLValue getValue() {
        return this.flValue;
    }

    public void mutate() {
        Preconditions.assertNotNull(this.value, "Native object");
        this.flValue = null;
    }

    @Nullable
    public Object asNative(@Nullable MCollection parent) {
        if (this.value != null || this.flValue == null) {
            return this.value;
        }
        MValueConverter.NativeValue<?> val = this.toNative(this, parent);
        if (val.cacheIt) {
            this.value = val.nVal;
        }
        return val.nVal;
    }
}

