/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.listener;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.ChangeListener;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.internal.listener.ChangeListenerToken;
import com.couchbase.lite.internal.utils.Fn;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

public abstract class ChangeNotifier<T> {
    @NonNull
    private final Object lock = new Object();
    @NonNull
    private final Set<ChangeListenerToken<T>> listeners = new HashSet<ChangeListenerToken<T>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public final ChangeListenerToken<T> addChangeListener(@Nullable Executor executor, @NonNull ChangeListener<T> listener, @NonNull Fn.Consumer<ListenerToken> onRemove) {
        Object object = this.lock;
        synchronized (object) {
            ChangeListenerToken<T> token = new ChangeListenerToken<T>(listener, executor, onRemove);
            this.listeners.add(token);
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postChange(@NonNull T change) {
        HashSet<ChangeListenerToken<T>> localListeners;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            localListeners = new HashSet<ChangeListenerToken<T>>(this.listeners);
        }
        for (ChangeListenerToken changeListenerToken : localListeners) {
            changeListenerToken.postChange(change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeChangeListener(@NonNull ListenerToken token) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(token);
            return this.listeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final int getListenerCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.listeners.size();
        }
    }

    public static interface C4ChangeProducer<T1>
    extends AutoCloseable {
        @Nullable
        public List<T1> getChanges(int var1);

        @Override
        public void close();
    }
}

