/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.logging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.ConsoleLogger;
import com.couchbase.lite.Database;
import com.couchbase.lite.FileLogger;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.Logger;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.core.C4Log;
import com.couchbase.lite.internal.core.CBLVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.FormatterClosedException;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Log {
    public static final String LOG_HEADER = "[JAVA] ";
    private static final AtomicBoolean WARNED = new AtomicBoolean(false);
    private static final String DEFAULT_MSG = "Unknown error";
    private static volatile Map<String, String> errorMessages;

    private Log() {
    }

    public static void initLogging(boolean debugging, @NonNull Map<String, String> errorMessages) {
        Log.initLoggingInternal();
        Log.setStandardErrorMessages(Collections.unmodifiableMap(errorMessages));
        ConsoleLogger logger = Database.log.getConsole();
        logger.setLevel(LogLevel.INFO);
        Log.i(LogDomain.DATABASE, "CBL-JAVA Initialized: " + CBLVersion.getVersionInfo());
        logger.setLevel(debugging ? LogLevel.DEBUG : LogLevel.WARNING);
    }

    public static void d(@NonNull LogDomain domain, @NonNull String msg) {
        Log.log(LogLevel.DEBUG, domain, null, msg, new Object[0]);
    }

    public static void d(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.log(LogLevel.DEBUG, domain, err, msg, new Object[0]);
    }

    public static void d(@NonNull LogDomain domain, @NonNull String msg, Object ... args) {
        Log.log(LogLevel.DEBUG, domain, null, msg, args);
    }

    public static void d(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.DEBUG, domain, err, msg, args);
    }

    public static void v(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.VERBOSE, domain, err, msg, args);
    }

    public static void i(@NonNull LogDomain domain, @NonNull String msg) {
        Log.log(LogLevel.INFO, domain, null, msg, new Object[0]);
    }

    public static void info(@NonNull LogDomain domain, @NonNull String msg) {
        Log.i(domain, msg);
    }

    public static void i(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.log(LogLevel.INFO, domain, err, msg, new Object[0]);
    }

    public static void info(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.i(domain, msg, err);
    }

    public static void i(@NonNull LogDomain domain, @NonNull String msg, Object ... args) {
        Log.log(LogLevel.INFO, domain, null, msg, args);
    }

    public static void i(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.INFO, domain, err, msg, args);
    }

    public static void w(@NonNull LogDomain domain, @NonNull String msg) {
        Log.log(LogLevel.WARNING, domain, null, msg, new Object[0]);
    }

    public static void w(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.log(LogLevel.WARNING, domain, err, msg, new Object[0]);
    }

    public static void w(@NonNull LogDomain domain, @NonNull String msg, Object ... args) {
        Log.log(LogLevel.WARNING, domain, null, msg, args);
    }

    public static void w(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.WARNING, domain, err, msg, args);
    }

    public static void e(@NonNull LogDomain domain, @NonNull String msg) {
        Log.log(LogLevel.ERROR, domain, null, msg, new Object[0]);
    }

    public static void e(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err) {
        Log.log(LogLevel.ERROR, domain, err, msg, new Object[0]);
    }

    public static void e(@NonNull LogDomain domain, @NonNull String msg, Object ... args) {
        Log.log(LogLevel.ERROR, domain, null, msg, args);
    }

    public static void e(@NonNull LogDomain domain, @NonNull String msg, @Nullable Throwable err, Object ... args) {
        Log.log(LogLevel.ERROR, domain, err, msg, args);
    }

    @NonNull
    public static String lookupStandardMessage(@Nullable String msg) {
        if (msg == null) {
            return DEFAULT_MSG;
        }
        String message = errorMessages == null ? msg : errorMessages.get(msg);
        return message == null ? msg : message;
    }

    @NonNull
    public static String formatStandardMessage(@Nullable String msg, Object ... args) {
        return String.format(Locale.ENGLISH, Log.lookupStandardMessage(msg), args);
    }

    public static void warn() {
        FileLogger fl = Database.log.getFile();
        if (WARNED.getAndSet(true) || fl.getConfig() != null && fl.getLevel() != LogLevel.NONE) {
            return;
        }
        Log.w(LogDomain.DATABASE, "Database.log.getFile().getConfig() is now null: logging is disabled.  Log files required for product support are not being generated.");
    }

    @VisibleForTesting
    public static void initLoggingInternal() {
        C4Log c4Log = C4Log.get();
        c4Log.forceCallbackLevel(Database.log.getConsole().getLevel());
        c4Log.setC4LogLevel(LogDomain.ALL_DOMAINS, LogLevel.DEBUG);
    }

    @VisibleForTesting
    @NonNull
    public static Map<String, String> setStandardErrorMessages(@NonNull Map<String, String> stdErrMsgs) {
        Map<String, String> prevMessages = errorMessages;
        errorMessages = Collections.unmodifiableMap(new HashMap<String, String>(stdErrMsgs));
        return prevMessages;
    }

    private static void log(@NonNull LogLevel level, @NonNull LogDomain domain, @Nullable Throwable err, @NonNull String msg, Object ... args) {
        if (level == null) {
            level = LogLevel.INFO;
        }
        if (!Log.shouldLog(level)) {
            return;
        }
        if (domain == null) {
            domain = LogDomain.DATABASE;
        }
        String message = Log.lookupStandardMessage(msg);
        if (args != null && args.length > 0) {
            message = Log.formatMessage(message, args);
        }
        if (err != null) {
            StringWriter sw = new StringWriter();
            err.printStackTrace(new PrintWriter(sw));
            message = message + System.lineSeparator() + sw;
        }
        Log.sendToLoggers(level, domain, LOG_HEADER + message);
    }

    private static boolean shouldLog(@NonNull LogLevel logLevel) {
        LogLevel fileLogLevel;
        if (LogLevel.VERBOSE.compareTo(logLevel) >= 0 && !CouchbaseLiteInternal.debugging()) {
            return false;
        }
        LogLevel callbackLevel = C4Log.get().getCallbackLevel();
        return (callbackLevel.compareTo(fileLogLevel = Database.log.getFile().getLevel()) < 0 ? callbackLevel : fileLogLevel).compareTo(logLevel) <= 0;
    }

    @NonNull
    private static String formatMessage(@NonNull String msg, Object ... args) {
        try {
            return String.format(Locale.ENGLISH, msg, args);
        }
        catch (FormatterClosedException | IllegalFormatException runtimeException) {
            return msg;
        }
    }

    private static void sendToLoggers(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String msg) {
        com.couchbase.lite.Log logger;
        block8: {
            logger = Database.log;
            ConsoleLogger consoleLogger = logger.getConsole();
            Exception consoleErr = null;
            try {
                consoleLogger.log(level, domain, msg);
            }
            catch (Exception e) {
                consoleErr = e;
            }
            FileLogger fileLogger = logger.getFile();
            try {
                fileLogger.log(level, domain, msg);
                if (consoleErr != null) {
                    consoleLogger.log(LogLevel.ERROR, LogDomain.DATABASE, consoleErr.toString());
                }
            }
            catch (Exception e) {
                if (consoleErr != null) break block8;
                fileLogger.log(LogLevel.ERROR, LogDomain.DATABASE, e.toString());
            }
        }
        Logger custom = logger.getCustom();
        if (custom != null) {
            try {
                custom.log(level, domain, msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

