/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.replicator;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.peers.TaggedWeakPeerBinding;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.replicator.CBLCookieStore;
import com.couchbase.lite.internal.replicator.CBLTrustManager;
import com.couchbase.lite.internal.sockets.CBLSocketException;
import com.couchbase.lite.internal.sockets.CloseStatus;
import com.couchbase.lite.internal.sockets.OkHttpSocket;
import com.couchbase.lite.internal.sockets.SocketFromCore;
import com.couchbase.lite.internal.sockets.SocketFromRemote;
import com.couchbase.lite.internal.sockets.SocketState;
import com.couchbase.lite.internal.sockets.SocketToCore;
import com.couchbase.lite.internal.sockets.SocketToRemote;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.StateMachine;
import com.couchbase.lite.internal.utils.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Challenge;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public abstract class AbstractCBLWebSocket
implements SocketFromCore,
SocketFromRemote,
AutoCloseable {
    public static final int DEFAULT_HEARTBEAT_SEC = 300;
    public static final int MAX_AUTH_RETRIES = 3;
    public static final String HEADER_COOKIES = "Cookies";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_AUTH = "Authorization";
    public static final String HEADER_PROXY_AUTH = "Proxy-Authorization";
    private static final String CHALLENGE_BASIC = "Basic";
    private static final LogDomain LOG_DOMAIN = LogDomain.NETWORK;
    @NonNull
    private static final TaggedWeakPeerBinding<KeyManager> KEY_MANAGERS = new TaggedWeakPeerBinding();
    @NonNull
    private final SocketToCore toCore;
    @NonNull
    private final SocketToRemote toRemote;
    @NonNull
    private final URI uri;
    @Nullable
    private final Map<String, Object> options;
    @NonNull
    private final Fn.Consumer<List<Certificate>> serverCertsListener;
    @GuardedBy(value="getPeerLock()")
    @NonNull
    private final CBLCookieStore cookieStore;
    @GuardedBy(value="getPeerLock()")
    @NonNull
    private final StateMachine<SocketState> state = SocketState.getSocketStateMachine();

    public static long addKeyManager(@NonNull KeyManager keyManager) {
        long token = KEY_MANAGERS.reserveKey();
        KEY_MANAGERS.bind(token, keyManager);
        return token;
    }

    protected AbstractCBLWebSocket(@NonNull SocketToRemote toRemote, @NonNull SocketToCore toCore, @NonNull URI uri, @Nullable byte[] opts, @NonNull CBLCookieStore cookieStore, @NonNull Fn.Consumer<List<Certificate>> serverCertsListener) {
        this.toCore = toCore;
        this.toRemote = toRemote;
        this.uri = uri;
        this.cookieStore = cookieStore;
        this.serverCertsListener = serverCertsListener;
        this.options = opts == null ? null : Collections.unmodifiableMap(FLValue.fromData(opts).asDict());
    }

    @NonNull
    public String toString() {
        return "CBLWebSocket@" + ClassUtils.objId(this) + "{" + this.toCore + " <=> " + this.toRemote + "(" + this.uri + ")}";
    }

    @Nullable
    @VisibleForTesting
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Nullable
    protected abstract CloseStatus handleClose(@NonNull Throwable var1);

    protected abstract int handleCloseCause(@NonNull Throwable var1);

    @Override
    public void close() {
        Log.d(LOG_DOMAIN, "%s.close: %s", this, this.uri);
        this.toCore.requestCoreClose(new CloseStatus(1001, "Closed by client"));
    }

    @Override
    public final void coreRequestsOpen() {
        Log.d(LOG_DOMAIN, "%s.coreRequestedOpen", this);
        if (!this.changeState(SocketState.OPENING)) {
            return;
        }
        this.toRemote.openRemote(this.uri, this.options);
    }

    @Override
    public final void coreWrites(@NonNull byte[] data) {
        int len = data.length;
        Log.d(LOG_DOMAIN, "%s.coreWrites: %d", this, len);
        if (!this.assertState(SocketState.OPEN, SocketState.CLOSING)) {
            return;
        }
        if (this.toRemote.writeToRemote(data)) {
            this.toCore.ackWriteToCore(len);
            return;
        }
        Log.i(LOG_DOMAIN, "CBLWebSocket failed to send data of length: " + len);
    }

    @Override
    public void coreAcksWrite(long n) {
        Log.d(LOG_DOMAIN, "%s.coreAckReceive: %d", this, n);
    }

    @Override
    public final void coreRequestsClose(@NonNull CloseStatus status) {
        Log.d(LOG_DOMAIN, "%s.coreRequestsClose: %s", this, status);
        if (!this.assertState(SocketState.OPENING, SocketState.OPEN, SocketState.CLOSING)) {
            return;
        }
        if (status.code > 100 && status.code < 600) {
            status = new CloseStatus(6, 1008, status.message);
        }
        if (this.toRemote.closeRemote(status)) {
            return;
        }
        Log.d(LOG_DOMAIN, "%s.coreRequestsClose: Could not close remote", this);
    }

    @Override
    public final void coreClosed() {
        Log.w(LOG_DOMAIN, "%s.coreClosed: ignoring unexpected call", this);
    }

    @Override
    @NonNull
    public Object getLock() {
        return this.toCore.getLock();
    }

    @Override
    public void setupRemoteSocketFactory(@NonNull OkHttpClient.Builder builder) {
        Map auth = null;
        boolean acceptParentDomainCookies = false;
        if (this.options != null) {
            Object heartbeat;
            Object opt = this.options.get("auth");
            if (opt instanceof Map) {
                auth = (Map)opt;
            }
            builder.pingInterval((heartbeat = this.options.get("heartbeat")) instanceof Number ? (Long)heartbeat : 300L, TimeUnit.SECONDS);
            Object acceptParentCookies = this.options.get("acceptParentDomainCookies");
            if (acceptParentCookies instanceof Boolean) {
                acceptParentDomainCookies = (Boolean)acceptParentCookies;
            }
        }
        if (auth != null) {
            this.setupAuthentication(builder, auth);
        }
        builder.cookieJar((CookieJar)new WebSocketCookieJar(acceptParentDomainCookies));
        this.setupSSLSocketFactory(builder, auth);
    }

    @Override
    public void remoteOpened(int code, @Nullable Map<String, Object> headers) {
        Log.d(LOG_DOMAIN, "%s.remoteOpened: %s", this, headers);
        if (!this.changeState(SocketState.OPEN)) {
            return;
        }
        this.toCore.ackOpenToCore(code, this.encodeHeaders(headers));
    }

    @Override
    public void remoteWrites(@NonNull byte[] data) {
        Log.d(LOG_DOMAIN, "%s.remoteWrites: %d", this, data.length);
        if (!this.assertState(SocketState.OPEN, SocketState.CLOSING)) {
            return;
        }
        this.toCore.writeToCore(data);
    }

    @Override
    public void remoteRequestsClose(@NonNull CloseStatus status) {
        Log.d(LOG_DOMAIN, "%s.remoteRequestsClose: %s", this, status);
        if (!this.changeState(SocketState.CLOSING)) {
            return;
        }
        this.toCore.requestCoreClose(status);
    }

    @Override
    public void remoteClosed(@NonNull CloseStatus status) {
        Log.d(LOG_DOMAIN, "%s.remoteClosed: %s", this, status);
        if (!this.changeState(SocketState.CLOSED)) {
            return;
        }
        if (status.code == 1000) {
            status = new CloseStatus(1, 0, status.message);
        }
        this.toCore.closeCore(status);
    }

    @Override
    public void remoteFailed(@NonNull Throwable err) {
        Log.d(LOG_DOMAIN, "%s.remoteFailed", err, this);
        if (!this.changeState(SocketState.CLOSED)) {
            return;
        }
        this.toCore.closeCore(this.getStatusForError(err));
    }

    @VisibleForTesting
    @NonNull
    SocketState getSocketState() {
        return this.state.getCurrentState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeState(@NonNull SocketState newState) {
        Object object = this.getLock();
        synchronized (object) {
            return this.state.setState(newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assertState(SocketState ... expectedStates) {
        Object object = this.getLock();
        synchronized (object) {
            return this.state.assertState(expectedStates);
        }
    }

    @Nullable
    private byte[] encodeHeaders(@Nullable Map<String, Object> headers) {
        FLEncoder enc = FLEncoder.getManagedEncoder();
        try {
            enc.write(headers);
            byte[] byArray = enc.finish();
            if (enc != null) {
                enc.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (enc != null) {
                    try {
                        enc.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (LiteCoreException e) {
                Log.w(LOG_DOMAIN, "CBLWebSocket failed to encode response headers", e);
                Log.d(LOG_DOMAIN, StringUtils.toString(headers));
                return null;
            }
        }
    }

    @NonNull
    private CloseStatus getStatusForError(@Nullable Throwable error) {
        int code;
        Log.i(LOG_DOMAIN, "WebSocket CLOSED with error", error);
        if (error == null) {
            return new CloseStatus(6, 0, null);
        }
        CloseStatus platformStatus = this.handleClose(error);
        if (platformStatus != null) {
            return platformStatus;
        }
        int causeCode = this.getCodeForError(error);
        int domain = 5;
        if (error instanceof SocketTimeoutException) {
            code = 3;
        } else if (error instanceof NoRouteToHostException || error instanceof PortUnreachableException) {
            code = 24;
        } else if (error instanceof SocketException || error instanceof EOFException) {
            code = 22;
        } else if (causeCode > 0) {
            code = causeCode;
        } else if (error instanceof UnknownHostException) {
            code = 2;
        } else if (error instanceof SSLHandshakeException) {
            code = 6;
        } else if (error instanceof SSLKeyException || error instanceof SSLPeerUnverifiedException) {
            code = 8;
        } else if (error instanceof SSLProtocolException) {
            domain = 6;
            code = 1002;
        } else if (error instanceof SSLException) {
            code = 18;
        } else {
            domain = 6;
            code = 1008;
        }
        return new CloseStatus(domain, code, error.toString());
    }

    private int getCodeForError(Throwable error) {
        Throwable cause = error.getCause();
        if (cause == null) {
            return -1;
        }
        int code = this.handleCloseCause(cause);
        if (code > 0) {
            return code;
        }
        if (cause instanceof CertificateExpiredException) {
            return 14;
        }
        if (cause instanceof CertificateException) {
            return 8;
        }
        return 0;
    }

    private void setupAuthentication(@NonNull OkHttpClient.Builder builder, @NonNull Map<?, ?> auth) {
        Object proxyUser = auth.get("proxyUser");
        Object proxyPass = auth.get("proxyPassword");
        if (proxyUser instanceof String && proxyPass instanceof String) {
            String proxyCred = Credentials.basic((String)((String)proxyUser), (String)((String)proxyPass));
            builder.proxyAuthenticator((route, resp) -> this.authenticate(resp, HEADER_PROXY_AUTH, proxyCred));
        }
        if (CHALLENGE_BASIC.equals(auth.get("type"))) {
            Object endptUser = auth.get("username");
            Object endptPass = auth.get("password");
            if (endptUser instanceof String && endptPass instanceof String) {
                String endptCred = Credentials.basic((String)((String)endptUser), (String)((String)endptPass));
                builder.authenticator((route, resp) -> this.authenticate(resp, HEADER_AUTH, endptCred));
                this.forcePreAuth(builder, endptCred);
            }
        }
    }

    private void forcePreAuth(@NonNull OkHttpClient.Builder builder, @NonNull String endptCred) {
        builder.addInterceptor(chain -> {
            Request req = chain.request();
            try {
                return chain.proceed(chain.connection() != null ? req : req.newBuilder().header(HEADER_AUTH, endptCred).method(req.method(), req.body()).build());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Unexpected interceptor failure @" + Thread.currentThread() + ": " + req.method() + " \"" + req.body() + "\"", e);
            }
        });
    }

    private void setupSSLSocketFactory(@NonNull OkHttpClient.Builder builder, @Nullable Map<?, ?> auth) {
        SSLContext sslContext;
        X509Certificate pinnedServerCert = null;
        boolean acceptOnlySelfSignedServerCert = false;
        KeyManager[] keyManagers = null;
        InetAddress iFace = null;
        if (this.options != null) {
            KeyManager clientCertAuthKeyManager;
            Object opt = this.options.get("pinnedCert");
            if (opt instanceof byte[]) {
                try {
                    pinnedServerCert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream((byte[])opt));
                }
                catch (CertificateException e) {
                    Log.w(LOG_DOMAIN, "Can't parse pinned certificate.  Ignored", e);
                }
            }
            if ((opt = this.options.get("onlySelfSignedServer")) instanceof Boolean) {
                acceptOnlySelfSignedServerCert = (Boolean)opt;
            }
            if ((clientCertAuthKeyManager = this.getKeyManager(auth)) != null) {
                keyManagers = new KeyManager[]{clientCertAuthKeyManager};
            }
            if ((opt = this.options.get("networkInterface")) instanceof String) {
                iFace = this.getSelectedInterface((String)opt);
            }
        }
        CBLTrustManager trustManager = new CBLTrustManager(pinnedServerCert, acceptOnlySelfSignedServerCert, this.serverCertsListener);
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new CBLSocketException(6, 1011, "Failed getting SSL context", e);
        }
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        builder.sslSocketFactory(iFace == null ? socketFactory : new ConstrainedAddressSocketFactory(iFace, socketFactory), (X509TrustManager)trustManager);
        if (pinnedServerCert != null || acceptOnlySelfSignedServerCert) {
            builder.hostnameVerifier((s, sslSession) -> true);
        }
    }

    @Nullable
    private KeyManager getKeyManager(@Nullable Map<?, ?> auth) {
        if (auth == null || !"Client Cert".equals(auth.get("type"))) {
            return null;
        }
        KeyManager keyManager = null;
        Object certKey = auth.get("clientCertKey");
        if (certKey instanceof Long) {
            keyManager = (KeyManager)KEY_MANAGERS.getBinding((Long)certKey);
        }
        if (keyManager == null) {
            Log.i(LOG_DOMAIN, "CBLWebSocket: No key manager configured for client certificate authentication");
        }
        return keyManager;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    @Nullable
    private Request authenticate(@NonNull Response resp, @NonNull String header, @NonNull String cred) {
        Log.d(LOG_DOMAIN, "%s.authenticate: %s", this, resp);
        if (this.responseCount(resp) >= 3) {
            return null;
        }
        List challenges = resp.challenges();
        Log.d(LOG_DOMAIN, "challenges: %s", challenges);
        if (challenges == null) {
            return null;
        }
        for (Challenge challenge : challenges) {
            if (!CHALLENGE_BASIC.equalsIgnoreCase(challenge.scheme())) continue;
            return resp.request().newBuilder().header(header, cred).build();
        }
        return null;
    }

    @NonNull
    private InetAddress getSelectedInterface(@NonNull String iFace) {
        try {
            for (NetworkInterface netIf : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                List<InterfaceAddress> ifAddys;
                if (!iFace.equals(netIf.getName()) || (ifAddys = netIf.getInterfaceAddresses()) == null || ifAddys.isEmpty()) continue;
                return ifAddys.get(0).getAddress();
            }
        }
        catch (SocketException e) {
            throw new CBLSocketException(5, 20, "Could not get device interfaces", e);
        }
        try {
            return InetAddress.getByName(iFace);
        }
        catch (UnknownHostException e) {
            throw new CBLSocketException(5, 27, "Could not resolve specified interface: " + iFace, e);
        }
    }

    private int responseCount(Response resp) {
        int result = 1;
        while ((resp = resp.priorResponse()) != null) {
            ++result;
        }
        return result;
    }

    private class WebSocketCookieJar
    implements CookieJar {
        private final boolean acceptParentDomain;

        WebSocketCookieJar(boolean acceptParentDomain) {
            this.acceptParentDomain = acceptParentDomain;
        }

        public void saveFromResponse(@NonNull HttpUrl httpUrl, @NonNull List<Cookie> cookies) {
            AbstractCBLWebSocket.this.cookieStore.setCookies(httpUrl.uri(), Fn.mapToList(cookies, Cookie::toString), this.acceptParentDomain);
        }

        @NonNull
        public List<Cookie> loadForRequest(@NonNull HttpUrl url) {
            String setCookies;
            Object confCookies;
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            if (!AbstractCBLWebSocket.this.state.assertState(new SocketState[]{SocketState.UNOPENED, SocketState.OPENING})) {
                return cookies;
            }
            if (AbstractCBLWebSocket.this.options != null && (confCookies = AbstractCBLWebSocket.this.options.get("cookies")) instanceof String) {
                cookies.addAll(OkHttpSocket.parseCookies(url, (String)confCookies));
            }
            if ((setCookies = AbstractCBLWebSocket.this.cookieStore.getCookies(url.uri())) != null) {
                cookies.addAll(OkHttpSocket.parseCookies(url, setCookies));
            }
            return cookies;
        }
    }

    private static final class ConstrainedAddressSocketFactory
    extends SSLSocketFactory {
        @NonNull
        private final InetAddress localAddress;
        @NonNull
        private final SSLSocketFactory delegate;

        private ConstrainedAddressSocketFactory(@NonNull InetAddress localAddress, @NonNull SSLSocketFactory delegate) {
            this.localAddress = localAddress;
            this.delegate = delegate;
        }

        @Override
        @NonNull
        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        @Override
        @NonNull
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        @NonNull
        public Socket createSocket(@NonNull Socket socket, @NonNull String remoteHost, int port, boolean autoClose) throws IOException {
            return this.delegate.createSocket(socket, remoteHost, port, autoClose);
        }

        @Override
        @NonNull
        public Socket createSocket(@NonNull InetAddress remoteHost, int port) throws IOException {
            return this.createSocket(remoteHost, port, this.localAddress, 0);
        }

        @Override
        @NonNull
        public Socket createSocket(@NonNull InetAddress remoteHost, int remotePort, @NonNull InetAddress localAddress, int localPort) throws IOException {
            return this.delegate.createSocket(remoteHost, remotePort, localAddress, localPort);
        }

        @Override
        @NonNull
        public Socket createSocket(@NonNull String remoteHost, int port) throws IOException {
            return this.delegate.createSocket(remoteHost, port, this.localAddress, 0);
        }

        @Override
        @NonNull
        public Socket createSocket(@NonNull String remoteHost, int remotePort, @NonNull InetAddress localAddress, int localPort) throws IOException {
            return this.delegate.createSocket(remoteHost, remotePort, localAddress, localPort);
        }
    }
}

