/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface Fn {
    public static <T> void forAll(@NonNull Collection<? extends T> c, @NonNull Consumer<T> op) {
        for (T e : c) {
            op.accept(e);
        }
    }

    @Nullable
    public static <T> T firstOrNull(@NonNull Collection<? extends T> c, @NonNull Predicate<T> pred) {
        for (T e : c) {
            if (!pred.test(e)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    public static <T, R> R foldR(@NonNull Collection<? extends T> c, @NonNull R init, @NonNull BiFunction<R, T, R> fn) {
        R r = init;
        for (T e : c) {
            r = fn.apply(r, e);
        }
        return r;
    }

    @NonNull
    public static <T> List<T> filterToList(@NonNull Collection<? extends T> s, @NonNull NullablePredicate<T> pred) {
        ArrayList<T> r = new ArrayList<T>(s.size());
        for (T e : s) {
            if (!pred.test(e)) continue;
            r.add(e);
        }
        return r;
    }

    @NonNull
    public static <T> Set<T> filterToSet(@NonNull Collection<? extends T> s, @NonNull Predicate<T> pred) {
        HashSet<T> r = new HashSet<T>(s.size());
        for (T e : s) {
            if (!pred.test(e)) continue;
            r.add(e);
        }
        return r;
    }

    @NonNull
    public static <T, R, E extends Exception> List<R> mapToList(@NonNull Collection<? extends T> l, @NonNull FunctionThrows<T, R, E> fn) throws E {
        ArrayList<R> r = new ArrayList<R>(l.size());
        for (T e : l) {
            r.add(fn.apply(e));
        }
        return r;
    }

    @NonNull
    public static <T, R, E extends Exception> Set<R> mapToSet(@NonNull Collection<? extends T> s, @NonNull FunctionThrows<T, R, E> fn) throws E {
        HashSet<R> r = new HashSet<R>(s.size());
        for (T e : s) {
            r.add(fn.apply(e));
        }
        return r;
    }

    @FunctionalInterface
    public static interface Consumer<T> {
        public void accept(@NonNull T var1);
    }

    @FunctionalInterface
    public static interface Predicate<T> {
        public boolean test(@NonNull T var1);
    }

    @FunctionalInterface
    public static interface BiFunction<T1, T2, R> {
        @Nullable
        public R apply(@NonNull T1 var1, @NonNull T2 var2);
    }

    @FunctionalInterface
    public static interface NullablePredicate<T> {
        public boolean test(@Nullable T var1);
    }

    @FunctionalInterface
    public static interface FunctionThrows<T, R, E extends Exception> {
        @NonNull
        public R apply(@NonNull T var1) throws E;
    }

    @FunctionalInterface
    public static interface Runner {
        public void run(@NonNull Runnable var1);
    }

    @FunctionalInterface
    public static interface TaskThrows<E extends Exception> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface NullableConsumer<T> {
        public void accept(@Nullable T var1);
    }

    @FunctionalInterface
    public static interface ConsumerThrows<T, E extends Exception> {
        public void accept(@NonNull T var1) throws E;
    }

    @FunctionalInterface
    public static interface ProviderThrows<T, E extends Exception> {
        @Nullable
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface Provider<T> {
        @Nullable
        public T get();
    }

    @FunctionalInterface
    public static interface Function<T, R> {
        @Nullable
        public R apply(@NonNull T var1);
    }

    @FunctionalInterface
    public static interface NonNullFunction<T, R> {
        @NonNull
        public R apply(@NonNull T var1);
    }

    @FunctionalInterface
    public static interface NullableFunctionThrows<T, R, E extends Exception> {
        @Nullable
        public R apply(@NonNull T var1) throws E;
    }
}

