/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.internal.utils.PlatformUtils;
import java.io.InputStream;
import java.util.Base64;

public final class PlatformUtilsDelegate
implements PlatformUtils.Delegate {
    @Override
    @Nullable
    public InputStream getAsset(@Nullable String asset) {
        if (asset == null) {
            return null;
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(asset);
    }

    @Override
    @NonNull
    public PlatformUtils.Base64Encoder getEncoder() {
        return new PlatformUtils.Base64Encoder(){
            private final Base64.Encoder encoder = Base64.getEncoder();

            @Override
            @Nullable
            public String encodeToString(@Nullable byte[] src) {
                return this.encoder.encodeToString(src);
            }
        };
    }

    @Override
    @NonNull
    public PlatformUtils.Base64Decoder getDecoder() {
        return new PlatformUtils.Base64Decoder(){
            private final Base64.Decoder decoder = Base64.getDecoder();

            @Override
            @Nullable
            public byte[] decodeString(@Nullable String src) {
                try {
                    return src == null ? null : this.decoder.decode(src);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
        };
    }
}

