/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.StringUtils;
import java.util.Collection;

public final class Preconditions {
    private Preconditions() {
    }

    public static long assertPositive(long n, @NonNull String name) {
        if (n <= 0L) {
            throw new IllegalArgumentException(name + " must be >0");
        }
        return n;
    }

    public static int assertPositive(int n, @NonNull String name) {
        if (n <= 0) {
            throw new IllegalArgumentException(name + " must be >0");
        }
        return n;
    }

    public static long assertNegative(long n, @NonNull String name) {
        if (n >= 0L) {
            throw new IllegalArgumentException(name + " must be <0");
        }
        return n;
    }

    public static int assertNegative(int n, @NonNull String name) {
        if (n >= 0) {
            throw new IllegalArgumentException(name + " must be <0");
        }
        return n;
    }

    public static long assertNotNegative(long n, @NonNull String name) {
        if (n < 0L) {
            throw new IllegalArgumentException(name + " must be >=0");
        }
        return n;
    }

    public static int assertNotNegative(int n, @NonNull String name) {
        if (n < 0) {
            throw new IllegalArgumentException(name + " must be >=0");
        }
        return n;
    }

    public static long assertZero(long n, @NonNull String name) {
        if (n != 0L) {
            throw new IllegalArgumentException(name + " must be 0");
        }
        return n;
    }

    public static int assertZero(int n, @NonNull String name) {
        if (n != 0) {
            throw new IllegalArgumentException(name + " must be 0");
        }
        return n;
    }

    public static long assertNotZero(long n, @NonNull String name) {
        if (n == 0L) {
            throw new IllegalArgumentException(name + " must not be 0");
        }
        return n;
    }

    public static int assertNotZero(int n, @NonNull String name) {
        if (n == 0) {
            throw new IllegalArgumentException(name + " must not be 0");
        }
        return n;
    }

    public static int assertInt(long n, @NonNull String name) {
        if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(name + " must be " + Integer.MIN_VALUE + " <= " + n + " <= " + Integer.MAX_VALUE);
        }
        return (int)n;
    }

    public static long assertUInt32(long n, @NonNull String name) {
        if (n < 0L || n >= 0x100000000L) {
            throw new IllegalArgumentException(name + " must be 0 <= " + n + " < 2^32");
        }
        return n;
    }

    @NonNull
    public static <T> T assertNotNull(@Nullable T obj, @NonNull String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " must not be null");
        }
        return obj;
    }

    @NonNull
    public static String assertNotEmpty(@Nullable String str, @NonNull String name) {
        if (StringUtils.isEmpty(str)) {
            throw new IllegalArgumentException(name + " must not be empty");
        }
        return str;
    }

    @NonNull
    public static <K extends Collection<T>, T> K assertNotEmpty(@Nullable K obj, @NonNull String name) {
        if (obj == null || obj.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be null or empty");
        }
        return obj;
    }

    @NonNull
    public static char[] assertNotEmpty(@Nullable char[] str, @NonNull String name) {
        if (str == null || str.length <= 0) {
            throw new IllegalArgumentException(name + " must not be empty");
        }
        return str;
    }

    public static void assertThat(boolean condition, @NonNull String msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    @Nullable
    public static <T> T assertThat(@Nullable T obj, @NonNull String msg, @NonNull Fn.NullablePredicate<T> predicate) {
        if (!predicate.test(obj)) {
            throw new IllegalArgumentException(msg);
        }
        return obj;
    }
}

