/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.AbstractReplicator;
import com.couchbase.lite.BaseDatabase;
import com.couchbase.lite.Blob;
import com.couchbase.lite.Collection;
import com.couchbase.lite.CollectionConfiguration;
import com.couchbase.lite.ConcurrencyControl;
import com.couchbase.lite.Conflict;
import com.couchbase.lite.ConflictHandler;
import com.couchbase.lite.ConflictResolver;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.DatabaseChange;
import com.couchbase.lite.DatabaseChangeListener;
import com.couchbase.lite.DatabaseConfiguration;
import com.couchbase.lite.Document;
import com.couchbase.lite.DocumentChangeListener;
import com.couchbase.lite.Index;
import com.couchbase.lite.IndexConfiguration;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.Log;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.MaintenanceType;
import com.couchbase.lite.MutableDocument;
import com.couchbase.lite.N1qlQuery;
import com.couchbase.lite.Query;
import com.couchbase.lite.ReplicatedDocument;
import com.couchbase.lite.Replicator;
import com.couchbase.lite.ReplicatorActivityLevel;
import com.couchbase.lite.ReplicatorType;
import com.couchbase.lite.Scope;
import com.couchbase.lite.UnitOfWork;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.ImmutableDatabaseConfiguration;
import com.couchbase.lite.internal.SocketFactory;
import com.couchbase.lite.internal.core.C4Collection;
import com.couchbase.lite.internal.core.C4Database;
import com.couchbase.lite.internal.core.C4Document;
import com.couchbase.lite.internal.core.C4Query;
import com.couchbase.lite.internal.core.C4Replicator;
import com.couchbase.lite.internal.core.C4Socket;
import com.couchbase.lite.internal.exec.ClientTask;
import com.couchbase.lite.internal.exec.ExecutionService;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLSharedKeys;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.listener.ChangeListenerToken;
import com.couchbase.lite.internal.listener.Listenable;
import com.couchbase.lite.internal.logging.LogSinksImpl;
import com.couchbase.lite.internal.replicator.ConflictResolutionException;
import com.couchbase.lite.internal.sockets.MessageFraming;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.FileUtils;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.PlatformUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

abstract class AbstractDatabase
extends BaseDatabase
implements Listenable<DatabaseChange, DatabaseChangeListener>,
AutoCloseable {
    private static final String ERROR_RESOLVER_FAILED = "Conflict resolution failed for document '%s': %s";
    private static final String WARN_WRONG_ID = "Conflict resolution for a document produced a new document with ID '%s', which does not match the IDs of the conflicting document (%s)";
    private static final String WARN_WRONG_COLLECTION = "Conflict resolution for document '%s' produced a new document belonging to collection '%s', not the collection into which it would be stored (%s)";
    private static final LogDomain DOMAIN = LogDomain.DATABASE;
    private static final int DB_CLOSE_WAIT_SECS = 6;
    private static final int DB_CLOSE_MAX_RETRIES = 5;
    private static final int EXECUTOR_CLOSE_MAX_WAIT_SECS = 5;
    @Deprecated
    @NonNull
    public static final Log log = new Log();
    @NonNull
    protected final ImmutableDatabaseConfiguration config;
    @NonNull
    private final String name;
    private final ExecutionService.CloseableExecutor postExecutor;
    private final ExecutionService.CloseableExecutor queryExecutor;
    private final FLSharedKeys sharedKeys;
    @GuardedBy(value="activeProcesses")
    private final Set<ActiveProcess<?>> activeProcesses;
    @GuardedBy(value="dbLock")
    private Collection defaultCollection;
    private volatile CountDownLatch closeLatch;

    public static void delete(@NonNull String name, @Nullable File directory) throws CouchbaseLiteException {
        Preconditions.assertNotNull(name, "name");
        if (directory == null) {
            directory = CouchbaseLiteInternal.getDefaultDbDir();
        }
        if (!AbstractDatabase.exists(name, directory)) {
            throw new CouchbaseLiteException("Database not found for delete", "CouchbaseLite", 7);
        }
        com.couchbase.lite.internal.logging.Log.d(DOMAIN, "Delete database %s in %s", name, directory);
        try {
            C4Database.deleteNamedDb(directory.getCanonicalPath(), name);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
        catch (IOException e) {
            throw new CouchbaseLiteException("No canonical path for " + directory, e);
        }
    }

    public static boolean exists(@NonNull String name, @Nullable File directory) {
        Preconditions.assertNotNull(name, "name");
        if (directory == null) {
            directory = CouchbaseLiteInternal.getDefaultDbDir();
        }
        return C4Database.getDatabaseFile(directory, name).exists();
    }

    protected static void copy(@NonNull File path, @NonNull String name, @NonNull String dbDir, int algorithm, byte[] encryptionKey) throws CouchbaseLiteException {
        CouchbaseLiteException err;
        Preconditions.assertNotNull(path, "path");
        Preconditions.assertNotNull(name, "name");
        try {
            C4Database.copyDb(path.getCanonicalPath(), dbDir, name, algorithm, encryptionKey);
            return;
        }
        catch (LiteCoreException e) {
            err = CouchbaseLiteException.convertException(e);
        }
        catch (IOException e) {
            err = new CouchbaseLiteException("Failed creating canonical path for " + path, e);
        }
        FileUtils.eraseFileOrDir(C4Database.getDatabaseFile(new File(dbDir), name));
        throw err;
    }

    @Nullable
    static Database getDbForCollections(@Nullable Set<Collection> collections) {
        if (collections == null || collections.isEmpty()) {
            return null;
        }
        Database db = collections.iterator().next().getDatabase();
        db.verifyCollections(collections);
        return db;
    }

    protected AbstractDatabase(@NonNull String name) throws CouchbaseLiteException {
        this(name, new ImmutableDatabaseConfiguration(null));
    }

    protected AbstractDatabase(@NonNull String name, @NonNull DatabaseConfiguration config) throws CouchbaseLiteException {
        this(name, new ImmutableDatabaseConfiguration(config));
    }

    protected AbstractDatabase(@NonNull String name, @NonNull ImmutableDatabaseConfiguration config) throws CouchbaseLiteException {
        Preconditions.assertNotEmpty(name, "db name");
        Preconditions.assertNotNull(config, "config");
        CouchbaseLiteInternal.requireInit("Cannot create database");
        this.name = name;
        this.config = config;
        this.postExecutor = CouchbaseLiteInternal.getExecutionService().getSerialExecutor();
        this.queryExecutor = CouchbaseLiteInternal.getExecutionService().getSerialExecutor();
        this.activeProcesses = new HashSet();
        this.fixHydrogenBug(config, name);
        C4Database c4db = this.openC4Db();
        this.setC4DatabaseLocked(c4db);
        this.sharedKeys = c4db.getFLSharedKeys();
        LogSinksImpl.warnNoFileLogSink();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getPath() {
        Object object = this.getDbLock();
        synchronized (object) {
            return !this.isOpenLocked() ? null : this.getDbPath();
        }
    }

    public boolean performMaintenance(MaintenanceType type) throws CouchbaseLiteException {
        Object object = this.getDbLock();
        synchronized (object) {
            try {
                return this.getOpenC4DbLocked().performMaintenance(type);
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
    }

    @Override
    public void close() throws CouchbaseLiteException {
        com.couchbase.lite.internal.logging.Log.d(DOMAIN, "Closing %s at path %s", this, this.getDbPath());
        this.shutdown(false, C4Database::closeDb);
    }

    public void delete() throws CouchbaseLiteException {
        com.couchbase.lite.internal.logging.Log.d(DOMAIN, "Deleting %s at path %s", this, this.getDbPath());
        this.shutdown(true, C4Database::deleteDb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public final Set<Scope> getScopes() throws CouchbaseLiteException {
        Object object = this.getDbLock();
        synchronized (object) {
            Set<String> scopeNames;
            C4Database c4db = this.getC4DbOrThrowLocked();
            try {
                scopeNames = c4db.getScopeNames();
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
            HashSet<Scope> scopes = new HashSet<Scope>(scopeNames.size());
            for (String scopeName : scopeNames) {
                scopes.add(new Scope(scopeName, this.getDatabase()));
            }
            return scopes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Scope getScope(@NonNull String name) throws CouchbaseLiteException {
        Object object = this.getDbLock();
        synchronized (object) {
            return !this.getC4DbOrThrowLocked().hasScope(name) ? null : new Scope(name, this.getDatabase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public final Scope getDefaultScope() throws CouchbaseLiteException {
        Object object = this.getDbLock();
        synchronized (object) {
            this.assertOpenChecked();
            return new Scope(this.getDatabase());
        }
    }

    @NonNull
    public final Collection createCollection(@NonNull String name) throws CouchbaseLiteException {
        return this.createCollection(name, "_default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public final Collection createCollection(@NonNull String collectionName, @Nullable String scopeName) throws CouchbaseLiteException {
        if (scopeName == null) {
            scopeName = "_default";
        }
        Object object = this.getDbLock();
        synchronized (object) {
            this.assertOpenChecked();
            return Collection.createCollection(this.getDatabase(), scopeName, collectionName);
        }
    }

    @NonNull
    public final Set<Collection> getCollections() throws CouchbaseLiteException {
        return this.getCollections("_default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public final Set<Collection> getCollections(@Nullable String scopeName) throws CouchbaseLiteException {
        Set<String> collectionNames;
        if (scopeName == null) {
            scopeName = "_default";
        }
        Object object = this.getDbLock();
        synchronized (object) {
            C4Database c4db = this.getC4DbOrThrowLocked();
            try {
                collectionNames = c4db.getCollectionNames(scopeName);
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
        HashSet<Collection> collections = new HashSet<Collection>();
        for (String collectionName : collectionNames) {
            collections.add(this.getCollection(collectionName, scopeName));
        }
        return collections;
    }

    @Nullable
    public final Collection getCollection(@NonNull String name) throws CouchbaseLiteException {
        return this.getCollection(name, "_default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Collection getCollection(@NonNull String collectionName, @Nullable String scopeName) throws CouchbaseLiteException {
        if (scopeName == null) {
            scopeName = "_default";
        }
        Object object = this.getDbLock();
        synchronized (object) {
            this.assertOpenChecked();
            return Collection.getCollection(this.getDatabase(), scopeName, collectionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public final Collection getDefaultCollection() throws CouchbaseLiteException {
        Object object = this.getDbLock();
        synchronized (object) {
            this.assertOpenChecked();
            return this.getDefaultCollectionLocked();
        }
    }

    public final void deleteCollection(@NonNull String name) throws CouchbaseLiteException {
        this.deleteCollection(name, "_default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteCollection(@NonNull String collectionName, @Nullable String scopeName) throws CouchbaseLiteException {
        if (scopeName == null) {
            scopeName = "_default";
        }
        Object object = this.getDbLock();
        synchronized (object) {
            try {
                this.getC4DbOrThrowLocked().deleteCollection(scopeName, collectionName);
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Exception> void inBatch(@NonNull UnitOfWork<T> work) throws CouchbaseLiteException, T {
        Preconditions.assertNotNull(work, "work");
        boolean commit = false;
        Object object = this.getDbLock();
        synchronized (object) {
            C4Database db = this.getOpenC4DbLocked();
            try {
                db.beginTransaction();
                try {
                    work.run();
                    commit = true;
                }
                finally {
                    db.endTransaction(commit);
                }
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Query createQuery(@NonNull String query) {
        Object object = this.getDbLock();
        synchronized (object) {
            this.assertOpenUnchecked();
            return new N1qlQuery(this, query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBlob(@NonNull Blob blob) {
        Object object = this.getDbLock();
        synchronized (object) {
            this.assertOpenUnchecked();
        }
        blob.installInDatabase((Database)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Blob getBlob(@NonNull Map<String, Object> props) {
        Object object = this.getDbLock();
        synchronized (object) {
            this.assertOpenUnchecked();
        }
        if (!Blob.isBlob(props)) {
            throw new IllegalArgumentException("getBlob arg does not specify a blob");
        }
        Blob blob = new Blob(this, props);
        return blob.updateSize() < 0L ? null : blob;
    }

    @NonNull
    public DatabaseConfiguration getConfig() {
        return new DatabaseConfiguration(this.config);
    }

    @NonNull
    public String toString() {
        return "Database{@" + ClassUtils.objId(this) + ": '" + this.name + (this.config.isFullSync() ? "!" : "") + (this.config.isMMapEnabled() ? "*" : "") + "'}";
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractDatabase)) {
            return false;
        }
        AbstractDatabase other = (AbstractDatabase)o;
        return Objects.equals(this.getPath(), other.getPath()) && this.name.equals(other.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long getCount() {
        try {
            Object object = this.getDbLock();
            synchronized (object) {
                return this.getDefaultCollectionLocked().getCount();
            }
        }
        catch (CouchbaseLiteException e) {
            throw new CouchbaseLiteError("Failed getting default collection", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nullable
    public Document getDocument(@NonNull String id) {
        Object object = this.getDbLock();
        synchronized (object) {
            try {
                return this.getDefaultCollectionOrThrow().getDocument(id);
            }
            catch (CouchbaseLiteException e) {
                com.couchbase.lite.internal.logging.Log.i(LogDomain.DATABASE, "Failed retrieving document: %s", e, id);
            }
        }
        return null;
    }

    @Deprecated
    public void save(@NonNull MutableDocument document) throws CouchbaseLiteException {
        this.save(document, ConcurrencyControl.LAST_WRITE_WINS);
    }

    @Deprecated
    public boolean save(@NonNull MutableDocument document, @NonNull ConcurrencyControl concurrencyControl) throws CouchbaseLiteException {
        return this.getDefaultCollectionOrThrow().save(document, concurrencyControl);
    }

    @Deprecated
    public boolean save(@NonNull MutableDocument document, @NonNull ConflictHandler conflictHandler) throws CouchbaseLiteException {
        Preconditions.assertNotNull(document, "document");
        Preconditions.assertNotNull(conflictHandler, "conflictHandler");
        try {
            return this.getDefaultCollectionOrThrow().save(document, conflictHandler);
        }
        catch (CouchbaseLiteException e) {
            if (!"CouchbaseLite".equals(e.getDomain()) || 6 != e.getCode()) {
                throw e;
            }
            throw new CouchbaseLiteError(com.couchbase.lite.internal.logging.Log.lookupStandardMessage("DBClosedOrCollectionDeleted"), e);
        }
    }

    @Deprecated
    public void delete(@NonNull Document document) throws CouchbaseLiteException {
        this.delete(document, ConcurrencyControl.LAST_WRITE_WINS);
    }

    @Deprecated
    public boolean delete(@NonNull Document document, @NonNull ConcurrencyControl concurrencyControl) throws CouchbaseLiteException {
        return this.getDefaultCollectionOrThrow().delete(document, concurrencyControl);
    }

    @Deprecated
    public void purge(@NonNull Document document) throws CouchbaseLiteException {
        this.getDefaultCollectionOrThrow().purge(document);
    }

    @Deprecated
    public void purge(@NonNull String id) throws CouchbaseLiteException {
        this.getDefaultCollectionOrThrow().purge(id);
    }

    @Deprecated
    public void setDocumentExpiration(@NonNull String id, @Nullable Date expiration) throws CouchbaseLiteException {
        this.getDefaultCollectionOrThrow().setDocumentExpiration(id, expiration);
    }

    @Deprecated
    @Nullable
    public Date getDocumentExpiration(@NonNull String id) throws CouchbaseLiteException {
        return this.getDefaultCollectionOrThrow().getDocumentExpiration(id);
    }

    @Override
    @Deprecated
    @NonNull
    public ListenerToken addChangeListener(@NonNull DatabaseChangeListener listener) {
        return this.addChangeListener((Executor)null, listener);
    }

    @Override
    @Deprecated
    @NonNull
    public ListenerToken addChangeListener(@Nullable Executor executor, @NonNull DatabaseChangeListener listener) {
        return this.getDefaultCollectionOrThrow().addChangeListener(executor, listener::changed);
    }

    @Deprecated
    @NonNull
    public ListenerToken addDocumentChangeListener(@NonNull String docId, @NonNull DocumentChangeListener listener) {
        return this.addDocumentChangeListener(docId, null, listener);
    }

    @Deprecated
    @NonNull
    public ListenerToken addDocumentChangeListener(@NonNull String docId, @Nullable Executor executor, @NonNull DocumentChangeListener listener) {
        return this.getDefaultCollectionOrThrow().addDocumentChangeListener(docId, executor, listener);
    }

    @Deprecated
    public void removeChangeListener(@NonNull ListenerToken token) {
        Preconditions.assertNotNull(token, "token");
        if (!(token instanceof ChangeListenerToken)) {
            return;
        }
        Collection defaultCollection = this.getDefaultCollectionOrThrow();
        String docId = ((ChangeListenerToken)token).getKey();
        if (docId == null) {
            defaultCollection.removeCollectionChangeListener(token);
        } else {
            defaultCollection.removeDocumentChangeListener(token);
        }
    }

    @Deprecated
    @NonNull
    public List<String> getIndexes() throws CouchbaseLiteException {
        return new ArrayList<String>(this.getDefaultCollectionOrThrow().getIndexes());
    }

    @Deprecated
    public void createIndex(@NonNull String name, @NonNull Index index) throws CouchbaseLiteException {
        this.getDefaultCollectionOrThrow().createIndexInternal(name, index);
    }

    @Deprecated
    public void createIndex(@NonNull String name, @NonNull IndexConfiguration config) throws CouchbaseLiteException {
        this.getDefaultCollectionOrThrow().createIndexInternal(name, config);
    }

    @Deprecated
    public void deleteIndex(@NonNull String name) throws CouchbaseLiteException {
        this.getDefaultCollectionOrThrow().deleteIndex(name);
    }

    @NonNull
    protected abstract Database getDatabase();

    protected void finalize() throws Throwable {
        try {
            this.shutdownActiveProcesses(this.activeProcesses);
            this.shutdownExecutors(this.postExecutor, this.queryExecutor, 0);
        }
        finally {
            super.finalize();
        }
    }

    @NonNull
    Database copy() throws CouchbaseLiteException {
        return new Database(this.name, this.config);
    }

    @Nullable
    File getFilePath() {
        String path = this.getPath();
        return path == null ? null : new File(path);
    }

    @Nullable
    File getDbFile() {
        String path = this.getDbPath();
        return path == null ? null : new File(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String getUuid() {
        byte[] uuid = null;
        LiteCoreException err = null;
        Object object = this.getDbLock();
        synchronized (object) {
            if (!this.isOpenLocked()) {
                return null;
            }
            try {
                uuid = this.getOpenC4DbLocked().getPublicUUID();
            }
            catch (LiteCoreException e) {
                err = e;
            }
        }
        if (err != null) {
            com.couchbase.lite.internal.logging.Log.w(DOMAIN, "Failed retrieving database UUID", err);
        }
        return uuid == null ? null : PlatformUtils.getEncoder().encodeToString(uuid);
    }

    @NonNull
    FLSharedKeys getSharedKeys() {
        return this.sharedKeys;
    }

    void verifyCollections(@NonNull Set<Collection> collections) {
        for (Collection collection : collections) {
            if (collection == null) {
                throw new IllegalArgumentException("Collection may not be null");
            }
            if (this.equals(collection.getDatabase())) continue;
            throw new IllegalArgumentException("Collection " + collection + " does not belong to database " + this.getName());
        }
    }

    @NonNull
    Set<Collection> getDefaultCollectionAsSet() {
        Collection defaultCollection;
        try {
            defaultCollection = Collection.getDefaultCollection(this.getDatabase());
        }
        catch (CouchbaseLiteException e) {
            throw new CouchbaseLiteError("Can't get default collection", e);
        }
        HashSet<Collection> collections = new HashSet<Collection>();
        collections.add(defaultCollection);
        return collections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Collection addC4Collection(@NonNull String scopeName, @NonNull String collectionName) throws LiteCoreException {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().addCollection(scopeName, collectionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    C4Collection getC4Collection(@NonNull String scopeName, @NonNull String collectionName) throws LiteCoreException {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().getCollection(scopeName, collectionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Collection getDefaultC4Collection() throws LiteCoreException {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().getDefaultCollection();
        }
    }

    @GuardedBy(value="getDbLock()")
    void beginTransaction() throws CouchbaseLiteException {
        try {
            this.getOpenC4DbLocked().beginTransaction();
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    @GuardedBy(value="getDbLock()")
    void endTransaction(boolean commit) throws CouchbaseLiteException {
        try {
            this.getOpenC4DbLocked().endTransaction(commit);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Replicator createRemoteReplicator(@NonNull Map<Collection, CollectionConfiguration> collections, @Nullable String scheme, @Nullable String host, int port, @Nullable String path, @Nullable String remoteDbName, @NonNull MessageFraming framing, @NonNull ReplicatorType type, boolean continuous, @Nullable Map<String, Object> options, @NonNull C4Replicator.StatusListener statusListener, @NonNull C4Replicator.DocEndsListener docEndsListener, @NonNull Replicator replicator, @Nullable SocketFactory socketFactory) throws LiteCoreException {
        C4Replicator c4Repl;
        Object object = this.getDbLock();
        synchronized (object) {
            c4Repl = this.getOpenC4DbLocked().createRemoteReplicator(collections, scheme, host, port, path, remoteDbName, framing, type, continuous, options, statusListener, docEndsListener, replicator, socketFactory);
        }
        return c4Repl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Replicator createLocalReplicator(@NonNull Map<Collection, CollectionConfiguration> collections, @NonNull Database targetDb, @NonNull ReplicatorType type, boolean continuous, @Nullable Map<String, Object> options, @NonNull C4Replicator.StatusListener statusListener, @NonNull C4Replicator.DocEndsListener docEndsListener, @NonNull Replicator replicator) throws LiteCoreException {
        C4Replicator c4Repl;
        Object object = this.getDbLock();
        synchronized (object) {
            c4Repl = this.getOpenC4DbLocked().createLocalReplicator(collections, targetDb.getOpenC4DbLocked(), type, continuous, options, statusListener, docEndsListener, replicator);
        }
        return c4Repl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Replicator createMessageEndpointReplicator(@NonNull Set<Collection> collections, @NonNull C4Socket c4Socket, @Nullable Map<String, Object> options, @NonNull C4Replicator.StatusListener listener) throws LiteCoreException {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().createMessageEndpointReplicator(collections, c4Socket, options, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActiveReplicator(final @NonNull AbstractReplicator replicator) {
        Object object = this.getDbLock();
        synchronized (object) {
            this.assertOpenUnchecked();
            this.registerProcess(new ActiveProcess<AbstractReplicator>(replicator){

                @Override
                public void stop() {
                    replicator.stop();
                }

                @Override
                public boolean isActive() {
                    return !ReplicatorActivityLevel.STOPPED.equals((Object)replicator.getState());
                }
            });
        }
    }

    void removeActiveReplicator(@NonNull AbstractReplicator replicator) {
        this.unregisterProcess(replicator);
    }

    void resolveReplicationConflict(@Nullable ConflictResolver resolver, @NonNull ReplicatedDocument rDoc, @NonNull Fn.NullableConsumer<CouchbaseLiteException> callback) {
        int n = 0;
        CouchbaseLiteException err = null;
        try {
            while (true) {
                if (n++ > 13) {
                    err = new CouchbaseLiteException("Too many attempts to resolve a conflicted document(" + n + "): " + rDoc, "CouchbaseLite", 10);
                    break;
                }
                String scope = rDoc.getScope();
                String name = rDoc.getCollection();
                try {
                    Collection collection = Collection.getCollection(this.getDatabase(), scope, name);
                    if (collection != null) {
                        this.resolveConflictOnce(resolver, collection, rDoc.getID());
                        callback.accept(null);
                        return;
                    }
                    err = new CouchbaseLiteException("Cannot find collection " + this.getName() + "." + scope + "." + name, "CouchbaseLite", 10);
                }
                catch (CouchbaseLiteException e) {
                    if (CouchbaseLiteException.isConflict(e)) continue;
                    err = e;
                }
                catch (ConflictResolutionException e) {
                    com.couchbase.lite.internal.logging.Log.w(DOMAIN, "Conflict already resolved: %s", e.getMessage());
                }
                break;
            }
        }
        catch (RuntimeException e) {
            String msg = e.getMessage();
            err = new CouchbaseLiteException(msg != null ? msg : "Conflict resolution failed", e, "CouchbaseLite", 10);
        }
        callback.accept(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCookies(@NonNull URI uri, @NonNull List<String> cookies, boolean acceptParentDomain) {
        try {
            Object object = this.getDbLock();
            synchronized (object) {
                C4Database c4db = this.getOpenC4DbLocked();
                for (String cookie : cookies) {
                    c4db.setCookie(uri, cookie, acceptParentDomain);
                }
            }
        }
        catch (LiteCoreException e) {
            com.couchbase.lite.internal.logging.Log.w(DOMAIN, "Cannot save cookies for " + uri, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String getCookies(@NonNull URI uri) {
        try {
            Object object = this.getDbLock();
            synchronized (object) {
                return this.getOpenC4DbLocked().getCookies(uri);
            }
        }
        catch (LiteCoreException e) {
            com.couchbase.lite.internal.logging.Log.w(DOMAIN, "Cannot get cookies for " + uri, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerProcess(@NonNull ActiveProcess<?> process) {
        Set<ActiveProcess<?>> set = this.activeProcesses;
        synchronized (set) {
            this.activeProcesses.add(process);
        }
        com.couchbase.lite.internal.logging.Log.d(DOMAIN, "Added active process(%s): %s", this.getName(), process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void unregisterProcess(T process) {
        Set<ActiveProcess<?>> set = this.activeProcesses;
        synchronized (set) {
            this.activeProcesses.remove(new ActiveProcess<T>(process));
        }
        com.couchbase.lite.internal.logging.Log.d(DOMAIN, "Removed active process(%s): %s", this.getName(), process);
        this.verifyActiveProcesses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Query createJsonQuery(@NonNull String json) throws LiteCoreException {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().createJsonQuery(json);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Query createN1qlQuery(@NonNull String n1ql) throws LiteCoreException {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().createN1qlQuery(n1ql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    FLEncoder getSharedFleeceEncoder() {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().getSharedFleeceEncoder();
        }
    }

    abstract int getEncryptionAlgorithm();

    @Nullable
    abstract byte[] getEncryptionKey();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private Collection getDefaultCollectionOrThrow() {
        try {
            Object object = this.getDbLock();
            synchronized (object) {
                this.assertOpenUnchecked();
                return this.getDefaultCollectionLocked();
            }
        }
        catch (CouchbaseLiteException e) {
            throw new CouchbaseLiteError(com.couchbase.lite.internal.logging.Log.lookupStandardMessage("DBClosedOrCollectionDeleted"), e);
        }
    }

    @NonNull
    private Collection getDefaultCollectionLocked() throws CouchbaseLiteException {
        if (this.defaultCollection == null) {
            this.defaultCollection = Collection.getDefaultCollection(this.getDatabase());
        } else if (!this.defaultCollection.isValid()) {
            throw new CouchbaseLiteException("Database " + this.getName() + " default collection is invalid");
        }
        return this.defaultCollection;
    }

    @NonNull
    private C4Database openC4Db() throws CouchbaseLiteException {
        String parentDirPath = this.config.getDirectory();
        com.couchbase.lite.internal.logging.Log.d(DOMAIN, "Opening db %s at path %s", this, parentDirPath);
        try {
            return C4Database.getDatabase(parentDirPath, this.name, this.config.isFullSync(), this.config.isMMapEnabled(), this.getEncryptionAlgorithm(), this.getEncryptionKey());
        }
        catch (LiteCoreException e) {
            if (e.code == 20) {
                throw new CouchbaseLiteException("The provided encryption key was incorrect.", e, "CouchbaseLite", e.code);
            }
            if (e.code == 11) {
                throw new CouchbaseLiteException("CreateDBDirectoryFailed", e, "CouchbaseLite", e.code);
            }
            throw CouchbaseLiteException.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveConflictOnce(@Nullable ConflictResolver resolver, @NonNull Collection collection, @NonNull String docID) throws CouchbaseLiteException, ConflictResolutionException {
        Document remoteDoc;
        Document localDoc;
        Object object = this.getDbLock();
        synchronized (object) {
            localDoc = Document.getDocumentWithDeleted(collection, docID);
            remoteDoc = this.getConflictingRevision(collection, docID);
        }
        Document resolvedDoc = localDoc.isDeleted() && remoteDoc.isDeleted() ? remoteDoc : this.resolveConflict(resolver != null ? resolver : ConflictResolver.DEFAULT, docID, localDoc, remoteDoc);
        Object object2 = this.getDbLock();
        synchronized (object2) {
            boolean commit = false;
            this.beginTransaction();
            try {
                this.saveResolvedDocument(resolvedDoc, localDoc, remoteDoc);
                commit = true;
            }
            finally {
                this.endTransaction(commit);
            }
        }
    }

    @NonNull
    private Document getConflictingRevision(@NonNull Collection collection, @NonNull String docID) throws CouchbaseLiteException, ConflictResolutionException {
        Document remoteDoc = Document.getDocumentWithRevisions(collection, docID);
        try {
            if (!remoteDoc.selectConflictingRevision()) {
                throw new ConflictResolutionException("Unable to select conflicting revision for doc '" + docID + "'. Skipping.");
            }
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
        return remoteDoc;
    }

    @Nullable
    private Document resolveConflict(@NonNull ConflictResolver resolver, @NonNull String docID, @NonNull Document localDoc, @NonNull Document remoteDoc) throws CouchbaseLiteException {
        com.couchbase.lite.internal.logging.Log.d(DOMAIN, "Resolving doc '%s' (local=%s and remote=%s) with resolver %s", docID, localDoc.getRevisionID(), remoteDoc.getRevisionID(), resolver);
        Collection localCollection = localDoc.getCollection();
        if (localCollection == null) {
            throw new CouchbaseLiteError("Local doc does not belong to any collection: " + docID);
        }
        Document resolvedDoc = this.runClientResolver(resolver, docID, localDoc, remoteDoc);
        if (resolvedDoc == null) {
            return null;
        }
        Collection targetCollection = resolvedDoc.getCollection();
        if (targetCollection == null) {
            targetCollection = localCollection;
            resolvedDoc.setCollection(targetCollection);
        }
        if (!localCollection.equals(targetCollection)) {
            String msg = String.format(WARN_WRONG_COLLECTION, docID, targetCollection, localCollection);
            com.couchbase.lite.internal.logging.Log.w(DOMAIN, msg);
            throw new CouchbaseLiteException(msg, "CouchbaseLite", 10);
        }
        if (!docID.equals(resolvedDoc.getId())) {
            com.couchbase.lite.internal.logging.Log.w(DOMAIN, WARN_WRONG_ID, resolvedDoc.getId(), docID);
            return new MutableDocument(docID, resolvedDoc);
        }
        return resolvedDoc;
    }

    @Nullable
    private Document runClientResolver(@NonNull ConflictResolver resolver, @NonNull String docID, @NonNull Document localDoc, @NonNull Document remoteDoc) throws CouchbaseLiteException {
        Conflict conflict = new Conflict(localDoc.isDeleted() ? null : localDoc, remoteDoc.isDeleted() ? null : remoteDoc);
        ClientTask<Document> task = new ClientTask<Document>(() -> resolver.resolve(conflict));
        task.execute();
        Exception err = task.getFailure();
        if (err != null) {
            String msg = String.format(ERROR_RESOLVER_FAILED, docID, err.getLocalizedMessage());
            com.couchbase.lite.internal.logging.Log.w(DOMAIN, msg, err);
            throw new CouchbaseLiteException(msg, err, "CouchbaseLite", 10);
        }
        return task.getResult();
    }

    @GuardedBy(value="getDbLock()")
    private void saveResolvedDocument(@Nullable Document resolvedDoc, @NonNull Document localDoc, @NonNull Document remoteDoc) throws CouchbaseLiteException {
        C4Document c4Doc;
        if (resolvedDoc == null) {
            if (remoteDoc.isDeleted()) {
                resolvedDoc = remoteDoc;
            } else if (localDoc.isDeleted()) {
                resolvedDoc = localDoc;
            }
        }
        int mergedFlags = 0;
        if (resolvedDoc != null && (c4Doc = resolvedDoc.getC4doc()) != null) {
            mergedFlags = c4Doc.getSelectedFlags();
        }
        try {
            this.saveResolvedDocumentWithFlags(resolvedDoc, localDoc, remoteDoc, mergedFlags);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    @GuardedBy(value="getDbLock()")
    private void saveResolvedDocumentWithFlags(@Nullable Document resolvedDoc, @NonNull Document localDoc, @NonNull Document remoteDoc, int mergedFlags) throws LiteCoreException {
        byte[] mergedBodyBytes = null;
        if (resolvedDoc != remoteDoc) {
            if (resolvedDoc == null || resolvedDoc.isDeleted()) {
                mergedFlags |= 1;
                try (FLEncoder enc = this.getSharedFleeceEncoder();){
                    enc.writeValue(Collections.emptyMap());
                    mergedBodyBytes = enc.finish();
                }
            }
            try (FLSliceResult mergedBody = resolvedDoc.encode();){
                if (C4Document.dictContainsBlobs(mergedBody, this.sharedKeys)) {
                    mergedFlags |= 8;
                }
                mergedBodyBytes = mergedBody.getContent();
            }
        }
        C4Document rawDoc = Preconditions.assertNotNull(localDoc.getC4doc(), "raw doc is null");
        rawDoc.resolveConflict(remoteDoc.getRevisionID(), localDoc.getRevisionID(), mergedBodyBytes, mergedFlags);
        rawDoc.save(0);
        com.couchbase.lite.internal.logging.Log.d(DOMAIN, "Conflict resolved as doc '%s' rev %s", localDoc.getId(), rawDoc.getRevID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyActiveProcesses() {
        Set<ActiveProcess<?>> set;
        HashSet processes;
        Set<ActiveProcess<?>> set2 = this.activeProcesses;
        synchronized (set2) {
            processes = new HashSet(this.activeProcesses);
        }
        HashSet<ActiveProcess> deadProcesses = new HashSet<ActiveProcess>();
        for (ActiveProcess activeProcess : processes) {
            if (activeProcess.isActive()) continue;
            com.couchbase.lite.internal.logging.Log.i(DOMAIN, "Found dead db process: " + activeProcess);
            deadProcesses.add(activeProcess);
        }
        if (!deadProcesses.isEmpty()) {
            set = this.activeProcesses;
            synchronized (set) {
                this.activeProcesses.removeAll(deadProcesses);
            }
        }
        if (this.closeLatch == null) {
            return;
        }
        set = this.activeProcesses;
        synchronized (set) {
            processes = new HashSet(this.activeProcesses);
        }
        int n = processes.size();
        com.couchbase.lite.internal.logging.Log.d(DOMAIN, "Active processes %s: %d", this.getName(), n);
        if (n <= 0) {
            this.closeLatch.countDown();
            return;
        }
        for (ActiveProcess activeProcess : processes) {
            com.couchbase.lite.internal.logging.Log.d(DOMAIN, " processes: %s", activeProcess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean failIfClosed, Fn.ConsumerThrows<C4Database, LiteCoreException> onShut) throws CouchbaseLiteException {
        C4Database c4Db;
        Object object = this.getDbLock();
        synchronized (object) {
            boolean open = this.isOpenLocked();
            com.couchbase.lite.internal.logging.Log.d(DOMAIN, "Shutdown (%b, %b)", failIfClosed, open);
            if (!failIfClosed && !open) {
                return;
            }
            c4Db = this.getOpenC4DbLocked();
            this.setC4DatabaseLocked(null);
            this.closeLatch = new CountDownLatch(1);
            HashSet liveProcesses = null;
            Set<ActiveProcess<?>> set = this.activeProcesses;
            synchronized (set) {
                if (!this.activeProcesses.isEmpty()) {
                    liveProcesses = new HashSet(this.activeProcesses);
                }
            }
            this.shutdownActiveProcesses(liveProcesses);
        }
        try {
            int i = 0;
            while (true) {
                this.verifyActiveProcesses();
                if (i >= 5 && this.closeLatch.getCount() > 0L) {
                    throw new CouchbaseLiteException("Shutdown failed", "CouchbaseLite", 16);
                }
                if (!this.closeLatch.await(6L, TimeUnit.SECONDS)) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Object object2 = this.getDbLock();
        synchronized (object2) {
            try {
                onShut.accept(c4Db);
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
        this.shutdownExecutors(this.postExecutor, this.queryExecutor, 5);
    }

    private void shutdownActiveProcesses(java.util.Collection<ActiveProcess<?>> processes) {
        if (processes == null) {
            return;
        }
        for (ActiveProcess<?> process : processes) {
            process.stop();
        }
    }

    private void shutdownExecutors(ExecutionService.CloseableExecutor pExec, ExecutionService.CloseableExecutor qExec, int waitTime) {
        if (pExec != null) {
            pExec.stop(waitTime, TimeUnit.SECONDS);
        }
        if (qExec != null) {
            qExec.stop(waitTime, TimeUnit.SECONDS);
        }
    }

    private void fixHydrogenBug(@NonNull ImmutableDatabaseConfiguration config, @NonNull String dbName) throws CouchbaseLiteException {
        String defaultDirPath = CouchbaseLiteInternal.getDefaultDbDir().getAbsolutePath();
        if (!defaultDirPath.equals(config.getDirectory())) {
            return;
        }
        File defaultDir = new File(defaultDirPath);
        File twoDotEightDefaultDir = new File(defaultDir, ".couchbase");
        if (!AbstractDatabase.exists(dbName, twoDotEightDefaultDir)) {
            return;
        }
        if (AbstractDatabase.exists(dbName, defaultDir)) {
            return;
        }
        File twoDotEightDb = C4Database.getDatabaseFile(twoDotEightDefaultDir, dbName);
        try {
            Database.copy(twoDotEightDb, dbName, config);
        }
        catch (CouchbaseLiteException e) {
            try {
                FileUtils.eraseFileOrDir(C4Database.getDatabaseFile(defaultDir, dbName));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    static class ActiveProcess<T> {
        @NonNull
        private final T process;

        ActiveProcess(@NonNull T process) {
            this.process = process;
        }

        public boolean isActive() {
            return true;
        }

        public void stop() {
        }

        @NonNull
        public String toString() {
            return this.process.toString();
        }

        public int hashCode() {
            return this.process.hashCode();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ActiveProcess)) {
                return false;
            }
            ActiveProcess other = (ActiveProcess)o;
            return this.process.equals(other.process);
        }
    }
}

