/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.DatabaseConfiguration;
import com.couchbase.lite.internal.BaseImmutableDatabaseConfiguration;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.utils.FileUtils;
import com.couchbase.lite.internal.utils.Preconditions;

abstract class AbstractDatabaseConfiguration {
    private String dbDirectory;
    private boolean fullSync;
    private boolean mmapEnabled;

    protected AbstractDatabaseConfiguration() {
        this(null, false, true);
    }

    protected AbstractDatabaseConfiguration(@Nullable AbstractDatabaseConfiguration config) {
        this(config == null ? null : config.getDirectory(), config == null ? false : config.isFullSync(), config == null ? true : config.isMMapEnabled());
    }

    protected AbstractDatabaseConfiguration(@NonNull BaseImmutableDatabaseConfiguration config) {
        this(config.getDirectory(), config.isFullSync(), config.isMMapEnabled());
    }

    private AbstractDatabaseConfiguration(@Nullable String dbDir, boolean fullSync, boolean mmapEnabled) {
        CouchbaseLiteInternal.requireInit("Cannot create database configuration");
        this.dbDirectory = dbDir != null ? dbDir : CouchbaseLiteInternal.getDefaultDbDirPath();
        this.fullSync = fullSync;
        this.mmapEnabled = mmapEnabled;
    }

    @NonNull
    public DatabaseConfiguration setDirectory(@NonNull String directory) {
        Preconditions.assertNotNull(directory, "directory");
        this.dbDirectory = FileUtils.verifyDir(directory).getAbsolutePath();
        return this.getDatabaseConfiguration();
    }

    @NonNull
    public String getDirectory() {
        return this.dbDirectory;
    }

    @NonNull
    public DatabaseConfiguration setFullSync(boolean isFullSync) {
        this.fullSync = isFullSync;
        return this.getDatabaseConfiguration();
    }

    public boolean isFullSync() {
        return this.fullSync;
    }

    @NonNull
    public DatabaseConfiguration setMMapEnabled(boolean mmapEnabled) {
        this.mmapEnabled = mmapEnabled;
        return this.getDatabaseConfiguration();
    }

    public boolean isMMapEnabled() {
        return this.mmapEnabled;
    }

    @NonNull
    protected abstract DatabaseConfiguration getDatabaseConfiguration();
}

