/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.Collection;
import com.couchbase.lite.ConflictResolver;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.DocumentReplication;
import com.couchbase.lite.DocumentReplicationListener;
import com.couchbase.lite.DocumentReplicationListenerToken;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.ReplicatedDocument;
import com.couchbase.lite.Replicator;
import com.couchbase.lite.ReplicatorActivityLevel;
import com.couchbase.lite.ReplicatorChange;
import com.couchbase.lite.ReplicatorChangeListener;
import com.couchbase.lite.ReplicatorChangeListenerToken;
import com.couchbase.lite.ReplicatorConfiguration;
import com.couchbase.lite.ReplicatorStatus;
import com.couchbase.lite.ReplicatorType;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.ImmutableReplicatorConfiguration;
import com.couchbase.lite.internal.ReplicationCollection;
import com.couchbase.lite.internal.SocketFactory;
import com.couchbase.lite.internal.core.C4DocumentEnded;
import com.couchbase.lite.internal.core.C4Replicator;
import com.couchbase.lite.internal.core.C4ReplicatorStatus;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.listener.Listenable;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.replicator.BaseReplicator;
import com.couchbase.lite.internal.replicator.CBLCookieStore;
import com.couchbase.lite.internal.sockets.MessageFraming;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import com.couchbase.lite.internal.utils.StringUtils;
import java.net.URI;
import java.security.cert.Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractReplicator
extends BaseReplicator
implements Listenable<ReplicatorChange, ReplicatorChangeListener> {
    private static final LogDomain LOG_DOMAIN = LogDomain.REPLICATOR;
    @NonNull
    private final ImmutableReplicatorConfiguration config;
    @NonNull
    private final SocketFactory socketFactory;
    private final AtomicReference<List<Certificate>> serverCertificates = new AtomicReference();
    @NonNull
    @GuardedBy(value="getReplicatorLock()")
    private final Set<ReplicatorChangeListenerToken> changeListeners = new HashSet<ReplicatorChangeListenerToken>();
    @NonNull
    @GuardedBy(value="getReplicatorLock()")
    private final Set<DocumentReplicationListenerToken> docEndedListeners = new HashSet<DocumentReplicationListenerToken>();
    @NonNull
    @GuardedBy(value="getReplicatorLock()")
    private ReplicatorStatus status = ReplicatorStatus.INIT;
    @GuardedBy(value="getReplicatorLock()")
    private boolean closed;
    @GuardedBy(value="getReplicatorLock()")
    @Nullable
    private CouchbaseLiteException lastError;
    @GuardedBy(value="getReplicatorLock()")
    @NonNull
    private final Set<Fn.NullableConsumer<CouchbaseLiteException>> pendingResolutions = new HashSet<Fn.NullableConsumer<CouchbaseLiteException>>();
    @GuardedBy(value="getReplicatorLock()")
    @NonNull
    private final Deque<C4ReplicatorStatus> pendingStatusNotifications = new LinkedList<C4ReplicatorStatus>();
    private volatile String desc;

    static boolean isStopped(@NonNull C4ReplicatorStatus c4Status) {
        return c4Status.getActivityLevel() == 0;
    }

    static boolean isOffline(@NonNull C4ReplicatorStatus c4Status) {
        return c4Status.getActivityLevel() == 1;
    }

    protected AbstractReplicator(@NonNull ReplicatorConfiguration config) {
        Preconditions.assertNotNull(config, "config");
        this.config = new ImmutableReplicatorConfiguration(config);
        this.socketFactory = new SocketFactory(config, new ReplicatorCookieStore(this.getDatabase()), this::setServerCertificates);
    }

    public void start() {
        this.start(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean resetCheckpoint) {
        C4Replicator c4Repl;
        Log.i(LOG_DOMAIN, "Replicator(%s) starting: %s", this.getId(), this);
        this.getDatabase().addActiveReplicator(this);
        try {
            c4Repl = this.getOrCreateC4Replicator();
        }
        catch (LiteCoreException e) {
            throw new CouchbaseLiteError("Failed to create replicator", e);
        }
        Object object = this.getReplicatorLock();
        synchronized (object) {
            c4Repl.start(resetCheckpoint);
            C4ReplicatorStatus status = c4Repl.getStatus();
            if (status == null) {
                status = new C4ReplicatorStatus(0, 1, 10);
            }
            status = this.updateStatus(status);
            this.dispatchStatusChange(c4Repl, status);
        }
        Log.d(LOG_DOMAIN, "Replicator(%s) started: %s", this.getId(), this);
    }

    public void stop() {
        C4Replicator c4repl = this.getC4Replicator();
        Log.i(LOG_DOMAIN, "Replicator(%s) stopped: %s", this.getId(), this);
        if (c4repl == null) {
            return;
        }
        c4repl.stop();
    }

    @NonNull
    public ReplicatorConfiguration getConfig() {
        return new ReplicatorConfiguration(this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ReplicatorStatus getStatus() {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            return new ReplicatorStatus(this.status);
        }
    }

    @Nullable
    public List<Certificate> getServerCertificates() {
        List<Certificate> serverCerts = this.serverCertificates.get();
        return serverCerts == null || serverCerts.isEmpty() ? null : new ArrayList<Certificate>(serverCerts);
    }

    @Deprecated
    @NonNull
    public Set<String> getPendingDocumentIds() throws CouchbaseLiteException {
        return this.getPendingDocIds("_default", "_default");
    }

    @NonNull
    public Set<String> getPendingDocumentIds(@NonNull Collection collection) throws CouchbaseLiteException {
        return this.getPendingDocIds(collection.getScope().getName(), collection.getName());
    }

    @Deprecated
    public boolean isDocumentPending(@NonNull String docId) throws CouchbaseLiteException {
        return this.isDocPending(docId, "_default", "_default");
    }

    public boolean isDocumentPending(@NonNull String docId, @NonNull Collection collection) throws CouchbaseLiteException {
        return this.isDocPending(docId, collection.getScope().getName(), collection.getName());
    }

    @Override
    @NonNull
    public ListenerToken addChangeListener(@NonNull ReplicatorChangeListener listener) {
        Preconditions.assertNotNull(listener, "listener");
        return this.addChangeListener((Executor)null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenerToken addChangeListener(@Nullable Executor executor, @NonNull ReplicatorChangeListener listener) {
        Preconditions.assertNotNull(listener, "listener");
        ReplicatorChangeListenerToken token = new ReplicatorChangeListenerToken(executor, listener, this::removeReplicationListener);
        Object object = this.getReplicatorLock();
        synchronized (object) {
            this.changeListeners.add(token);
        }
        return token;
    }

    @NonNull
    public ListenerToken addDocumentReplicationListener(@NonNull DocumentReplicationListener listener) {
        Preconditions.assertNotNull(listener, "listener");
        return this.addDocumentReplicationListener(null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenerToken addDocumentReplicationListener(@Nullable Executor executor, @NonNull DocumentReplicationListener listener) {
        Preconditions.assertNotNull(listener, "listener");
        DocumentReplicationListenerToken token = new DocumentReplicationListenerToken(executor, listener, this::removeDocumentReplicationListener);
        Object object = this.getReplicatorLock();
        synchronized (object) {
            this.docEndedListeners.add(token);
            this.setProgressLevel();
        }
        return token;
    }

    @Deprecated
    public void removeChangeListener(@NonNull ListenerToken token) {
        Preconditions.assertNotNull(token, "token");
        Object object = this.getReplicatorLock();
        synchronized (object) {
            if (token instanceof ReplicatorChangeListenerToken) {
                this.removeReplicationListener(token);
                return;
            }
            if (token instanceof DocumentReplicationListenerToken) {
                this.removeDocumentReplicationListener(token);
                return;
            }
            throw new IllegalArgumentException("unexpected token: " + token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashSet<ReplicatorChangeListenerToken> listeners = null;
        ReplicatorStatus newStatus = null;
        Object object = this.getReplicatorLock();
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.status.getActivityLevel() != ReplicatorActivityLevel.STOPPED) {
                listeners = new HashSet<ReplicatorChangeListenerToken>(this.changeListeners);
                this.status = newStatus = new ReplicatorStatus(ReplicatorActivityLevel.STOPPED, this.status.getProgress(), null);
            }
        }
        this.closeC4Replicator();
        Log.i(LOG_DOMAIN, "Replicator(%s) closed: %s", this.getId(), this);
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        this.postChange(true, new ReplicatorChange((Replicator)this, newStatus), listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            return this.closed;
        }
    }

    @NonNull
    public String toString() {
        if (this.desc == null) {
            this.desc = this.description();
        }
        return this.desc + " $" + this.getC4Replicator();
    }

    @GuardedBy(value="getDbLock()")
    @NonNull
    protected abstract C4Replicator createReplicatorForTarget(@NonNull Endpoint var1) throws LiteCoreException;

    protected abstract void handleOffline(@NonNull ReplicatorActivityLevel var1, boolean var2);

    @GuardedBy(value="getDbLock()")
    @NonNull
    protected final C4Replicator getLocalC4Replicator(@NonNull Database targetDb) throws LiteCoreException {
        return this.getDatabase().createLocalReplicator(this.config.getCollectionConfigs(), targetDb, this.config.getType(), this.config.isContinuous(), this.config.getConnectionOptions(), this::dispatchStatusChange, this::dispatchDocumentsEnded, (Replicator)this);
    }

    @GuardedBy(value="getDbLock()")
    @NonNull
    protected final C4Replicator getRemoteC4Replicator(@NonNull URI remoteUri) throws LiteCoreException {
        int p = remoteUri.getPort();
        int port = Math.max(0, p);
        Deque<String> splitPath = this.splitPath(remoteUri.getPath());
        String dbName = splitPath.size() <= 0 ? "" : splitPath.removeLast();
        String path = "/" + StringUtils.join("/", splitPath);
        return this.getDatabase().createRemoteReplicator(this.config.getCollectionConfigs(), remoteUri.getScheme(), remoteUri.getHost(), port, path, dbName, MessageFraming.NO_FRAMING, this.config.getType(), this.config.isContinuous(), this.config.getConnectionOptions(), this::dispatchStatusChange, this::dispatchDocumentsEnded, (Replicator)this, this.socketFactory);
    }

    @GuardedBy(value="getDbLock()")
    @NonNull
    protected final C4Replicator getMessageC4Replicator(@NonNull MessageFraming framing) throws LiteCoreException {
        return this.getDatabase().createRemoteReplicator(this.config.getCollectionConfigs(), "x-msg-endpt", null, 0, null, null, framing, this.config.getType(), this.config.isContinuous(), this.config.getConnectionOptions(), this::dispatchStatusChange, this::dispatchDocumentsEnded, (Replicator)this, this.socketFactory);
    }

    void dispatchStatusChange(@NonNull C4Replicator ignored, @NonNull C4ReplicatorStatus status) {
        this.dispatcher.execute(() -> this.statusChanged(status));
    }

    void dispatchDocumentsEnded(@NonNull List<C4DocumentEnded> docEnds, boolean pushing) {
        this.dispatcher.execute(() -> this.documentsEnded(docEnds, pushing));
    }

    @Nullable
    @VisibleForTesting
    CouchbaseLiteException getLastError() {
        return this.lastError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    ReplicatorActivityLevel getState() {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            return this.status.getActivityLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConflictResolved(Fn.NullableConsumer<CouchbaseLiteException> task, @NonNull ReplicatedDocument rDoc) {
        Log.i(LOG_DOMAIN, "%s: conflict resolved: %s", rDoc.getError(), this.getId(), rDoc.getID());
        ArrayList<C4ReplicatorStatus> pendingNotifications = null;
        Iterator iterator = this.getReplicatorLock();
        synchronized (iterator) {
            this.pendingResolutions.remove(task);
            if (this.pendingResolutions.isEmpty()) {
                pendingNotifications = new ArrayList<C4ReplicatorStatus>(this.pendingStatusNotifications);
                this.pendingStatusNotifications.clear();
            }
        }
        this.notifyDocumentEnded(false, Arrays.asList(rDoc));
        if (pendingNotifications != null && !pendingNotifications.isEmpty()) {
            for (C4ReplicatorStatus status : pendingNotifications) {
                this.dispatcher.execute(() -> this.statusChanged(status));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDocumentEnded(boolean pushing, List<ReplicatedDocument> docs) {
        HashSet<DocumentReplicationListenerToken> listenerTokens;
        DocumentReplication update = new DocumentReplication((Replicator)this, pushing, docs);
        Log.i(LOG_DOMAIN, "%s: document end notification: %s", this.getId(), update);
        Iterator iterator = this.getReplicatorLock();
        synchronized (iterator) {
            listenerTokens = new HashSet<DocumentReplicationListenerToken>(this.docEndedListeners);
        }
        for (DocumentReplicationListenerToken token : listenerTokens) {
            token.postChange(update);
        }
    }

    @NonNull
    @VisibleForTesting
    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getListenerCount() {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            return this.changeListeners.size() + this.docEndedListeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getDocEndListenerCount() {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            return this.docEndedListeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getReplicatorListenerCount() {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            return this.changeListeners.size();
        }
    }

    @VisibleForTesting
    void runTaskConcurrently(@NonNull Runnable task) {
        CouchbaseLiteInternal.getExecutionService().getConcurrentExecutor().execute(task);
    }

    @NonNull
    private Set<String> getPendingDocIds(@NonNull String scope, @NonNull String coll) throws CouchbaseLiteException {
        Set<String> pending;
        if (this.config.getType().equals((Object)ReplicatorType.PULL)) {
            throw new CouchbaseLiteException("PullOnlyPendingDocIDs", "CouchbaseLite", 19);
        }
        this.verifyCollection(scope, coll);
        try {
            pending = this.getOrCreateC4Replicator().getPendingDocIDs(scope, coll);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e, "Failed fetching pending documentIds");
        }
        return Collections.unmodifiableSet(pending);
    }

    private boolean isDocPending(@NonNull String docId, @NonNull String scope, @NonNull String coll) throws CouchbaseLiteException {
        Preconditions.assertNotNull(docId, "document ID");
        if (this.config.getType().equals((Object)ReplicatorType.PULL)) {
            throw new CouchbaseLiteException("PullOnlyPendingDocIDs", "CouchbaseLite", 19);
        }
        this.verifyCollection(scope, coll);
        try {
            return this.getOrCreateC4Replicator().isDocumentPending(docId, scope, coll);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e, "Failed getting document pending status");
        }
    }

    private void verifyCollection(String scope, String name) {
        if (null == Fn.firstOrNull(this.config.getCollectionConfigs().keySet(), coll -> scope.equals(coll.getScope().getName()) && name.equals(coll.getName()))) {
            throw new IllegalArgumentException("This replicator is not replicating the collection " + scope + "." + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private C4Replicator getOrCreateC4Replicator() throws LiteCoreException {
        Object object = this.getDatabase().getDbLock();
        synchronized (object) {
            if (this.closed) {
                throw new CouchbaseLiteError("Attempt to operate on a closed replicator");
            }
            C4Replicator c4Repl = this.getC4Replicator();
            Map<String, Object> options = this.config.getConnectionOptions();
            if (c4Repl != null) {
                c4Repl.setOptions(FLEncoder.encodeMap(options));
                Object object2 = this.getReplicatorLock();
                synchronized (object2) {
                    this.setProgressLevel();
                }
                return c4Repl;
            }
            c4Repl = this.createReplicatorForTarget(this.config.getTarget());
            Object object3 = this.getReplicatorLock();
            synchronized (object3) {
                this.setC4Replicator(c4Repl);
                this.setProgressLevel();
            }
            return c4Repl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statusChanged(@NonNull C4ReplicatorStatus c4Status) {
        HashSet<ReplicatorChangeListenerToken> listenerTokens;
        ReplicatorChange change;
        Object object = this.getReplicatorLock();
        synchronized (object) {
            Log.i(LOG_DOMAIN, "%s: status changed: (%d, %d) @%s", this.getId(), this.pendingResolutions.size(), this.pendingStatusNotifications.size(), c4Status);
            if (this.config.isContinuous()) {
                this.handleOffline(this.status.getActivityLevel(), !AbstractReplicator.isOffline(c4Status));
            }
            if (!this.pendingResolutions.isEmpty()) {
                this.pendingStatusNotifications.add(c4Status);
            }
            if (!this.pendingStatusNotifications.isEmpty()) {
                return;
            }
            this.updateStatus(c4Status);
            change = new ReplicatorChange((Replicator)this, this.getStatus());
            listenerTokens = new HashSet<ReplicatorChangeListenerToken>(this.changeListeners);
        }
        this.postChange(AbstractReplicator.isStopped(c4Status), change, listenerTokens);
    }

    private void postChange(boolean isStopped, ReplicatorChange change, Set<ReplicatorChangeListenerToken> listeners) {
        if (isStopped) {
            this.getDatabase().removeActiveReplicator(this);
        }
        Fn.forAll(listeners, token -> token.postChange(change));
    }

    private void documentsEnded(@NonNull List<C4DocumentEnded> docEnds, boolean pushing) {
        Log.i(LOG_DOMAIN, "%s: documents ended: %d", this.getId(), docEnds.size());
        ArrayList<ReplicatedDocument> unconflictedDocs = new ArrayList<ReplicatedDocument>();
        for (C4DocumentEnded docEnd : docEnds) {
            if (docEnd.docId == null) {
                Log.d(LOG_DOMAIN, "%s: DocId is null in document end: ", this.getId(), docEnd);
                continue;
            }
            ReplicationCollection coll = ReplicationCollection.getBinding(docEnd.token);
            if (coll == null) {
                Log.d(LOG_DOMAIN, "%s: No collection for document end: ", this.getId(), docEnd);
                continue;
            }
            int errCode = docEnd.getErrorCode();
            CouchbaseLiteException err = errCode == 0 ? null : CouchbaseLiteException.toCouchbaseLiteException(docEnd.getErrorDomain(), errCode, docEnd.getErrorInfo());
            ReplicatedDocument rDoc = new ReplicatedDocument(coll.scope, coll.name, docEnd.docId, docEnd.flags, err);
            if (pushing || !CouchbaseLiteException.isConflict(err)) {
                unconflictedDocs.add(rDoc);
                continue;
            }
            this.queueConflictResolution(rDoc, coll.getConflictResolver());
        }
        if (!unconflictedDocs.isEmpty()) {
            this.notifyDocumentEnded(pushing, unconflictedDocs);
        }
    }

    @NonNull
    @GuardedBy(value="getReplicatorLock()")
    private C4ReplicatorStatus updateStatus(@NonNull C4ReplicatorStatus c4Status) {
        ReplicatorStatus oldStatus = this.status;
        this.status = new ReplicatorStatus(c4Status);
        int errCode = c4Status.getErrorCode();
        if (errCode != 0) {
            this.lastError = this.status.getError();
        }
        Log.i(LOG_DOMAIN, "%s: state changed(%d): %s => %s(%d/%d)", new Object[]{this.getId(), errCode, oldStatus.getActivityLevel(), this.status.getActivityLevel(), c4Status.getProgressUnitsCompleted(), c4Status.getProgressUnitsTotal()});
        return new C4ReplicatorStatus(c4Status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueConflictResolution(final @NonNull ReplicatedDocument rDoc, @Nullable ConflictResolver resolver) {
        Database db = this.getDatabase();
        Log.i(LOG_DOMAIN, "%s: found conflicting version of '%s.%s.%s#%s'", this.getId(), db.getName(), rDoc.getScope(), rDoc.getCollection(), rDoc.getID());
        Fn.NullableConsumer<CouchbaseLiteException> continuation = new Fn.NullableConsumer<CouchbaseLiteException>(){

            @Override
            public void accept(CouchbaseLiteException err) {
                rDoc.setError(err);
                AbstractReplicator.this.onConflictResolved(this, rDoc);
            }
        };
        Runnable task = () -> db.resolveReplicationConflict(resolver, rDoc, continuation);
        Object object = this.getReplicatorLock();
        synchronized (object) {
            this.runTaskConcurrently(task);
            this.pendingResolutions.add(continuation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDocumentReplicationListener(@NonNull ListenerToken token) {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            this.docEndedListeners.remove(token);
            this.setProgressLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReplicationListener(@NonNull ListenerToken token) {
        Object object = this.getReplicatorLock();
        synchronized (object) {
            this.changeListeners.remove(token);
        }
    }

    @GuardedBy(value="getReplicatorLock()")
    private void setProgressLevel() {
        C4Replicator c4Repl = this.getC4Replicator();
        if (c4Repl == null) {
            return;
        }
        try {
            c4Repl.setProgressLevel(this.docEndedListeners.isEmpty() ? 0 : 1);
        }
        catch (LiteCoreException e) {
            Log.w(LOG_DOMAIN, "%s: failed setting progress level", this.getId());
        }
    }

    @NonNull
    private Database getDatabase() {
        Database db = this.config.getDatabase();
        if (db == null) {
            throw new CouchbaseLiteError("No database in Replicator");
        }
        return db;
    }

    private void setServerCertificates(List<Certificate> certificates) {
        this.serverCertificates.set(certificates);
    }

    @NonNull
    private String description() {
        return this.baseDesc() + ", " + this.getDatabase() + " => " + this.config.getTarget() + "}";
    }

    @NonNull
    private String simpleDesc() {
        return this.baseDesc() + "}";
    }

    @NonNull
    private String baseDesc() {
        return "Replicator{" + ClassUtils.objId(this) + "(" + (this.config.isPull() ? "<" : "") + (this.config.isContinuous() ? "*" : "o") + (this.config.isPush() ? ">" : "") + ")";
    }

    @NonNull
    private Deque<String> splitPath(@NonNull String fullPath) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        for (String element : fullPath.split("/")) {
            if (element.length() <= 0) continue;
            path.addLast(element);
        }
        return path;
    }

    static class ReplicatorCookieStore
    implements CBLCookieStore {
        @NonNull
        private final Database db;

        ReplicatorCookieStore(@NonNull Database db) {
            this.db = db;
        }

        @Override
        public void setCookies(@NonNull URI uri, @NonNull List<String> cookies, boolean acceptParentDomain) {
            this.db.setCookies(uri, cookies, acceptParentDomain);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public String getCookies(@NonNull URI uri) {
            Object object = this.db.getDbLock();
            synchronized (object) {
                return !this.db.isOpenLocked() ? null : this.db.getCookies(uri);
            }
        }
    }
}

