/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Authenticator;
import com.couchbase.lite.Collection;
import com.couchbase.lite.CollectionConfiguration;
import com.couchbase.lite.ConflictResolver;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Defaults;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.ProxyAuthenticator;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.ReplicatorConfiguration;
import com.couchbase.lite.internal.BaseReplicatorConfiguration;
import com.couchbase.lite.internal.ImmutableReplicatorConfiguration;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.internal.Util;

public abstract class AbstractReplicatorConfiguration
extends BaseReplicatorConfiguration {
    public static final int DISABLE_HEARTBEAT = 2147483;
    @NonNull
    private final Endpoint target;
    @NonNull
    private com.couchbase.lite.ReplicatorType type;
    private boolean continuous;
    @Nullable
    private Authenticator authenticator;
    @Nullable
    private ProxyAuthenticator proxyAuthenticator;
    @Nullable
    private Map<String, String> headers;
    private boolean acceptParentCookies;
    @Nullable
    private X509Certificate pinnedServerCertificate;
    private int maxAttempts;
    private int maxAttemptWaitTime;
    private int heartbeat;
    private boolean enableAutoPurge;
    @Nullable
    private Database database;

    private static int verifyHeartbeat(int heartbeat) {
        try {
            Util.checkDuration((String)"heartbeat", (long)heartbeat, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return heartbeat;
    }

    @Nullable
    protected static Map<Collection, CollectionConfiguration> configureDefaultCollection(@Nullable Database db) {
        Collection defaultCollection;
        if (db == null) {
            return null;
        }
        try {
            defaultCollection = db.getDefaultCollection();
        }
        catch (CouchbaseLiteException e) {
            throw new CouchbaseLiteError(Log.lookupStandardMessage("NoDefaultCollectionInConfig"), e);
        }
        HashMap<Collection, CollectionConfiguration> collections = new HashMap<Collection, CollectionConfiguration>();
        collections.put(defaultCollection, new CollectionConfiguration());
        return collections;
    }

    @Nullable
    private static Map<Collection, CollectionConfiguration> copyConfigs(@Nullable Map<Collection, CollectionConfiguration> configs) {
        return configs == null ? null : new HashMap<Collection, CollectionConfiguration>(configs);
    }

    protected AbstractReplicatorConfiguration(@Nullable Database db, @Nullable Map<Collection, CollectionConfiguration> collections, @NonNull Endpoint target) {
        this(collections, target, Defaults.Replicator.TYPE, false, null, null, null, false, null, 10, 300, 300, true, db);
    }

    protected AbstractReplicatorConfiguration(@NonNull AbstractReplicatorConfiguration config) {
        this(config.collectionConfigurations, config.target, config.type, config.continuous, config.authenticator, config.proxyAuthenticator, config.headers, config.acceptParentCookies, config.pinnedServerCertificate, config.maxAttempts, config.maxAttemptWaitTime, config.heartbeat, config.enableAutoPurge, config.database);
    }

    AbstractReplicatorConfiguration(@NonNull ImmutableReplicatorConfiguration config) {
        this(config.getCollectionConfigs(), config.getTarget(), config.getType(), config.isContinuous(), config.getAuthenticator(), config.getProxyAuthenticator(), config.getHeaders(), config.isAcceptParentCookies(), config.getPinnedServerCertificate(), config.getMaxRetryAttempts(), config.getMaxRetryAttemptWaitTime(), config.getHeartbeat(), config.isAutoPurgeEnabled(), config.getDatabase());
    }

    private AbstractReplicatorConfiguration(@Nullable Map<Collection, CollectionConfiguration> collections, @NonNull Endpoint target, @NonNull com.couchbase.lite.ReplicatorType type, boolean continuous, @Nullable Authenticator authenticator, @Nullable ProxyAuthenticator proxyAuthenticator, @Nullable Map<String, String> headers, boolean acceptParentCookies, @Nullable X509Certificate pinnedServerCertificate, int maxAttempts, int maxAttemptWaitTime, int heartbeat, boolean enableAutoPurge, @Nullable Database database) {
        super(AbstractReplicatorConfiguration.copyConfigs(collections));
        this.target = target;
        this.type = type;
        this.continuous = continuous;
        this.authenticator = authenticator;
        this.proxyAuthenticator = proxyAuthenticator;
        this.headers = headers;
        this.acceptParentCookies = acceptParentCookies;
        this.pinnedServerCertificate = pinnedServerCertificate;
        this.maxAttempts = maxAttempts;
        this.maxAttemptWaitTime = maxAttemptWaitTime;
        this.heartbeat = heartbeat;
        this.enableAutoPurge = enableAutoPurge;
        this.database = database;
    }

    @NonNull
    public final ReplicatorConfiguration addCollection(@NonNull Collection collection, @Nullable CollectionConfiguration config) {
        this.addCollectionConfig(collection, config == null ? new CollectionConfiguration() : new CollectionConfiguration(config));
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration addCollections(@NonNull java.util.Collection<Collection> collections, @Nullable CollectionConfiguration config) {
        if (config == null) {
            config = new CollectionConfiguration();
        }
        for (Collection collection : collections) {
            this.addCollectionConfig(collection, config);
        }
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration removeCollection(@NonNull Collection collection) {
        this.removeCollectionInternal(collection);
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setType(@NonNull com.couchbase.lite.ReplicatorType type) {
        this.type = Preconditions.assertNotNull(type, "replicator type");
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setContinuous(boolean continuous) {
        this.continuous = continuous;
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setAutoPurgeEnabled(boolean enabled) {
        this.enableAutoPurge = enabled;
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setHeaders(@Nullable Map<String, String> headers) {
        this.headers = headers == null ? null : new HashMap<String, String>(headers);
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setAcceptParentDomainCookies(boolean acceptParentCookies) {
        this.acceptParentCookies = acceptParentCookies;
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setAuthenticator(@Nullable Authenticator authenticator) {
        this.authenticator = authenticator;
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public ReplicatorConfiguration setProxyAuthenticator(@Nullable ProxyAuthenticator authenticator) {
        this.proxyAuthenticator = authenticator;
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setPinnedServerX509Certificate(@Nullable X509Certificate pinnedCert) {
        this.pinnedServerCertificate = pinnedCert;
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setMaxAttempts(int maxAttempts) {
        this.maxAttempts = Preconditions.assertNotNegative(maxAttempts, "max attempts");
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setMaxAttemptWaitTime(int maxAttemptWaitTime) {
        this.maxAttemptWaitTime = Preconditions.assertNotNegative(maxAttemptWaitTime, "max attempt wait time");
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final ReplicatorConfiguration setHeartbeat(int heartbeat) {
        this.heartbeat = AbstractReplicatorConfiguration.verifyHeartbeat(heartbeat);
        return this.getReplicatorConfiguration();
    }

    @Deprecated
    @NonNull
    public final ReplicatorConfiguration setReplicatorType(@NonNull ReplicatorType replicatorType) {
        com.couchbase.lite.ReplicatorType type;
        switch (Preconditions.assertNotNull(replicatorType, "replicator type")) {
            case PUSH_AND_PULL: {
                type = com.couchbase.lite.ReplicatorType.PUSH_AND_PULL;
                break;
            }
            case PUSH: {
                type = com.couchbase.lite.ReplicatorType.PUSH;
                break;
            }
            case PULL: {
                type = com.couchbase.lite.ReplicatorType.PULL;
                break;
            }
            default: {
                throw new CouchbaseLiteError("Unrecognized replicator type: " + (Object)((Object)replicatorType));
            }
        }
        return this.setType(type);
    }

    @Deprecated
    @NonNull
    public final ReplicatorConfiguration setPinnedServerCertificate(@Nullable byte[] pinnedCert) {
        if (pinnedCert == null) {
            this.pinnedServerCertificate = null;
        } else {
            try (ByteArrayInputStream is = new ByteArrayInputStream(pinnedCert);){
                this.pinnedServerCertificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(is);
            }
            catch (IOException | CertificateException e) {
                throw new IllegalArgumentException("Argument could not be parsed as an X509 Certificate", e);
            }
        }
        return this.getReplicatorConfiguration();
    }

    @Deprecated
    @NonNull
    public final ReplicatorConfiguration setDocumentIDs(@Nullable List<String> documentIDs) {
        this.updateValidDefaultConfigOrThrow(config -> config.setDocumentIDs(documentIDs == null ? null : new ArrayList(documentIDs)));
        return this.getReplicatorConfiguration();
    }

    @Deprecated
    @NonNull
    public final ReplicatorConfiguration setChannels(@Nullable List<String> channels) {
        this.updateValidDefaultConfigOrThrow(config -> config.setChannels(channels == null ? null : new ArrayList(channels)));
        return this.getReplicatorConfiguration();
    }

    @Deprecated
    @NonNull
    public final ReplicatorConfiguration setConflictResolver(@Nullable ConflictResolver conflictResolver) {
        this.updateValidDefaultConfigOrThrow(config -> config.setConflictResolver(conflictResolver));
        return this.getReplicatorConfiguration();
    }

    @Deprecated
    @NonNull
    public final ReplicatorConfiguration setPullFilter(@Nullable ReplicationFilter pullFilter) {
        this.updateValidDefaultConfigOrThrow(config -> config.setPullFilter(pullFilter));
        return this.getReplicatorConfiguration();
    }

    @Deprecated
    @NonNull
    public final ReplicatorConfiguration setPushFilter(@Nullable ReplicationFilter pushFilter) {
        this.updateValidDefaultConfigOrThrow(config -> config.setPushFilter(pushFilter));
        return this.getReplicatorConfiguration();
    }

    @NonNull
    public final Endpoint getTarget() {
        return this.target;
    }

    @Nullable
    public final CollectionConfiguration getCollectionConfiguration(@NonNull Collection collection) {
        CollectionConfiguration config = (CollectionConfiguration)this.collectionConfigurations.get(collection);
        return config == null ? null : new CollectionConfiguration(config);
    }

    @NonNull
    public final Set<Collection> getCollections() {
        return new HashSet<Collection>(this.collectionConfigurations.keySet());
    }

    @NonNull
    public final com.couchbase.lite.ReplicatorType getType() {
        return this.type;
    }

    public final boolean isContinuous() {
        return this.continuous;
    }

    public final boolean isAutoPurgeEnabled() {
        return this.enableAutoPurge;
    }

    @Nullable
    public final Map<String, String> getHeaders() {
        return this.headers == null ? null : new HashMap<String, String>(this.headers);
    }

    public final boolean isAcceptParentDomainCookies() {
        return this.acceptParentCookies;
    }

    @Nullable
    public final Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Nullable
    public ProxyAuthenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    @Nullable
    public final X509Certificate getPinnedServerX509Certificate() {
        return this.pinnedServerCertificate;
    }

    public final int getMaxAttempts() {
        return this.maxAttempts;
    }

    public final int getMaxAttemptWaitTime() {
        return this.maxAttemptWaitTime;
    }

    public final int getHeartbeat() {
        return this.heartbeat;
    }

    @Deprecated
    @NonNull
    public final ReplicatorType getReplicatorType() {
        switch (this.type) {
            case PUSH_AND_PULL: {
                return ReplicatorType.PUSH_AND_PULL;
            }
            case PUSH: {
                return ReplicatorType.PUSH;
            }
            case PULL: {
                return ReplicatorType.PULL;
            }
        }
        throw new CouchbaseLiteError("Unrecognized replicator type: " + (Object)((Object)this.type));
    }

    @Deprecated
    @Nullable
    public final byte[] getPinnedServerCertificate() {
        try {
            return this.pinnedServerCertificate == null ? null : this.pinnedServerCertificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new CouchbaseLiteError("Unrecognized certificate encoding", e);
        }
    }

    @Deprecated
    @NonNull
    public final Database getDatabase() {
        if (this.database != null) {
            return this.database;
        }
        throw new CouchbaseLiteError("No database or collections provided for replication configuration");
    }

    @Deprecated
    @Nullable
    public final List<String> getDocumentIDs() {
        List<String> docIds = this.getValidDefaultConfigOrThrow().getDocumentIDs();
        return docIds == null ? null : new ArrayList<String>(docIds);
    }

    @Deprecated
    @Nullable
    public final List<String> getChannels() {
        List<String> channels = this.getValidDefaultConfigOrThrow().getChannels();
        return channels == null ? null : new ArrayList<String>(channels);
    }

    @Deprecated
    @Nullable
    public final ConflictResolver getConflictResolver() {
        return this.getValidDefaultConfigOrThrow().getConflictResolver();
    }

    @Deprecated
    @Nullable
    public final ReplicationFilter getPullFilter() {
        return this.getValidDefaultConfigOrThrow().getPullFilter();
    }

    @Deprecated
    @Nullable
    public final ReplicationFilter getPushFilter() {
        return this.getValidDefaultConfigOrThrow().getPushFilter();
    }

    @NonNull
    public String toString() {
        StringBuilder buf = new StringBuilder("(");
        for (Collection c : this.collectionConfigurations.keySet()) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append(c.getScope().getName()).append('.').append(c.getName());
        }
        buf.append(") ");
        if (this.type == com.couchbase.lite.ReplicatorType.PULL || this.type == com.couchbase.lite.ReplicatorType.PUSH_AND_PULL) {
            buf.append('<');
        }
        buf.append(this.continuous ? (char)'*' : 'o');
        if (this.type == com.couchbase.lite.ReplicatorType.PUSH || this.type == com.couchbase.lite.ReplicatorType.PUSH_AND_PULL) {
            buf.append('>');
        }
        if (this.authenticator != null) {
            buf.append('@');
        }
        if (this.pinnedServerCertificate != null) {
            buf.append('^');
        }
        buf.append(' ');
        return "ReplicatorConfig{" + buf + this.target + '}';
    }

    @NonNull
    abstract ReplicatorConfiguration getReplicatorConfiguration();

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH", "NP_LOAD_OF_KNOWN_NULL_VALUE", "RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"})
    private void addCollectionConfig(@NonNull Collection collection, @NonNull CollectionConfiguration config) {
        Database db = Preconditions.assertNotNull(collection, "collection").getDatabase();
        if (this.database == null) {
            this.database = db;
        } else if (!this.database.equals(db)) {
            throw new IllegalArgumentException(Log.formatStandardMessage("AddCollectionFromAnotherDB", collection.toString(), this.database.getName()));
        }
        if (!this.database.isOpen()) {
            throw new IllegalArgumentException(Log.formatStandardMessage("AddCollectionFromClosedDB", collection.toString(), this.database.getName()));
        }
        try (Collection coll = this.database.getCollection(collection.getName(), collection.getScope().getName());){
            if (coll == null) {
                throw new IllegalArgumentException(Log.formatStandardMessage("AddDeletedCollection", collection.toString()));
            }
        }
        catch (CouchbaseLiteException e) {
            throw new IllegalArgumentException("Failed getting collection " + collection, e);
        }
        this.addCollectionInternal(collection, config);
    }

    @NonNull
    private CollectionConfiguration getValidDefaultConfigOrThrow() {
        return this.getAndUpdateDefaultConfig(null);
    }

    private void updateValidDefaultConfigOrThrow(@NonNull Fn.Consumer<CollectionConfiguration> updater) {
        this.getAndUpdateDefaultConfig(updater);
    }

    @NonNull
    private CollectionConfiguration getAndUpdateDefaultConfig(@Nullable Fn.Consumer<CollectionConfiguration> updater) {
        Collection defaultCollection = Fn.firstOrNull(this.collectionConfigurations.keySet(), Collection::isDefault);
        if (defaultCollection == null) {
            throw new IllegalArgumentException("Cannot use legacy parameters when there is no default collection");
        }
        CollectionConfiguration config = (CollectionConfiguration)this.collectionConfigurations.get(defaultCollection);
        if (config == null) {
            throw new IllegalArgumentException("Cannot use legacy parameters when the default collection has no configuration");
        }
        if (updater != null) {
            config = new CollectionConfiguration(config);
            updater.accept(config);
            this.addCollectionInternal(defaultCollection, config);
        }
        return config;
    }

    @Deprecated
    public static enum ReplicatorType {
        PUSH_AND_PULL,
        PUSH,
        PULL;

    }
}

