/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.ArrayInterface;
import com.couchbase.lite.BaseDatabase;
import com.couchbase.lite.Blob;
import com.couchbase.lite.CBLConverter;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.Fleece;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.MutableArray;
import com.couchbase.lite.internal.fleece.FLEncodable;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.MArray;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MContext;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.utils.JSONUtils;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Array
implements ArrayInterface,
FLEncodable,
Iterable<Object> {
    @NonNull
    protected final Object lock;
    @NonNull
    protected final MArray internalArray;

    protected Array() {
        this(new MArray());
    }

    Array(@NonNull MValue val, @Nullable MCollection parent) {
        this(new MArray(val, parent));
    }

    protected Array(@NonNull MArray array) {
        this.internalArray = array;
        MContext context = array.getContext();
        BaseDatabase db = context == null ? null : context.getDatabase();
        this.lock = db == null ? new Object() : db.getDbLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableArray toMutable() {
        Object object = this.lock;
        synchronized (object) {
            return new MutableArray(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int count() {
        Object object = this.lock;
        synchronized (object) {
            return (int)this.internalArray.count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getValue(int index) {
        Object object = this.lock;
        synchronized (object) {
            return this.getMValue(this.internalArray, index).asNative(this.internalArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getString(int index) {
        Object object = this.lock;
        synchronized (object) {
            Object obj = this.getMValue(this.internalArray, index).asNative(this.internalArray);
            return !(obj instanceof String) ? null : (String)obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Number getNumber(int index) {
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asNumber(this.getMValue(this.internalArray, index).asNative(this.internalArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int index) {
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asInteger(this.getMValue(this.internalArray, index), this.internalArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int index) {
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asLong(this.getMValue(this.internalArray, index), this.internalArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int index) {
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asFloat(this.getMValue(this.internalArray, index), this.internalArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int index) {
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asDouble(this.getMValue(this.internalArray, index), this.internalArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int index) {
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asBoolean(this.getMValue(this.internalArray, index).asNative(this.internalArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Blob getBlob(int index) {
        Object object = this.lock;
        synchronized (object) {
            Object obj = this.getMValue(this.internalArray, index).asNative(this.internalArray);
            return !(obj instanceof Blob) ? null : (Blob)obj;
        }
    }

    @Override
    @Nullable
    public Date getDate(int index) {
        return JSONUtils.toDate(this.getString(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Array getArray(int index) {
        Object object = this.lock;
        synchronized (object) {
            Object obj = this.getMValue(this.internalArray, index).asNative(this.internalArray);
            return !(obj instanceof Array) ? null : (Array)obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Dictionary getDictionary(int index) {
        Object object = this.lock;
        synchronized (object) {
            Object obj = this.getMValue(this.internalArray, index).asNative(this.internalArray);
            return !(obj instanceof Dictionary) ? null : (Dictionary)obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<Object> toList() {
        Object object = this.lock;
        synchronized (object) {
            int count = (int)this.internalArray.count();
            ArrayList<Object> result = new ArrayList<Object>(count);
            for (int index = 0; index < count; ++index) {
                result.add(Fleece.toObject(this.getMValue(this.internalArray, index).asNative(this.internalArray)));
            }
            return result;
        }
    }

    @Override
    @NonNull
    public String toJSON() throws CouchbaseLiteException {
        FLEncoder.JSONEncoder encoder = FLEncoder.getJSONEncoder();
        try {
            this.internalArray.encodeTo(encoder);
            String string = encoder.finishJSON();
            if (encoder != null) {
                encoder.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (encoder != null) {
                    try {
                        encoder.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e, "Cannot encode array: " + this);
            }
        }
    }

    @Override
    @NonNull
    public Iterator<Object> iterator() {
        return new ArrayIterator();
    }

    @Override
    public void encodeTo(@NonNull FLEncoder enc) {
        this.internalArray.encodeTo(enc);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Array)) {
            return false;
        }
        Array a = (Array)o;
        Iterator<Object> itr1 = this.iterator();
        Iterator<Object> itr2 = a.iterator();
        while (itr1.hasNext() && itr2.hasNext()) {
            Object o2;
            Object o1 = itr1.next();
            if (Objects.equals(o1, o2 = itr2.next())) continue;
            return false;
        }
        return !itr1.hasNext() && !itr2.hasNext();
    }

    public int hashCode() {
        int h = 1;
        for (Object o : this) {
            h = 31 * h + (o == null ? 0 : o.hashCode());
        }
        return h;
    }

    @NonNull
    public String toString() {
        StringBuilder buf = new StringBuilder("Array{(").append(this.internalArray.getStateString()).append(')');
        int n = this.count();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.getValue(i));
        }
        return buf.append('}').toString();
    }

    @NonNull
    private MValue getMValue(@NonNull MArray array, int index) {
        MValue value = array.get(index);
        if (value.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("index " + index + " is not 0 <= index < " + this.count());
        }
        return value;
    }

    private class ArrayIterator
    implements Iterator<Object> {
        private final long mutations;
        private int index;

        ArrayIterator() {
            this.mutations = Array.this.internalArray.getLocalMutationCount();
        }

        @Override
        public boolean hasNext() {
            return this.index < Array.this.count();
        }

        @Override
        @Nullable
        public Object next() {
            if (Array.this.internalArray.getLocalMutationCount() != this.mutations) {
                throw new ConcurrentModificationException("Array modified during iteration");
            }
            return Array.this.getValue(this.index++);
        }
    }
}

