/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import com.couchbase.lite.ArrayExpressionIn;
import com.couchbase.lite.VariableExpression;
import com.couchbase.lite.internal.utils.Preconditions;

public final class ArrayExpression {
    @NonNull
    public static ArrayExpressionIn any(@NonNull VariableExpression variable) {
        Preconditions.assertNotNull(variable, "variable");
        return new ArrayExpressionIn(QuantifiesType.ANY, variable);
    }

    @NonNull
    public static ArrayExpressionIn every(@NonNull VariableExpression variable) {
        Preconditions.assertNotNull(variable, "variable");
        return new ArrayExpressionIn(QuantifiesType.EVERY, variable);
    }

    @NonNull
    public static ArrayExpressionIn anyAndEvery(@NonNull VariableExpression variable) {
        Preconditions.assertNotNull(variable, "variable");
        return new ArrayExpressionIn(QuantifiesType.ANY_AND_EVERY, variable);
    }

    @NonNull
    public static VariableExpression variable(@NonNull String name) {
        Preconditions.assertNotNull(name, "name");
        return new VariableExpression(name);
    }

    private ArrayExpression() {
    }

    static enum QuantifiesType {
        ANY,
        ANY_AND_EVERY,
        EVERY;

    }
}

