/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.IndexConfiguration;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.internal.core.C4Collection;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ArrayIndexConfiguration
extends IndexConfiguration {
    private final String path;

    @NonNull
    private static List<String> aggregateExpressions(@NonNull String expression, @Nullable String[] expressions) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(expression);
        if (expressions != null) {
            list.addAll(Arrays.asList(expressions));
        }
        return list;
    }

    @NonNull
    private static List<String> checkExpressions(@Nullable List<String> expressions) {
        String expr;
        if (expressions == null) {
            return Collections.singletonList("");
        }
        if (expressions.size() == 1 && (expr = expressions.get(0)) != null && expr.isEmpty()) {
            throw new IllegalArgumentException("An expression list should not contain a single empty string. Use null to specify no expressions.");
        }
        return expressions;
    }

    public ArrayIndexConfiguration(@NonNull String path) {
        this(path, (List<String>)null);
    }

    public ArrayIndexConfiguration(@NonNull String path, @NonNull String expression, String ... expressions) {
        this(path, ArrayIndexConfiguration.aggregateExpressions(expression, expressions));
    }

    public ArrayIndexConfiguration(@NonNull String path, @Nullable List<String> expressions) {
        super(ArrayIndexConfiguration.checkExpressions(expressions));
        this.path = Preconditions.assertNotNull(path, "path");
    }

    @NonNull
    public String getPath() {
        return this.path;
    }

    @Override
    void createIndex(@NonNull String name, @NonNull C4Collection c4Collection) throws LiteCoreException, CouchbaseLiteException {
        String indexSpec = this.getIndexSpec();
        c4Collection.createArrayIndex(name, this.path, indexSpec);
    }
}

