/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.internal.core.C4BlobStore;
import com.couchbase.lite.internal.core.C4Database;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public abstract class BaseDatabase {
    @NonNull
    private final Object dbLock = new Object();
    @GuardedBy(value="dbLock")
    @Nullable
    private C4Database c4Database;
    @GuardedBy(value="dbLock")
    @Nullable
    private String path;

    @NonNull
    protected Object getDbLock() {
        return this.dbLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String getDbPath() {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected C4BlobStore getBlobStore() throws LiteCoreException {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked().getBlobStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isOpen() {
        Object object = this.dbLock;
        synchronized (object) {
            return this.isOpenLocked();
        }
    }

    @GuardedBy(value="dbLock")
    protected boolean isOpenLocked() {
        return this.c4Database != null;
    }

    @GuardedBy(value="dbLock")
    protected void assertOpenUnchecked() {
        if (!this.isOpenLocked()) {
            throw new CouchbaseLiteError(Log.lookupStandardMessage("DBClosedOrCollectionDeleted"));
        }
    }

    @GuardedBy(value="dbLock")
    protected void assertOpenChecked() throws CouchbaseLiteException {
        if (!this.isOpenLocked()) {
            throw new CouchbaseLiteException(Log.lookupStandardMessage("DBClosedOrCollectionDeleted"), "CouchbaseLite", 6);
        }
    }

    @GuardedBy(value="dbLock")
    protected void setC4DatabaseLocked(@Nullable C4Database c4Database) {
        this.c4Database = c4Database;
        if (c4Database != null) {
            this.path = c4Database.getDbPath();
        }
    }

    @GuardedBy(value="dbLock")
    @NonNull
    protected C4Database getOpenC4DbLocked() {
        this.assertOpenUnchecked();
        return Preconditions.assertNotNull(this.c4Database, "c4db");
    }

    @GuardedBy(value="dbLock")
    @NonNull
    protected C4Database getC4DbOrThrowLocked() throws CouchbaseLiteException {
        this.assertOpenChecked();
        return Preconditions.assertNotNull(this.c4Database, "c4db");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"})
    @NonNull
    C4Database getOpenC4Database() {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4DbLocked();
        }
    }
}

