/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.CollectionChange;
import com.couchbase.lite.CollectionChangeListener;
import com.couchbase.lite.CollectionChangeNotifier;
import com.couchbase.lite.ConcurrencyControl;
import com.couchbase.lite.ConflictHandler;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Document;
import com.couchbase.lite.DocumentChange;
import com.couchbase.lite.DocumentChangeListener;
import com.couchbase.lite.DocumentChangeNotifier;
import com.couchbase.lite.Index;
import com.couchbase.lite.IndexConfiguration;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.MutableDocument;
import com.couchbase.lite.QueryIndex;
import com.couchbase.lite.Scope;
import com.couchbase.lite.internal.BaseCollection;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.core.C4Collection;
import com.couchbase.lite.internal.core.C4CollectionObserver;
import com.couchbase.lite.internal.core.C4Document;
import com.couchbase.lite.internal.core.C4DocumentObserver;
import com.couchbase.lite.internal.core.C4Index;
import com.couchbase.lite.internal.exec.ExecutionService;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.listener.ChangeListenerToken;
import com.couchbase.lite.internal.listener.Listenable;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

public final class Collection
extends BaseCollection
implements Listenable<CollectionChange, CollectionChangeListener>,
AutoCloseable {
    public static final String DEFAULT_NAME = "_default";
    static final int MAX_CONFLICT_RESOLUTION_RETRIES = 13;
    @VisibleForTesting
    static final String INDEX_KEY_NAME = "name";
    @VisibleForTesting
    static final String INDEX_KEY_EXPR = "expr";
    @VisibleForTesting
    static final String INDEX_KEY_LANG = "lang";
    @VisibleForTesting
    static final String INDEX_KEY_TYPE = "type";
    @NonNull
    private final C4Collection c4Collection;
    @GuardedBy(value="getDbLock()")
    private CollectionChangeNotifier collectionChangeNotifier;
    @GuardedBy(value="getDbLock()")
    private final Map<String, DocumentChangeNotifier> docChangeNotifiers = new HashMap<String, DocumentChangeNotifier>();
    private final ExecutionService.CloseableExecutor postExecutor;

    @NonNull
    static Collection createCollection(@NonNull Database db, @NonNull String scopeName, @NonNull String collectionName) throws CouchbaseLiteException {
        try {
            return new Collection(db, db.addC4Collection(scopeName, collectionName));
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    @Nullable
    static Collection getCollection(@NonNull Database db, @NonNull String scopeName, @NonNull String collectionName) throws CouchbaseLiteException {
        try {
            C4Collection c4Coll = db.getC4Collection(scopeName, collectionName);
            return c4Coll == null ? null : new Collection(db, c4Coll);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    @NonNull
    static Collection getDefaultCollection(@NonNull Database db) throws CouchbaseLiteException {
        try {
            return new Collection(db, db.getDefaultC4Collection());
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    Collection(@NonNull Database db, @NonNull C4Collection c4Collection) {
        super(db);
        this.c4Collection = c4Collection;
        this.postExecutor = CouchbaseLiteInternal.getExecutionService().getSerialExecutor();
    }

    @NonNull
    public Scope getScope() {
        return new Scope(this.c4Collection.getScope(), this.db);
    }

    @NonNull
    public String getName() {
        return this.c4Collection.getName();
    }

    @NonNull
    public String getFullName() {
        return this.c4Collection.getScope() + "." + this.c4Collection.getName();
    }

    @NonNull
    public Database getDatabase() {
        return this.db;
    }

    public long getCount() {
        return Preconditions.assertNotNull(this.withLock(() -> !this.db.isOpenLocked() ? 0L : this.c4Collection.getDocumentCount()), "token");
    }

    @Nullable
    public Document getDocument(@NonNull String id) throws CouchbaseLiteException {
        return this.withLockAndOpenDb(() -> Document.getDocumentOrNull(this, id));
    }

    public void save(@NonNull MutableDocument document) throws CouchbaseLiteException {
        this.save(document, ConcurrencyControl.LAST_WRITE_WINS);
    }

    public boolean save(@NonNull MutableDocument document, @NonNull ConcurrencyControl concurrencyControl) throws CouchbaseLiteException {
        try {
            this.prepareDocument(document);
            this.withLockAndOpenDb(() -> {
                this.saveLocked(document, null, false, concurrencyControl);
                return null;
            });
            return true;
        }
        catch (CouchbaseLiteException e) {
            if (!CouchbaseLiteException.isConflict(e)) {
                throw e;
            }
            return false;
        }
    }

    public boolean save(@NonNull MutableDocument document, @NonNull ConflictHandler conflictHandler) throws CouchbaseLiteException {
        Preconditions.assertNotNull(document, "document");
        Preconditions.assertNotNull(conflictHandler, "conflictHandler");
        this.prepareDocument(document);
        return this.saveWithConflictHandler(document, conflictHandler);
    }

    public void delete(@NonNull Document document) throws CouchbaseLiteException {
        this.delete(document, ConcurrencyControl.LAST_WRITE_WINS);
    }

    public boolean delete(@NonNull Document document, @NonNull ConcurrencyControl concurrencyControl) throws CouchbaseLiteException {
        try {
            this.prepareDocument(document);
            this.withLockAndOpenDb(() -> {
                this.saveLocked(document, null, true, concurrencyControl);
                return null;
            });
            return true;
        }
        catch (CouchbaseLiteException e) {
            if (!CouchbaseLiteException.isConflict(e)) {
                throw e;
            }
            return false;
        }
    }

    public void purge(@NonNull Document document) throws CouchbaseLiteException {
        Preconditions.assertNotNull(document, "document");
        if (document.isNewDocument()) {
            throw new CouchbaseLiteException("DocumentNotFound", "CouchbaseLite", 7);
        }
        this.withLockAndOpenDb(() -> {
            block2: {
                this.prepareDocument(document);
                try {
                    this.purgeLocked(document.getId());
                }
                catch (CouchbaseLiteException e) {
                    if (e.getCode() == 7) break block2;
                    throw e;
                }
            }
            document.replaceC4Document(null);
            return null;
        });
    }

    public void purge(@NonNull String id) throws CouchbaseLiteException {
        Preconditions.assertNotNull(id, "id");
        this.withLockAndOpenDb(() -> {
            this.purgeLocked(id);
            return null;
        });
    }

    public void setDocumentExpiration(@NonNull String id, @Nullable Date expiration) throws CouchbaseLiteException {
        Preconditions.assertNotNull(id, "id");
        this.withLockAndOpenDb(() -> {
            try {
                this.c4Collection.setDocumentExpiration(id, expiration == null ? 0L : expiration.getTime());
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
            return null;
        });
    }

    @Nullable
    public Date getDocumentExpiration(@NonNull String id) throws CouchbaseLiteException {
        Preconditions.assertNotNull(id, "id");
        return this.withLockAndOpenDb(() -> {
            try {
                long timestamp = this.c4Collection.getDocumentExpiration(id);
                return timestamp == 0L ? null : new Date(timestamp);
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        });
    }

    @Override
    @NonNull
    public ListenerToken addChangeListener(@NonNull CollectionChangeListener listener) {
        return this.addChangeListener((Executor)null, listener);
    }

    @Override
    @NonNull
    public ListenerToken addChangeListener(@Nullable Executor executor, @NonNull CollectionChangeListener listener) {
        Preconditions.assertNotNull(listener, "listener");
        return Preconditions.assertNotNull(this.withLock(() -> this.addCollectionChangeListenerLocked(executor, listener)), "token");
    }

    @NonNull
    public ListenerToken addDocumentChangeListener(@NonNull String id, @NonNull DocumentChangeListener listener) {
        return this.addDocumentChangeListener(id, null, listener);
    }

    @NonNull
    public ListenerToken addDocumentChangeListener(@NonNull String id, @Nullable Executor executor, @NonNull DocumentChangeListener listener) {
        Preconditions.assertNotNull(id, "docId");
        Preconditions.assertNotNull(listener, "listener");
        return Preconditions.assertNotNull(this.withLock(() -> this.addDocumentChangeListenerLocked(id, executor, listener)), "token");
    }

    @NonNull
    public Set<String> getIndexes() throws CouchbaseLiteException {
        HashSet<String> indexNames = new HashSet<String>();
        List<Map<String, ?>> indexesInfo = this.getIndexInfo();
        if (indexesInfo.isEmpty()) {
            return indexNames;
        }
        for (Map<String, ?> idxInfo : indexesInfo) {
            Object idxName = idxInfo.get(INDEX_KEY_NAME);
            if (!(idxName instanceof String)) continue;
            indexNames.add((String)idxName);
        }
        return indexNames;
    }

    @Nullable
    public QueryIndex getIndex(@NonNull String name) throws CouchbaseLiteException {
        C4Index idx = this.getC4Index(name);
        return idx == null ? null : new QueryIndex(this, name, idx);
    }

    public void createIndex(@NonNull String name, @NonNull IndexConfiguration config) throws CouchbaseLiteException {
        this.createIndexInternal(name, config);
    }

    public void createIndex(@NonNull String name, @NonNull Index index) throws CouchbaseLiteException {
        this.createIndexInternal(name, index);
    }

    public void deleteIndex(@NonNull String name) throws CouchbaseLiteException {
        try {
            this.c4Collection.deleteIndex(name);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.getDbLock();
        synchronized (object) {
            this.closeCollectionChangeNotifierLocked();
            for (DocumentChangeNotifier notifier : this.docChangeNotifiers.values()) {
                notifier.close();
            }
            this.docChangeNotifiers.clear();
            this.c4Collection.close();
        }
    }

    @NonNull
    public String toString() {
        return this.c4Collection.getDb() + "." + this.getFullName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection other = (Collection)o;
        return this.db == other.db && this.c4Collection.getScope().equals(other.c4Collection.getScope()) && this.c4Collection.getName().equals(other.c4Collection.getName());
    }

    public int hashCode() {
        return Objects.hash(this.c4Collection.getScope(), this.c4Collection.getName());
    }

    @NonNull
    C4CollectionObserver createCollectionObserver(@NonNull Runnable listener) throws CouchbaseLiteException {
        try {
            return this.c4Collection.createCollectionObserver(listener);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e, "Invalid collection: it has either been deleted or its database closed");
        }
    }

    @NonNull
    C4DocumentObserver createDocumentObserver(@NonNull String docID, @NonNull Runnable listener) throws CouchbaseLiteException {
        try {
            return this.c4Collection.createDocumentObserver(docID, listener);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e, "Invalid collection: it has either been deleted or its database closed");
        }
    }

    boolean isValid() {
        return this.c4Collection.isValid();
    }

    boolean isDefault() {
        return DEFAULT_NAME.equals(this.getScope().getName()) && DEFAULT_NAME.equals(this.getName());
    }

    @NonNull
    Object getDbLock() {
        return this.db.getDbLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Collection getOpenC4Collection() throws CouchbaseLiteException {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.getOpenC4CollectionLocked();
        }
    }

    @GuardedBy(value="getDbLock()")
    boolean isOpenLocked() {
        return this.db.isOpenLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    C4Document createC4Document(@NonNull String docId, @Nullable FLSliceResult body, int flags) throws CouchbaseLiteException {
        try {
            Object object = this.getDbLock();
            synchronized (object) {
                return this.c4Collection.createDocument(docId, body, flags);
            }
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e, "Could not create document: " + docId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    C4Document getC4Document(@NonNull String docId) throws CouchbaseLiteException {
        try {
            Object object = this.getDbLock();
            synchronized (object) {
                return this.c4Collection.getDocument(docId);
            }
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e, "Failed retrieving document: " + docId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    C4Document getC4DocumentWithRevs(@NonNull String docId) throws CouchbaseLiteException {
        try {
            Object object = this.getDbLock();
            synchronized (object) {
                return this.c4Collection.getDocumentWithRevs(docId);
            }
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e, "Failed retrieving document: " + docId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean saveWithConflictHandler(@NonNull MutableDocument document, @NonNull ConflictHandler handler) throws CouchbaseLiteException {
        Document oldDoc = null;
        int n = 0;
        while (true) {
            if (n++ > 13) {
                throw new CouchbaseLiteException("Too many attempts to resolve a conflicted document: " + n, "CouchbaseLite", 10);
            }
            Object object = this.getDbLock();
            synchronized (object) {
                this.assertOpen();
                try {
                    this.saveLocked(document, oldDoc, false, ConcurrencyControl.FAIL_ON_CONFLICT);
                    return true;
                }
                catch (CouchbaseLiteException e) {
                    if (!CouchbaseLiteException.isConflict(e)) {
                        throw e;
                    }
                    oldDoc = Document.getDocumentWithDeleted(this, document.getId());
                    // MONITOREXIT @DISABLED, blocks:[3, 4, 6] lbl17 : MonitorExitStatement: MONITOREXIT : var5_5
                    try {
                        if (handler.handle(document, oldDoc.isDeleted() ? null : oldDoc)) continue;
                        return false;
                    }
                    catch (Exception e2) {
                        throw new CouchbaseLiteException("Conflict handler threw an exception", e2, "CouchbaseLite", 8);
                    }
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GuardedBy(value="getDbLock()")
    void saveLocked(@NonNull Document document, @Nullable Document baseDoc, boolean deleting, @NonNull ConcurrencyControl concurrencyControl) throws CouchbaseLiteException {
        Preconditions.assertNotNull(document, "document");
        Preconditions.assertNotNull(concurrencyControl, "concurrencyControl");
        if (deleting && !document.exists()) {
            throw new CouchbaseLiteException("DeleteDocFailedNotSaved", "CouchbaseLite", 7);
        }
        boolean commit = false;
        this.db.beginTransaction();
        try {
            this.saveInTransaction(document, baseDoc == null ? null : baseDoc.getC4doc(), deleting);
            commit = true;
            return;
        }
        catch (CouchbaseLiteException e) {
            if (!CouchbaseLiteException.isConflict(e)) {
                throw e;
            }
            switch (concurrencyControl) {
                case FAIL_ON_CONFLICT: {
                    throw new CouchbaseLiteException("Conflict", "CouchbaseLite", 8);
                }
                case LAST_WRITE_WINS: {
                    commit = this.saveConflicted(document, deleting);
                    return;
                }
                default: {
                    throw new CouchbaseLiteException("Unrecognized concurrency control: " + (Object)((Object)concurrencyControl));
                }
            }
        }
        finally {
            this.db.endTransaction(commit);
        }
    }

    @GuardedBy(value="getDbLock()")
    @NonNull
    ListenerToken addCollectionChangeListenerLocked(@Nullable Executor executor, @NonNull CollectionChangeListener listener) {
        if (this.collectionChangeNotifier == null) {
            this.collectionChangeNotifier = new CollectionChangeNotifier(this);
            if (this.isOpenLocked()) {
                try {
                    this.collectionChangeNotifier.start(this::scheduleImmediateOnPostExecutor);
                }
                catch (CouchbaseLiteException e) {
                    Log.d(LogDomain.LISTENER, "Listener failed", e);
                    return ChangeListenerToken.DUMMY;
                }
            }
        }
        return this.collectionChangeNotifier.addChangeListener(executor, listener, this::removeCollectionChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCollectionChangeListener(@NonNull ListenerToken token) {
        if (!(token instanceof ChangeListenerToken)) {
            Log.d(LogDomain.DATABASE, "Attempt to remove unrecognized db change listener: " + token);
            return;
        }
        Object object = this.getDbLock();
        synchronized (object) {
            if (this.collectionChangeNotifier != null && this.collectionChangeNotifier.removeChangeListener(token)) {
                this.closeCollectionChangeNotifierLocked();
            }
        }
    }

    @GuardedBy(value="getDbLock()")
    @NonNull
    ListenerToken addDocumentChangeListenerLocked(@NonNull String docID, @Nullable Executor executor, @NonNull DocumentChangeListener listener) {
        DocumentChangeNotifier docNotifier = this.docChangeNotifiers.get(docID);
        if (docNotifier == null) {
            docNotifier = new DocumentChangeNotifier(this, docID);
            this.docChangeNotifiers.put(docID, docNotifier);
            if (this.isOpenLocked()) {
                try {
                    docNotifier.start(this::scheduleImmediateOnPostExecutor);
                }
                catch (CouchbaseLiteException e) {
                    Log.d(LogDomain.LISTENER, "Listener failed", e);
                    return ChangeListenerToken.DUMMY;
                }
            }
        }
        ChangeListenerToken<DocumentChange> token = docNotifier.addChangeListener(executor, listener, this::removeDocumentChangeListener);
        token.setKey(docID);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDocumentChangeListener(@NonNull ListenerToken token) {
        if (!(token instanceof ChangeListenerToken)) {
            Log.d(LogDomain.DATABASE, "Attempt to remove unrecognized doc change listener: " + token);
            return;
        }
        String docId = ((ChangeListenerToken)token).getKey();
        Object object = this.getDbLock();
        synchronized (object) {
            DocumentChangeNotifier notifier = this.docChangeNotifiers.get(docId);
            if (notifier == null) {
                return;
            }
            if (notifier.removeChangeListener(token)) {
                notifier.close();
                this.docChangeNotifiers.remove(docId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createIndexInternal(@NonNull String name, @NonNull AbstractIndex index) throws CouchbaseLiteException {
        Preconditions.assertNotNull(name, INDEX_KEY_NAME);
        Preconditions.assertNotNull(index, "index");
        Object object = this.getDbLock();
        synchronized (object) {
            try {
                index.createIndex(name, this.c4Collection);
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getCollectionListenerCount() {
        Object object = this.getDbLock();
        synchronized (object) {
            return this.collectionChangeNotifier == null ? 0 : this.collectionChangeNotifier.getListenerCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NonNull
    List<Map<String, ?>> getIndexInfo() throws CouchbaseLiteException {
        FLValue flIndexInfo;
        Object object = this.getDbLock();
        synchronized (object) {
            try {
                flIndexInfo = this.c4Collection.getIndexesInfo();
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
        ArrayList info = new ArrayList();
        Object indexesInfo = flIndexInfo.asObject();
        if (!(indexesInfo instanceof List)) {
            return info;
        }
        for (Object idxInfo : (List)indexesInfo) {
            if (!(idxInfo instanceof Map)) continue;
            info.add((Map)idxInfo);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    C4Index getC4Index(@NonNull String name) throws CouchbaseLiteException {
        try {
            Object object = this.getDbLock();
            synchronized (object) {
                this.db.assertOpenChecked();
                return this.c4Collection.getIndex(name);
            }
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T withLock(@NonNull Fn.Provider<T> task) {
        Object object = this.getDbLock();
        synchronized (object) {
            return task.get();
        }
    }

    @GuardedBy(value="dbLock")
    @NonNull
    private C4Collection getOpenC4CollectionLocked() throws CouchbaseLiteException {
        this.assertOpenChecked();
        return Preconditions.assertNotNull(this.c4Collection, "c4collection");
    }

    @GuardedBy(value="dbLock")
    private void assertOpenChecked() throws CouchbaseLiteException {
        if (!this.db.isOpenLocked()) {
            throw new CouchbaseLiteException(Log.lookupStandardMessage("DBClosedOrCollectionDeleted"), "CouchbaseLite", 6);
        }
    }

    @GuardedBy(value="dbLock")
    private void assertOpen() throws CouchbaseLiteException {
        if (!this.db.isOpenLocked()) {
            throw new CouchbaseLiteException(Log.lookupStandardMessage("DBClosedOrCollectionDeleted"), "CouchbaseLite", 6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T withLockAndOpenDb(@NonNull Fn.ProviderThrows<T, CouchbaseLiteException> task) throws CouchbaseLiteException {
        Object object = this.getDbLock();
        synchronized (object) {
            this.assertOpen();
            return task.get();
        }
    }

    @GuardedBy(value="getDbLock()")
    private void prepareDocument(@NonNull Document document) throws CouchbaseLiteException {
        Collection docCollection = document.getCollection();
        if (docCollection == null) {
            document.setCollection(this);
        } else if (!this.equals(docCollection)) {
            throw new CouchbaseLiteException("DocumentAnotherDatabase", "CouchbaseLite", 9);
        }
    }

    @GuardedBy(value="getDbLock()")
    private void purgeLocked(@NonNull String id) throws CouchbaseLiteException {
        try {
            this.c4Collection.purgeDocument(id);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e, "Purge failed");
        }
    }

    @GuardedBy(value="getDbLock()")
    private boolean saveConflicted(@NonNull Document document, boolean deleting) throws CouchbaseLiteException {
        C4Document curDoc = this.getC4Document(document.getId());
        if (curDoc == null) {
            return false;
        }
        if (deleting && curDoc.isDocDeleted()) {
            document.replaceC4Document(curDoc);
            return false;
        }
        this.saveInTransaction(document, curDoc, deleting);
        return true;
    }

    @GuardedBy(value="getDbLock()")
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private void saveInTransaction(@NonNull Document document, @Nullable C4Document base, boolean deleting) throws CouchbaseLiteException {
        try (FLSliceResult body = null;){
            C4Document c4Doc;
            int revFlags = 0;
            if (deleting) {
                revFlags = 1;
            } else if (!document.isEmpty() && C4Document.dictContainsBlobs(body = document.encode(), this.db.getSharedKeys())) {
                revFlags |= 8;
            }
            C4Document c4Document = c4Doc = base != null ? base : document.getC4doc();
            if (c4Doc != null) {
                c4Doc = c4Doc.update(body, revFlags);
            } else {
                Collection collection = document.getCollection();
                if (collection == null) {
                    throw new CouchbaseLiteError("Attempt to save document in null collection");
                }
                c4Doc = collection.createC4Document(document.getId(), body, revFlags);
            }
            document.replaceC4Document(c4Doc);
        }
    }

    private void closeCollectionChangeNotifierLocked() {
        CollectionChangeNotifier notifier = this.collectionChangeNotifier;
        this.collectionChangeNotifier = null;
        if (notifier != null) {
            notifier.close();
        }
    }

    private void scheduleImmediateOnPostExecutor(@NonNull Runnable task) {
        CouchbaseLiteInternal.getExecutionService().postDelayedOnExecutor(0L, this.postExecutor, task);
    }

    @Override
    @NonNull
    protected Document createFilterDocument(@NonNull String docId, @NonNull String revId, @NonNull FLDict body) {
        return new Document(this, docId, revId, body);
    }
}

