/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.Collection;
import com.couchbase.lite.CollectionChange;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.internal.core.C4DocumentChange;
import com.couchbase.lite.internal.listener.ChangeNotifier;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.List;

final class CollectionChangeNotifier
extends ChangeNotifier<CollectionChange>
implements AutoCloseable {
    private static final int REQUESTED_CHANGES = 100;
    private static final int MAX_CHANGES = 1000;
    @NonNull
    private final Collection collection;
    @GuardedBy(value="collection.getDbLock()")
    @Nullable
    private ChangeNotifier.C4ChangeProducer<C4DocumentChange> c4Observer;

    CollectionChangeNotifier(@NonNull Collection collection) {
        this.collection = Preconditions.assertNotNull(collection, "collection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.collection.getDbLock();
        synchronized (object) {
            if (this.c4Observer != null) {
                this.c4Observer.close();
            }
            this.c4Observer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(@NonNull Fn.Consumer<Runnable> onChange) throws CouchbaseLiteException {
        Object object = this.collection.getDbLock();
        synchronized (object) {
            this.c4Observer = this.collection.createCollectionObserver(() -> onChange.accept(this::collectionChanged));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void run(@NonNull ChangeNotifier.C4ChangeProducer<C4DocumentChange> observer) {
        Object object = this.collection.getDbLock();
        synchronized (object) {
            this.c4Observer = observer;
        }
        this.collectionChanged();
    }

    private void collectionChanged() {
        Object object = this.collection.getDbLock();
        synchronized (object) {
            ChangeNotifier.C4ChangeProducer<C4DocumentChange> observer = this.c4Observer;
            if (!this.collection.isOpenLocked() || observer == null) {
                return;
            }
            boolean external = false;
            ArrayList<String> docIDs = new ArrayList<String>();
            while (true) {
                List<C4DocumentChange> changes;
                if ((changes = observer.getChanges(100)) == null) {
                    this.postChanges(docIDs);
                    return;
                }
                if ((changes = Fn.filterToList(changes, ch -> ch != null)).isEmpty()) continue;
                boolean newExternal = changes.get(0).isExternal();
                if (docIDs.size() + changes.size() > 1000 || external != newExternal) {
                    this.postChanges(docIDs);
                    docIDs = new ArrayList();
                }
                docIDs.addAll(Fn.mapToList(changes, C4DocumentChange::getDocID));
                external = newExternal;
            }
        }
    }

    private void postChanges(@NonNull List<String> docIds) {
        if (docIds.isEmpty()) {
            return;
        }
        this.postChange(new CollectionChange(this.collection, docIds));
    }
}

