/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.Logger;
import com.couchbase.lite.internal.utils.Preconditions;
import com.couchbase.lite.logging.ConsoleLogSink;
import com.couchbase.lite.logging.LogSinks;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

@Deprecated
public class ConsoleLogger
implements Logger {
    @Nullable
    private ShimLogger logger;

    ConsoleLogger() {
    }

    @Override
    @NonNull
    public LogLevel getLevel() {
        ConsoleLogSink curLogger = LogSinks.get().getConsole();
        return curLogger == null ? LogLevel.NONE : curLogger.getLevel();
    }

    public void setLevel(@NonNull LogLevel level) {
        Preconditions.assertNotNull(level, "level");
        LogLevel curLevel = this.getLevel();
        if (curLevel == level) {
            return;
        }
        this.logger = this.shimFactory(level, this.getDomains());
        LogSinks.get().setConsole(this.logger);
    }

    @NonNull
    public EnumSet<LogDomain> getDomains() {
        ConsoleLogSink curLogger = LogSinks.get().getConsole();
        if (curLogger == null) {
            return EnumSet.noneOf(LogDomain.class);
        }
        Set<LogDomain> curDomains = curLogger.getDomains();
        return curDomains.isEmpty() ? EnumSet.noneOf(LogDomain.class) : EnumSet.copyOf(curDomains);
    }

    public void setDomains(@NonNull EnumSet<LogDomain> domains) {
        LogSinks loggers = LogSinks.get();
        ConsoleLogSink curLogger = loggers.getConsole();
        if (curLogger != null && domains.equals(curLogger.getDomains())) {
            return;
        }
        this.logger = this.shimFactory(this.getLevel(), Preconditions.assertNotNull(domains, "domains"));
        loggers.setConsole(this.logger);
    }

    public void setDomains(LogDomain ... domains) {
        Preconditions.assertNotNull(domains, "domains");
        this.setDomains(domains.length <= 0 ? EnumSet.noneOf(LogDomain.class) : EnumSet.copyOf(Arrays.asList(domains)));
    }

    @Override
    public void log(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
        if (this.logger != null) {
            this.logger.doLog(level, domain, message);
        }
    }

    @VisibleForTesting
    @NonNull
    ShimLogger shimFactory(@NonNull LogLevel level, @NonNull EnumSet<LogDomain> domains) {
        return new ShimLogger(level, domains);
    }

    @VisibleForTesting
    static class ShimLogger
    extends ConsoleLogSink {
        ShimLogger(@NonNull LogLevel level, @Nullable EnumSet<LogDomain> logDomains) {
            super(level, (Collection<LogDomain>)logDomains);
        }

        @Override
        protected void writeLog(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
            this.doWriteLog(level, domain, message);
        }

        @VisibleForTesting
        protected void doWriteLog(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
            ConsoleLogSink curLogger = LogSinks.get().getConsole();
            if (this == curLogger) {
                super.writeLog(level, domain, message);
            }
        }

        void doLog(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
            super.log(level, domain, message);
        }

        @Override
        protected boolean isLegacy() {
            return true;
        }
    }
}

