/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Array;
import com.couchbase.lite.BaseDatabase;
import com.couchbase.lite.Blob;
import com.couchbase.lite.CBLConverter;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.DictionaryInterface;
import com.couchbase.lite.Fleece;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.lite.internal.fleece.FLEncodable;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MContext;
import com.couchbase.lite.internal.fleece.MDict;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.utils.JSONUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Dictionary
implements DictionaryInterface,
FLEncodable,
Iterable<String> {
    @NonNull
    protected final Object lock;
    @NonNull
    protected final MDict internalDict;

    Dictionary() {
        this(new MDict());
    }

    Dictionary(@NonNull MValue val, @Nullable MCollection parent) {
        this(new MDict(val, parent));
    }

    protected Dictionary(@NonNull MDict dict) {
        this.internalDict = dict;
        MContext context = dict.getContext();
        BaseDatabase db = context == null ? null : context.getDatabase();
        this.lock = db == null ? new Object() : db.getDbLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableDictionary toMutable() {
        Object object = this.lock;
        synchronized (object) {
            return new MutableDictionary(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count() {
        Object object = this.lock;
        synchronized (object) {
            return (int)this.internalDict.count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return !this.internalDict.get(key).isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<String> getKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.internalDict.getKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getValue(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return this.internalDict.get(key).asNative(this.internalDict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getString(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            Object obj = this.internalDict.get(key).asNative(this.internalDict);
            return obj instanceof String ? (String)obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Number getNumber(@NonNull String key) {
        Preconditions.assertNotEmpty(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asNumber(this.internalDict.get(key).asNative(this.internalDict));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asInteger(this.internalDict.get(key), this.internalDict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asLong(this.internalDict.get(key), this.internalDict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asFloat(this.internalDict.get(key), this.internalDict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asDouble(this.internalDict.get(key), this.internalDict);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            return CBLConverter.asBoolean(this.internalDict.get(key).asNative(this.internalDict));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Blob getBlob(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            Object obj = this.internalDict.get(key).asNative(this.internalDict);
            return obj instanceof Blob ? (Blob)obj : null;
        }
    }

    @Override
    @Nullable
    public Date getDate(@NonNull String key) {
        return JSONUtils.toDate(this.getString(Preconditions.assertNotNull(key, "key")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Array getArray(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            Object obj = this.internalDict.get(key).asNative(this.internalDict);
            return obj instanceof Array ? (Array)obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Dictionary getDictionary(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            Object obj = this.internalDict.get(key).asNative(this.internalDict);
            return obj instanceof Dictionary ? (Dictionary)obj : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object object = this.lock;
        synchronized (object) {
            for (String key : this.internalDict.getKeys()) {
                result.put(key, Fleece.toObject(this.internalDict.get(key).asNative(this.internalDict)));
            }
        }
        return result;
    }

    @Override
    @NonNull
    public String toJSON() throws CouchbaseLiteException {
        FLEncoder.JSONEncoder encoder = FLEncoder.getJSONEncoder();
        try {
            this.internalDict.encodeTo(encoder);
            String string = encoder.finishJSON();
            if (encoder != null) {
                encoder.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (encoder != null) {
                    try {
                        encoder.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e, "Cannot encode dictionary: " + this);
            }
        }
    }

    @Override
    @NonNull
    public Iterator<String> iterator() {
        return new DictionaryIterator();
    }

    @Override
    public void encodeTo(@NonNull FLEncoder enc) {
        this.internalDict.encodeTo(enc);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dictionary)) {
            return false;
        }
        Dictionary m = (Dictionary)o;
        if (m.count() != this.count()) {
            return false;
        }
        for (String key : this) {
            Object value = this.getValue(key);
            if (!(value != null ? !value.equals(m.getValue(key)) : m.getValue(key) != null || !m.contains(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        for (String key : this) {
            Object value = this.getValue(key);
            h += key.hashCode() ^ (value == null ? 0 : value.hashCode());
        }
        return h;
    }

    @NonNull
    public String toString() {
        StringBuilder buf = new StringBuilder("Dictionary{(").append(this.internalDict.getStateString()).append(')');
        boolean first = true;
        for (String key : this.getKeys()) {
            if (!first) {
                buf.append(", ");
            } else {
                first = false;
                buf.append(' ');
            }
            buf.append(key).append("=>").append(this.getValue(key));
        }
        return buf.append('}').toString();
    }

    protected boolean isEmpty() {
        return this.count() == 0;
    }

    private class DictionaryIterator
    implements Iterator<String> {
        private final long mutations;
        private final Iterator<String> iterator;

        DictionaryIterator() {
            this.mutations = Dictionary.this.internalDict.getLocalMutationCount();
            this.iterator = Dictionary.this.getKeys().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @Nullable
        public String next() {
            if (Dictionary.this.internalDict.getLocalMutationCount() != this.mutations) {
                throw new ConcurrentModificationException("Dictionary modified during iteration");
            }
            return this.iterator.next();
        }
    }
}

