/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.Collection;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.DictionaryInterface;
import com.couchbase.lite.DocContext;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.lite.MutableDocument;
import com.couchbase.lite.internal.core.C4Collection;
import com.couchbase.lite.internal.core.C4Document;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.fleece.MRoot;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Document
implements DictionaryInterface,
Iterable<String> {
    @NonNull
    private final Object lock = new Object();
    @NonNull
    private final String id;
    private final boolean mutable;
    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    @GuardedBy(value="lock")
    @NonNull
    private Dictionary internalDict;
    @GuardedBy(value="lock")
    @Nullable
    private C4Document c4Document;
    @GuardedBy(value="lock")
    @Nullable
    private Collection collection;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    @GuardedBy(value="lock")
    @Nullable
    private FLDict data;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    @GuardedBy(value="lock")
    @Nullable
    private MRoot root;
    @GuardedBy(value="lock")
    @Nullable
    private String revId;

    @Nullable
    static Document getDocumentOrNull(@NonNull Collection collection, @NonNull String id) throws CouchbaseLiteException {
        Preconditions.assertNotNull(collection, "collection");
        Preconditions.assertNotEmpty(id, "id");
        C4Document c4Doc = collection.getC4Document(id);
        if (c4Doc == null || c4Doc.isDocDeleted()) {
            return null;
        }
        return new Document(collection, id, c4Doc, false);
    }

    @NonNull
    static Document getDocumentWithDeleted(@NonNull Collection collection, @NonNull String id) throws CouchbaseLiteException {
        Preconditions.assertNotNull(collection, "collection");
        Preconditions.assertNotEmpty(id, "id");
        C4Document c4Doc = collection.getC4Document(id);
        if (c4Doc != null) {
            return new Document(collection, id, c4Doc, false);
        }
        throw new CouchbaseLiteException("Document not found: " + id, "CouchbaseLite", 7);
    }

    @NonNull
    static Document getDocumentWithRevisions(@NonNull Collection collection, @NonNull String id) throws CouchbaseLiteException {
        Preconditions.assertNotNull(collection, "collection");
        Preconditions.assertNotEmpty(id, "id");
        C4Document c4Doc = collection.getC4DocumentWithRevs(id);
        if (c4Doc != null) {
            return new Document(collection, id, c4Doc, false);
        }
        throw new CouchbaseLiteException("Document not found: " + id, "CouchbaseLite", 7);
    }

    protected Document(@Nullable Collection collection, @NonNull String id, @Nullable C4Document c4doc, boolean mutable) {
        this.collection = collection;
        this.id = Preconditions.assertNotNull(id, "id");
        this.mutable = mutable;
        this.setC4Document(c4doc, mutable);
    }

    Document(@NonNull Collection collection, @NonNull String id, @Nullable String revId, @NonNull FLDict body) {
        this(collection, id, null, false);
        this.revId = revId;
        this.setContentLocked(body, false);
    }

    @Nullable
    public Collection getCollection() {
        return this.collection;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getRevisionID() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4Document == null ? this.revId : this.c4Document.getSelectedRevID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimestamp() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4Document == null ? -1L : this.c4Document.getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSequence() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4Document == null ? 0L : this.c4Document.getSelectedSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableDocument toMutable() {
        Object object = this.lock;
        synchronized (object) {
            if (this.revId != null) {
                throw new UnsupportedOperationException("Editing replication filter documents not supported");
            }
        }
        return new MutableDocument(this);
    }

    @Override
    public int count() {
        return this.getContent().count();
    }

    @Override
    @NonNull
    public List<String> getKeys() {
        return this.getContent().getKeys();
    }

    @Override
    @Nullable
    public Object getValue(@NonNull String key) {
        return this.getContent().getValue(key);
    }

    @Override
    @Nullable
    public String getString(@NonNull String key) {
        return this.getContent().getString(key);
    }

    @Override
    @Nullable
    public Number getNumber(@NonNull String key) {
        return this.getContent().getNumber(key);
    }

    @Override
    public int getInt(@NonNull String key) {
        return this.getContent().getInt(key);
    }

    @Override
    public long getLong(@NonNull String key) {
        return this.getContent().getLong(key);
    }

    @Override
    public float getFloat(@NonNull String key) {
        return this.getContent().getFloat(key);
    }

    @Override
    public double getDouble(@NonNull String key) {
        return this.getContent().getDouble(key);
    }

    @Override
    public boolean getBoolean(@NonNull String key) {
        return this.getContent().getBoolean(key);
    }

    @Override
    @Nullable
    public Blob getBlob(@NonNull String key) {
        return this.getContent().getBlob(key);
    }

    @Override
    @Nullable
    public Date getDate(@NonNull String key) {
        return this.getContent().getDate(key);
    }

    @Override
    @Nullable
    public Array getArray(@NonNull String key) {
        return this.getContent().getArray(key);
    }

    @Override
    @Nullable
    public Dictionary getDictionary(@NonNull String key) {
        return this.getContent().getDictionary(key);
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        return this.getContent().toMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String toJSON() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.c4Document != null) {
                    return this.c4Document.bodyAsJSON(true);
                }
            }
        }
        catch (LiteCoreException e) {
            Log.i(LogDomain.DATABASE, "Failed encoding document as JSON", CouchbaseLiteException.convertException(e));
        }
        return null;
    }

    @Override
    public boolean contains(@NonNull String key) {
        return this.getContent().contains(key);
    }

    @VisibleForTesting
    @Nullable
    public String getRevisionHistory() throws CouchbaseLiteException {
        Object object = this.lock;
        synchronized (object) {
            if (this.c4Document == null) {
                return null;
            }
            if (this.collection == null) {
                throw new CouchbaseLiteException("Document has no collection");
            }
            C4Collection c4Coll = this.collection.getOpenC4Collection();
            try {
                return this.c4Document.getRevisionHistory(c4Coll, Integer.MAX_VALUE, null);
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e);
            }
        }
    }

    @Override
    @NonNull
    public Iterator<String> iterator() {
        return this.internalDict.iterator();
    }

    public boolean equals(@Nullable Object o) {
        Database otherDb;
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document doc = (Document)o;
        Database db = this.getDatabase();
        if (!Objects.equals(db, otherDb = doc.getDatabase())) {
            return false;
        }
        if (!this.id.equals(doc.id)) {
            return false;
        }
        return this.getContent().equals(doc.getContent());
    }

    public int hashCode() {
        String path;
        Database db = this.getDatabase();
        int result = 0;
        if (db != null && (path = db.getPath()) != null) {
            result = path.hashCode();
        }
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.getContent().hashCode();
        return result;
    }

    @NonNull
    public String toString() {
        StringBuilder buf = new StringBuilder("Document{").append(ClassUtils.objId(this)).append(this.id).append('@').append(this.getRevisionID()).append('(').append(this.isMutable() ? (char)'+' : '.').append(this.isDeleted() ? (char)'?' : '.').append("):");
        boolean first = true;
        for (String key : this.getKeys()) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(key).append("=>").append(this.getValue(key));
        }
        return buf.append('}').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected final Dictionary getContent() {
        Object object = this.lock;
        synchronized (object) {
            return this.internalDict;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setContent(@NonNull Dictionary content) {
        Preconditions.assertNotNull(content, "content");
        Object object = this.lock;
        synchronized (object) {
            this.internalDict = content;
        }
    }

    final boolean isMutable() {
        return this.mutable;
    }

    int compareAge(@NonNull Document target) {
        return Long.compare(this.getTimestamp(), target.getTimestamp());
    }

    final boolean isEmpty() {
        return this.getContent().isEmpty();
    }

    final boolean isNewDocument() {
        return this.getRevisionID() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean exists() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4Document != null && this.c4Document.docExists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isDeleted() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4Document != null && this.c4Document.isRevDeleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final Database getDatabase() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection == null ? null : this.collection.getDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCollection(@Nullable Collection collection) {
        Object object = this.lock;
        synchronized (object) {
            this.collection = collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final C4Document getC4doc() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4Document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void replaceC4Document(@Nullable C4Document c4doc) {
        Object object = this.lock;
        synchronized (object) {
            this.updateC4DocumentLocked(c4doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean selectConflictingRevision() throws LiteCoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.c4Document == null) {
                return false;
            }
            boolean foundConflict = false;
            while (!foundConflict) {
                try {
                    this.c4Document.selectNextLeafRevision(true, true);
                }
                catch (LiteCoreException e) {
                    if (e.code == 0) break;
                    throw e;
                }
                foundConflict = this.c4Document.isRevConflicted();
            }
            if (foundConflict) {
                this.setC4Document(this.c4Document, this.isMutable());
            }
            return foundConflict;
        }
    }

    @NonNull
    final FLSliceResult encode() throws LiteCoreException {
        Database db = this.getDatabase();
        if (db == null) {
            throw new CouchbaseLiteError("encode called with null database");
        }
        try (FLEncoder encoder = db.getSharedFleeceEncoder();){
            encoder.setArg("BLOB.db", this.getDatabase());
            this.getContent().encodeTo(encoder);
            FLSliceResult fLSliceResult = encoder.finish2();
            return fLSliceResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setC4Document(@Nullable C4Document c4doc, boolean mutable) {
        Object object = this.lock;
        synchronized (object) {
            this.updateC4DocumentLocked(c4doc);
            this.setContentLocked(c4doc == null || c4doc.isRevDeleted() ? null : c4doc.getSelectedBody2(), mutable);
        }
    }

    @GuardedBy(value="lock")
    private void updateC4DocumentLocked(@Nullable C4Document c4Doc) {
        if (this.c4Document == c4Doc) {
            return;
        }
        this.c4Document = c4Doc;
        if (c4Doc != null) {
            this.revId = null;
        }
    }

    @GuardedBy(value="lock")
    private void setContentLocked(@Nullable FLDict data, boolean mutable) {
        this.data = data;
        if (data == null) {
            this.internalDict = mutable ? new MutableDictionary() : new Dictionary();
            this.root = null;
            return;
        }
        Database db = this.getDatabase();
        if (db == null) {
            throw new CouchbaseLiteError("document has not been saved to a database");
        }
        MRoot newRoot = new MRoot(new DocContext(db, this.c4Document), data.toFLValue(), mutable);
        this.internalDict = (Dictionary)Preconditions.assertNotNull(newRoot.asNative(), "root dictionary");
        this.root = newRoot;
    }
}

