/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Collection;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.DocumentChange;
import com.couchbase.lite.internal.core.C4DocumentObserver;
import com.couchbase.lite.internal.listener.ChangeNotifier;
import com.couchbase.lite.internal.utils.Fn;

final class DocumentChangeNotifier
extends ChangeNotifier<DocumentChange>
implements AutoCloseable {
    @NonNull
    private final Collection collection;
    @NonNull
    private final String docID;
    @Nullable
    private C4DocumentObserver c4Observer;

    DocumentChangeNotifier(@NonNull Collection collection, @NonNull String docID) {
        this.collection = collection;
        this.docID = docID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.collection.getDbLock();
        synchronized (object) {
            if (this.c4Observer != null) {
                this.c4Observer.close();
            }
            this.c4Observer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(@NonNull Fn.Consumer<Runnable> onChange) throws CouchbaseLiteException {
        Object object = this.collection.getDbLock();
        synchronized (object) {
            this.c4Observer = this.collection.createDocumentObserver(this.docID, () -> onChange.accept(this::documentChanged));
        }
    }

    private void documentChanged() {
        this.postChange(new DocumentChange(this.collection, this.docID));
    }
}

