/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.DocumentReplication;
import com.couchbase.lite.DocumentReplicationListener;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.concurrent.Executor;

final class DocumentReplicationListenerToken
extends ListenerToken {
    @NonNull
    private final DocumentReplicationListener listener;

    DocumentReplicationListenerToken(@Nullable Executor executor, @NonNull DocumentReplicationListener listener, @NonNull Fn.Consumer<ListenerToken> onRemove) {
        super(executor, onRemove);
        this.listener = Preconditions.assertNotNull(listener, "listener");
    }

    @Override
    @NonNull
    public String toString() {
        return "DocumentReplicationListenerToken{" + this.listener + super.toString() + "}";
    }

    void postChange(@NonNull DocumentReplication change) {
        this.send(() -> this.listener.replication(change));
    }
}

