/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogFileConfiguration;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.Logger;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import com.couchbase.lite.logging.FileLogSink;
import com.couchbase.lite.logging.LogSinks;
import java.util.Objects;

@Deprecated
public final class FileLogger
implements Logger {
    @Nullable
    private LogFileConfiguration configuration;
    @Nullable
    private ShimLogger logger;

    FileLogger() {
    }

    @Override
    @NonNull
    public LogLevel getLevel() {
        FileLogSink curLogger = LogSinks.get().getFile();
        return curLogger == null ? LogLevel.NONE : curLogger.getLevel();
    }

    public void setLevel(@NonNull LogLevel level) {
        Preconditions.assertNotNull(level, "level");
        LogFileConfiguration config = this.configuration;
        if (config == null) {
            throw new CouchbaseLiteError(Log.lookupStandardMessage("CannotSetLogLevel"));
        }
        LogLevel curLevel = this.getLevel();
        if (curLevel == level) {
            return;
        }
        this.installLogger(config, level);
    }

    @Nullable
    public LogFileConfiguration getConfig() {
        FileLogSink fileLogger = LogSinks.get().getFile();
        return fileLogger == null ? null : new LogFileConfiguration(fileLogger.getDirectory(), fileLogger.getMaxFileSize(), fileLogger.getMaxKeptFiles() - 1, fileLogger.isPlainText(), true);
    }

    public void setConfig(@Nullable LogFileConfiguration newConfig) {
        if (Objects.equals(this.getConfig(), newConfig)) {
            return;
        }
        LogFileConfiguration config = newConfig == null ? null : new LogFileConfiguration(newConfig);
        this.installLogger(config, this.getLevel());
        this.configuration = config;
    }

    @Override
    public void log(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
        if (this.logger != null) {
            this.logger.doLog(level, domain, message);
        }
    }

    private void installLogger(@Nullable LogFileConfiguration config, @NonNull LogLevel level) {
        ShimLogger newLogger = config == null ? null : new ShimLogger(new FileLogSink.Builder().setDirectory(config.getDirectory()).setLevel(level).setMaxKeptFiles(config.getMaxRotateCount() + 1).setMaxFileSize(config.getMaxSize()).setPlainText(config.usesPlaintext()));
        LogSinks.get().setFile(newLogger);
        this.logger = newLogger;
    }

    private static final class ShimLogger
    extends FileLogSink {
        ShimLogger(@NonNull FileLogSink.Builder builder) {
            super(builder);
        }

        @Override
        protected void writeLog(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
            FileLogSink curLogger = LogSinks.get().getFile();
            if (this == curLogger) {
                super.writeLog(level, domain, message);
            }
        }

        void doLog(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
            super.log(level, domain, message);
        }

        @Override
        protected boolean isLegacy() {
            return true;
        }
    }
}

