/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.IndexConfiguration;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.internal.QueryLanguage;
import com.couchbase.lite.internal.core.C4Collection;
import com.couchbase.lite.internal.utils.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public final class FullTextIndexConfiguration
extends IndexConfiguration {
    @Nullable
    private String language = Locale.getDefault().getLanguage();
    private boolean ignoreDiacrits = false;
    @Nullable
    private String where;

    public FullTextIndexConfiguration(String ... expressions) {
        this(Arrays.asList(expressions));
    }

    public FullTextIndexConfiguration(@NonNull List<String> expressions) {
        super(expressions);
    }

    @NonNull
    public FullTextIndexConfiguration setLanguage(@Nullable String language) {
        this.language = StringUtils.isEmpty(language) ? null : language;
        return this;
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    @NonNull
    public FullTextIndexConfiguration ignoreAccents(boolean ignoreAccents) {
        this.ignoreDiacrits = ignoreAccents;
        return this;
    }

    public boolean isIgnoringAccents() {
        return this.ignoreDiacrits;
    }

    @Nullable
    public String getWhere() {
        return this.where;
    }

    @NonNull
    public FullTextIndexConfiguration setWhere(@Nullable String where) {
        this.where = where;
        return this;
    }

    @Override
    void createIndex(@NonNull String name, @NonNull C4Collection c4Collection) throws LiteCoreException {
        c4Collection.createFullTextIndex(name, QueryLanguage.N1QL.getCode(), this.getIndexSpec(), this.language, this.ignoreDiacrits, this.where);
    }
}

