/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import com.couchbase.lite.internal.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class IndexConfiguration
extends AbstractIndex {
    @NonNull
    private final List<String> expressions;

    IndexConfiguration(String ... expressions) {
        this(Arrays.asList(expressions));
    }

    IndexConfiguration(@NonNull List<String> expressions) {
        this.expressions = Fn.filterToList(Preconditions.assertNotEmpty(expressions, "expressions"), s -> s != null);
        if (expressions.size() != this.expressions.size()) {
            throw new IllegalArgumentException("Expressions may not be null");
        }
    }

    @NonNull
    public final List<String> getExpressions() {
        return new ArrayList<String>(this.expressions);
    }

    @Override
    @NonNull
    final String getIndexSpec() {
        return StringUtils.join(",", this.expressions);
    }
}

