/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Objects;

@Deprecated
public final class LogFileConfiguration {
    private final boolean readonly;
    @NonNull
    private final String directory;
    private boolean usePlaintext;
    private int maxRotateCount;
    private long maxSize;

    public LogFileConfiguration(@NonNull String directory) {
        this(directory, null);
    }

    public LogFileConfiguration(@NonNull LogFileConfiguration config) {
        this(config == null ? null : config.getDirectory(), config);
    }

    public LogFileConfiguration(@NonNull String directory, @Nullable LogFileConfiguration config) {
        this(directory, config, false);
    }

    LogFileConfiguration(@NonNull String directory, @Nullable LogFileConfiguration config, boolean readonly) {
        this(directory, config == null ? null : Long.valueOf(config.maxSize), config == null ? null : Integer.valueOf(config.maxRotateCount), config == null ? null : Boolean.valueOf(config.usePlaintext), readonly);
    }

    LogFileConfiguration(@NonNull String directory, @Nullable Long maxSize, @Nullable Integer maxRotateCount, @Nullable Boolean usePlaintext, boolean readonly) {
        this.directory = Preconditions.assertNotNull(directory, "directory");
        this.maxSize = maxSize != null ? maxSize : 524288L;
        this.maxRotateCount = maxRotateCount != null ? maxRotateCount : 1;
        this.usePlaintext = usePlaintext != null ? usePlaintext : false;
        this.readonly = readonly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogFileConfiguration)) {
            return false;
        }
        LogFileConfiguration that = (LogFileConfiguration)o;
        return this.maxSize == that.maxSize && this.maxRotateCount == that.maxRotateCount && this.usePlaintext == that.usePlaintext && this.directory.equals(that.directory);
    }

    public int hashCode() {
        return Objects.hash(this.directory);
    }

    @NonNull
    public String toString() {
        return "LogFileConfig{" + (this.readonly ? "" : "!") + (this.usePlaintext ? "+" : "") + this.directory + ", " + this.maxSize + ", " + this.maxRotateCount + "}";
    }

    @NonNull
    public LogFileConfiguration setMaxSize(long maxSize) {
        if (this.readonly) {
            throw new CouchbaseLiteError("LogFileConfiguration is readonly mode.");
        }
        this.maxSize = Preconditions.assertNotNegative(maxSize, "max size");
        return this;
    }

    @NonNull
    public LogFileConfiguration setMaxRotateCount(int maxRotateCount) {
        if (this.readonly) {
            throw new CouchbaseLiteError("LogFileConfiguration is readonly mode.");
        }
        this.maxRotateCount = Preconditions.assertNotNegative(maxRotateCount, "max rotation count");
        return this;
    }

    @NonNull
    public LogFileConfiguration setUsePlaintext(boolean usePlaintext) {
        if (this.readonly) {
            throw new CouchbaseLiteError("LogFileConfiguration is readonly mode.");
        }
        this.usePlaintext = usePlaintext;
        return this;
    }

    @NonNull
    public String getDirectory() {
        return this.directory;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public int getMaxRotateCount() {
        return this.maxRotateCount;
    }

    public boolean usesPlaintext() {
        return this.usePlaintext;
    }
}

