/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Expression;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;

public final class PropertyExpression
extends Expression {
    static final String PROPS_ALL = "";
    @NonNull
    private final String keyPath;
    @Nullable
    private final String fromAlias;

    @NonNull
    static PropertyExpression allFrom(@Nullable String from) {
        return new PropertyExpression(PROPS_ALL, from);
    }

    PropertyExpression(@NonNull String keyPath) {
        this(keyPath, null);
    }

    private PropertyExpression(@NonNull String keyPath, @Nullable String fromAlias) {
        this.keyPath = keyPath;
        this.fromAlias = fromAlias;
    }

    @NonNull
    public Expression from(@NonNull String fromAlias) {
        Preconditions.assertNotNull(fromAlias, "fromAlias");
        return new PropertyExpression(this.keyPath, fromAlias);
    }

    @Override
    @NonNull
    Object asJSON() {
        ArrayList<String> json = new ArrayList<String>();
        json.add("." + (this.fromAlias == null ? PROPS_ALL : this.fromAlias + ".") + this.keyPath);
        return json;
    }
}

