/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import com.couchbase.lite.internal.BaseAuthenticator;
import com.couchbase.lite.internal.utils.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class ProxyAuthenticator
extends BaseAuthenticator {
    @NonNull
    private final String username;
    @NonNull
    private final char[] password;

    public ProxyAuthenticator(@NonNull String username, @NonNull char[] password) {
        int n;
        this.username = Preconditions.assertNotEmpty(username, "user name");
        int n2 = n = password == null ? 0 : password.length;
        if (n <= 0) {
            throw new IllegalArgumentException("empty password");
        }
        char[] pwd = new char[n];
        System.arraycopy(password, 0, pwd, 0, n);
        this.password = pwd;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @NonNull
    public char[] getPassword() {
        char[] pwd = new char[this.password.length];
        System.arraycopy(this.password, 0, pwd, 0, pwd.length);
        return pwd;
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProxyAuthenticator)) {
            return false;
        }
        ProxyAuthenticator other = (ProxyAuthenticator)o;
        return this.username.equals(other.username) && MessageDigest.isEqual(new String(this.password).getBytes(StandardCharsets.UTF_8), new String(other.password).getBytes(StandardCharsets.UTF_8));
    }

    protected void finalize() throws Throwable {
        try {
            Arrays.fill(this.password, '\u0000');
        }
        finally {
            super.finalize();
        }
    }

    @Override
    protected void authenticate(@NonNull Map<String, Object> options) {
        HashMap<String, String> auth = (HashMap<String, String>)options.get("auth");
        if (auth == null) {
            auth = new HashMap<String, String>();
            options.put("auth", auth);
        }
        auth.put("proxyUser", this.username);
        auth.put("proxyPassword", (String)this.password);
    }
}

