/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.ReplicatorActivityLevel;
import com.couchbase.lite.ReplicatorProgress;
import com.couchbase.lite.internal.core.C4ReplicatorStatus;
import com.couchbase.lite.internal.logging.Log;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ReplicatorStatus {
    static final ReplicatorStatus INIT = new ReplicatorStatus(ReplicatorActivityLevel.STOPPED, new ReplicatorProgress(0L, 0L), null);
    @NonNull
    private static final Map<Integer, ReplicatorActivityLevel> ACTIVITY_LEVEL_FROM_C4;
    @NonNull
    private final ReplicatorActivityLevel activityLevel;
    @NonNull
    private final ReplicatorProgress progress;
    @Nullable
    private final CouchbaseLiteException error;

    @NonNull
    private static ReplicatorActivityLevel getActivityLevelFromC4(int c4ActivityLevel) {
        ReplicatorActivityLevel level = ACTIVITY_LEVEL_FROM_C4.get(c4ActivityLevel);
        if (level != null) {
            return level;
        }
        Log.w(LogDomain.REPLICATOR, "Unrecognized replicator activity level: " + c4ActivityLevel);
        return ReplicatorActivityLevel.BUSY;
    }

    @Nullable
    private static CouchbaseLiteException convertC4StatusError(@NonNull C4ReplicatorStatus c4Status) {
        int errorCode = c4Status.getErrorCode();
        return errorCode == 0 ? null : CouchbaseLiteException.toCouchbaseLiteException(c4Status.getErrorDomain(), errorCode, c4Status.getErrorInternalInfo());
    }

    ReplicatorStatus(@NonNull C4ReplicatorStatus c4Status) {
        this(ReplicatorStatus.getActivityLevelFromC4(c4Status.getActivityLevel()), new ReplicatorProgress((int)c4Status.getProgressUnitsCompleted(), (int)c4Status.getProgressUnitsTotal()), ReplicatorStatus.convertC4StatusError(c4Status));
    }

    ReplicatorStatus(@NonNull ReplicatorStatus status) {
        this(status.activityLevel, status.progress, status.error);
    }

    ReplicatorStatus(@NonNull ReplicatorActivityLevel activityLevel, @NonNull ReplicatorProgress progress, @Nullable CouchbaseLiteException error) {
        this.activityLevel = activityLevel;
        this.progress = progress;
        this.error = error;
    }

    @NonNull
    public ReplicatorActivityLevel getActivityLevel() {
        return this.activityLevel;
    }

    @NonNull
    public ReplicatorProgress getProgress() {
        return this.progress;
    }

    @Nullable
    public CouchbaseLiteException getError() {
        return this.error;
    }

    @NonNull
    public String toString() {
        return "Status{activityLevel=" + (Object)((Object)this.activityLevel) + ", progress=" + this.progress + ", error=" + this.error + '}';
    }

    static {
        HashMap<Integer, ReplicatorActivityLevel> m = new HashMap<Integer, ReplicatorActivityLevel>();
        m.put(0, ReplicatorActivityLevel.STOPPED);
        m.put(1, ReplicatorActivityLevel.OFFLINE);
        m.put(2, ReplicatorActivityLevel.CONNECTING);
        m.put(3, ReplicatorActivityLevel.IDLE);
        m.put(4, ReplicatorActivityLevel.BUSY);
        ACTIVITY_LEVEL_FROM_C4 = Collections.unmodifiableMap(m);
    }
}

