/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.AbstractDatabase;
import com.couchbase.lite.AbstractQuery;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.Result;
import com.couchbase.lite.ResultContext;
import com.couchbase.lite.internal.core.C4QueryEnumerator;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResultSet
implements Iterable<Result>,
AutoCloseable {
    private static final LogDomain DOMAIN = LogDomain.QUERY;
    @NonNull
    private final Object lock = new Object();
    @NonNull
    private final AbstractQuery query;
    @NonNull
    private final Map<String, Integer> columnNames;
    @NonNull
    private final ResultContext context;
    @GuardedBy(value="lock")
    @Nullable
    private C4QueryEnumerator c4enum;
    @GuardedBy(value="lock")
    private boolean isAllEnumerated;

    ResultSet(@NonNull AbstractQuery query, @Nullable C4QueryEnumerator c4enum, @NonNull Map<String, Integer> cols) {
        this.query = Preconditions.assertNotNull(query, "query");
        this.columnNames = Preconditions.assertNotNull(cols, "columns");
        this.context = new ResultContext(query.getDatabase(), this);
        this.c4enum = c4enum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Result next() {
        LiteCoreException err;
        Object object = this.lock;
        synchronized (object) {
            if (this.c4enum == null || this.isAllEnumerated) {
                return null;
            }
            try {
                if (!this.c4enum.next()) {
                    this.isAllEnumerated = true;
                    return null;
                }
                return new Result(this.context, this.c4enum);
            }
            catch (LiteCoreException e) {
                err = e;
            }
        }
        Log.i(DOMAIN, "Error enumerating query", err);
        return null;
    }

    @NonNull
    public List<Result> allResults() {
        Result result;
        ArrayList<Result> results = new ArrayList<Result>();
        while ((result = this.next()) != null) {
            results.add(result);
        }
        return results;
    }

    @Override
    @NonNull
    public Iterator<Result> iterator() {
        return this.allResults().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        C4QueryEnumerator qEnum;
        Object object = this.lock;
        synchronized (object) {
            qEnum = this.c4enum;
            this.c4enum = null;
        }
        if (qEnum == null) {
            return;
        }
        AbstractDatabase db = this.context.getDatabase();
        if (db == null) {
            throw new CouchbaseLiteError("Could not obtain db lock");
        }
        Object object2 = db.getDbLock();
        synchronized (object2) {
            qEnum.close();
        }
    }

    protected void finalize() throws Throwable {
        try {
            C4QueryEnumerator qEnum = this.c4enum;
            if (qEnum != null) {
                qEnum.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @NonNull
    AbstractQuery getQuery() {
        return this.query;
    }

    int getColumnCount() {
        return this.columnNames.size();
    }

    @NonNull
    List<String> getColumnNames() {
        return new ArrayList<String>(this.columnNames.keySet());
    }

    int getColumnIndex(@NonNull String name) {
        Integer idx = this.columnNames.get(name);
        return idx == null ? -1 : idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4enum == null;
        }
    }
}

