/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Collection;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import java.util.Objects;
import java.util.Set;

public class Scope {
    public static final String DEFAULT_NAME = "_default";
    @NonNull
    private final String name;
    @NonNull
    private final Database db;

    Scope(@NonNull Database db) {
        this(DEFAULT_NAME, db);
    }

    Scope(@NonNull String name, @NonNull Database db) {
        this.name = name;
        this.db = db;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public Set<Collection> getCollections() throws CouchbaseLiteException {
        return this.db.getCollections(this.name);
    }

    @Nullable
    public Collection getCollection(@NonNull String collectionName) throws CouchbaseLiteException {
        return this.db.getCollection(collectionName, this.name);
    }

    @NonNull
    public Database getDatabase() {
        return this.db;
    }

    @NonNull
    public String toString() {
        return this.db.getName() + "." + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Scope)) {
            return false;
        }
        Scope other = (Scope)o;
        return this.db == other.db && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.db);
    }
}

