/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Expression;
import com.couchbase.lite.PropertyExpression;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;

public class SelectResult {
    @NonNull
    private Expression selectExpression;

    @NonNull
    public static As property(@NonNull String property) {
        Preconditions.assertNotNull(property, "property");
        return new As(PropertyExpression.property(property));
    }

    @NonNull
    public static As expression(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, "expression");
        return new As(expression);
    }

    @NonNull
    public static From all() {
        return new From(PropertyExpression.allFrom(null));
    }

    protected SelectResult(@NonNull Expression expression) {
        this.selectExpression = expression;
    }

    protected final void setExpression(@NonNull Expression expression) {
        this.selectExpression = expression;
    }

    @Nullable
    Object asJSON() {
        return this.selectExpression.asJSON();
    }

    public static final class As
    extends SelectResult {
        @Nullable
        private String alias;

        private As(@NonNull Expression expression) {
            super(expression);
        }

        @NonNull
        public As as(@NonNull String alias) {
            Preconditions.assertNotNull(alias, "alias");
            this.alias = alias;
            return this;
        }

        @Override
        @Nullable
        Object asJSON() {
            Object prop = super.asJSON();
            if (this.alias == null) {
                return prop;
            }
            ArrayList<Object> json = new ArrayList<Object>();
            json.add("AS");
            json.add(prop);
            json.add(this.alias);
            return json;
        }
    }

    public static final class From
    extends SelectResult {
        private From(@NonNull Expression expression) {
            super(expression);
        }

        @NonNull
        public SelectResult from(@NonNull String alias) {
            Preconditions.assertNotNull(alias, "alias");
            this.setExpression(PropertyExpression.allFrom(alias));
            return this;
        }
    }
}

