/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Authenticator;
import com.couchbase.lite.internal.BaseAuthenticator;
import com.couchbase.lite.internal.utils.Preconditions;
import com.couchbase.lite.internal.utils.StringUtils;
import java.util.Map;

public final class SessionAuthenticator
extends BaseAuthenticator
implements Authenticator {
    private static final String DEFAULT_SYNC_GATEWAY_SESSION_ID_NAME = "SyncGatewaySession";
    @NonNull
    private final String sessionID;
    @NonNull
    private final String cookieName;

    public SessionAuthenticator(@NonNull String sessionID) {
        this(sessionID, DEFAULT_SYNC_GATEWAY_SESSION_ID_NAME);
    }

    public SessionAuthenticator(@NonNull String sessionID, @Nullable String cookieName) {
        this.sessionID = Preconditions.assertNotNull(sessionID, "sessionID");
        this.cookieName = cookieName != null ? cookieName : DEFAULT_SYNC_GATEWAY_SESSION_ID_NAME;
    }

    @NonNull
    public String getSessionID() {
        return this.sessionID;
    }

    @NonNull
    public String getCookieName() {
        return this.cookieName;
    }

    @Override
    protected void authenticate(@NonNull Map<String, Object> options) {
        StringBuilder cookies = new StringBuilder(this.cookieName).append('=').append(this.sessionID);
        String curCookies = (String)options.get("cookies");
        if (!StringUtils.isEmpty(curCookies)) {
            cookies.append("; ").append(curCookies);
        }
        options.put("cookies", cookies.toString());
    }
}

